/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codesamples;

import com.amazonaws.codesamples.RetrievedCodeSample;
import com.amazonaws.codesamples.SampleCodeXMLParser;
import com.amazonaws.codesamples.exception.SampleRetrievalException;
import com.amazonaws.codesamples.util.ValidationUtils;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class SampleCodeReader {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private final String sampleDir;
    private final SAXParser saxParser;

    public SampleCodeReader(String sampleDir) throws Exception {
        this.sampleDir = ValidationUtils.assertInputNotEmpty(sampleDir, "Sample directory must be provided");
        this.saxParser = parserFactory.newSAXParser();
    }

    public RetrievedCodeSample readSample(String serviceName, String sampleId) throws SampleRetrievalException {
        ValidationUtils.assertInputNotEmpty(serviceName, "Sample service name must be provided");
        ValidationUtils.assertInputNotEmpty(sampleId, "Sample ID must be provided");
        String targetSampleFile = String.format("/%s/%s.xml", this.sampleDir, serviceName);
        InputStream in = this.getClass().getResourceAsStream(targetSampleFile);
        if (in == null) {
            return null;
        }
        SampleCodeXMLParser parser = new SampleCodeXMLParser(sampleId);
        try {
            this.saxParser.parse(in, (DefaultHandler)parser);
        }
        catch (Exception e) {
            throw new SampleRetrievalException("Could not parse sample", serviceName, sampleId, e);
        }
        String sampleContent = parser.getSampleContent();
        String sampleTitle = parser.getSampleTitle();
        String sampleDescription = parser.getSampleDescription();
        if (ValidationUtils.areNullOrEmpty(sampleContent, sampleTitle, sampleDescription)) {
            return null;
        }
        return new RetrievedCodeSample(sampleId, serviceName, sampleTitle, sampleDescription, sampleContent);
    }
}

