/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codesamples;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SampleCodeXMLParser
extends DefaultHandler {
    private static final String SAMPLE_ELEMENT = "sample";
    private static final String CONTENT_ELEMENT = "content";
    private static final String ID_ATTRIBUTE = "id";
    private static final String TITLE_ATTRIBUTE = "title";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private boolean inTargetSample = false;
    private boolean inTargetContent = false;
    private StringBuffer sampleBuffer = new StringBuffer();
    private final String sampleId;
    private String sampleTitle;
    private String sampleDescription;
    private String sampleContent;

    public SampleCodeXMLParser(String sampleId) {
        this.sampleId = sampleId;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String idAttr;
        if (qName.equals(SAMPLE_ELEMENT) && (idAttr = attributes.getValue(ID_ATTRIBUTE)) != null && idAttr.equals(this.sampleId)) {
            this.inTargetSample = true;
            this.sampleTitle = attributes.getValue(TITLE_ATTRIBUTE);
            this.sampleDescription = attributes.getValue(DESCRIPTION_ATTRIBUTE);
        }
        if (qName.equals(CONTENT_ELEMENT) && this.inTargetSample) {
            this.inTargetContent = true;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inTargetContent) {
            this.sampleBuffer.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (this.inTargetContent) {
            this.sampleContent = this.sampleBuffer.toString();
            this.inTargetContent = false;
        }
        this.inTargetSample = false;
    }

    public String getSampleTitle() {
        return this.sampleTitle;
    }

    public String getSampleDescription() {
        return this.sampleDescription;
    }

    public String getSampleContent() {
        return this.sampleContent;
    }
}

