/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codesamples.util;

import com.amazonaws.codesamples.RetrievedCodeSample;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleHTMLTemplates {
    private static final String SAMPLE_TAG = "${SAMPLES}";
    private static final String TITLE_TAG = "${TITLE}";
    private static final String DESCRIPTION_TAG = "${DESCRIPTION}";
    private static final String CONTENT_TAG = "${CONTENT}";
    private static final String SAMPLES_SECTION = "<br/><b>Samples:</b><ul class=\"sampleList\"><li class=\"sampleList\">${SAMPLES}</li></ul>";
    private static final String SAMPLE = "<h5>${TITLE}</h5><div class=\"block\">${DESCRIPTION}<br/> <pre class=\"brush: java\">${CONTENT}</pre></div>";

    public static String getSampleHTML(String title, String description, String content) {
        return SAMPLE.replace(TITLE_TAG, title).replace(DESCRIPTION_TAG, description).replace(CONTENT_TAG, content);
    }

    public static String getSampleSectionHTML(List<RetrievedCodeSample> samples) {
        StringBuilder samplesHTML = new StringBuilder();
        for (RetrievedCodeSample sample : samples) {
            samplesHTML.append(SampleHTMLTemplates.getSampleHTML(sample.getTitle(), sample.getDescription(), sample.getContent()));
        }
        return SAMPLES_SECTION.replace(SAMPLE_TAG, samplesHTML.toString());
    }
}

