/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codesamples;

import com.amazonaws.codesamples.RetrievedCodeSample;
import com.amazonaws.codesamples.SampleCodeReader;
import com.amazonaws.codesamples.util.SampleHTMLTemplates;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleCodeTaglet
implements Taglet {
    private static final String SAMPLE_TAG = "sample";
    private static final String SAMPLES_DIRECTORY = "samples";
    private static final Pattern SAMPLE_TAG_PATTERN = Pattern.compile("([^\\s.]+)\\.([^\\s.]+)$");
    private SampleCodeReader reader;

    public SampleCodeTaglet() {
        try {
            this.reader = new SampleCodeReader(SAMPLES_DIRECTORY);
        }
        catch (Exception e) {
            System.err.println("Could not initialize sample reader for taglet processor.  Code samples will not be injected.");
            e.printStackTrace();
        }
    }

    public String getName() {
        return SAMPLE_TAG;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inField() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    public boolean isInlineTag() {
        return false;
    }

    public static void register(Map<String, Taglet> tagletMap) {
        Taglet taglet = tagletMap.get(SAMPLE_TAG);
        if (taglet != null) {
            tagletMap.remove(SAMPLE_TAG);
        }
        tagletMap.put(SAMPLE_TAG, new SampleCodeTaglet());
    }

    public String toString(Tag tag) {
        Tag[] singletonTag = new Tag[]{tag};
        return this.toString(singletonTag);
    }

    public String toString(Tag[] tags) {
        if (tags.length == 0) {
            return null;
        }
        ArrayList<RetrievedCodeSample> samples = new ArrayList<RetrievedCodeSample>();
        for (int i = 0; i < tags.length; ++i) {
            String tagText = tags[i].text();
            Matcher sampleTagMatcher = SAMPLE_TAG_PATTERN.matcher(tagText);
            if (sampleTagMatcher.find()) {
                String serviceName = sampleTagMatcher.group(1);
                String sampleId = sampleTagMatcher.group(2);
                try {
                    RetrievedCodeSample sample = this.reader.readSample(serviceName, sampleId);
                    if (sample == null) continue;
                    samples.add(sample);
                }
                catch (Exception e) {
                    System.err.println("Could not parse tag: " + tagText);
                    e.printStackTrace();
                }
                continue;
            }
            System.err.println("Sample tag did not match expected format: " + tagText);
        }
        if (!samples.isEmpty()) {
            return SampleHTMLTemplates.getSampleSectionHTML(samples);
        }
        return "";
    }
}

