/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securityhub.model.AwsSecurityFindingFilters;
import com.amazonaws.services.securityhub.model.SortCriterion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetFindingsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private AwsSecurityFindingFilters filters;
    private List<SortCriterion> sortCriteria;
    private String nextToken;
    private Integer maxResults;

    public void setFilters(AwsSecurityFindingFilters filters) {
        this.filters = filters;
    }

    public AwsSecurityFindingFilters getFilters() {
        return this.filters;
    }

    public GetFindingsRequest withFilters(AwsSecurityFindingFilters filters) {
        this.setFilters(filters);
        return this;
    }

    public List<SortCriterion> getSortCriteria() {
        return this.sortCriteria;
    }

    public void setSortCriteria(Collection<SortCriterion> sortCriteria) {
        if (sortCriteria == null) {
            this.sortCriteria = null;
            return;
        }
        this.sortCriteria = new ArrayList<SortCriterion>(sortCriteria);
    }

    public GetFindingsRequest withSortCriteria(SortCriterion ... sortCriteria) {
        if (this.sortCriteria == null) {
            this.setSortCriteria(new ArrayList<SortCriterion>(sortCriteria.length));
        }
        for (SortCriterion ele : sortCriteria) {
            this.sortCriteria.add(ele);
        }
        return this;
    }

    public GetFindingsRequest withSortCriteria(Collection<SortCriterion> sortCriteria) {
        this.setSortCriteria(sortCriteria);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetFindingsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetFindingsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getSortCriteria() != null) {
            sb.append("SortCriteria: ").append(this.getSortCriteria()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsRequest)) {
            return false;
        }
        GetFindingsRequest other = (GetFindingsRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getSortCriteria() == null ^ this.getSortCriteria() == null) {
            return false;
        }
        if (other.getSortCriteria() != null && !other.getSortCriteria().equals(this.getSortCriteria())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getSortCriteria() == null ? 0 : this.getSortCriteria().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public GetFindingsRequest clone() {
        return (GetFindingsRequest)super.clone();
    }
}

