/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.securityhub.AWSSecurityHubAsync;
import com.amazonaws.services.securityhub.AWSSecurityHubAsyncClientBuilder;
import com.amazonaws.services.securityhub.AWSSecurityHubClient;
import com.amazonaws.services.securityhub.model.AcceptInvitationRequest;
import com.amazonaws.services.securityhub.model.AcceptInvitationResult;
import com.amazonaws.services.securityhub.model.BatchDisableStandardsRequest;
import com.amazonaws.services.securityhub.model.BatchDisableStandardsResult;
import com.amazonaws.services.securityhub.model.BatchEnableStandardsRequest;
import com.amazonaws.services.securityhub.model.BatchEnableStandardsResult;
import com.amazonaws.services.securityhub.model.BatchImportFindingsRequest;
import com.amazonaws.services.securityhub.model.BatchImportFindingsResult;
import com.amazonaws.services.securityhub.model.BatchUpdateFindingsRequest;
import com.amazonaws.services.securityhub.model.BatchUpdateFindingsResult;
import com.amazonaws.services.securityhub.model.CreateActionTargetRequest;
import com.amazonaws.services.securityhub.model.CreateActionTargetResult;
import com.amazonaws.services.securityhub.model.CreateInsightRequest;
import com.amazonaws.services.securityhub.model.CreateInsightResult;
import com.amazonaws.services.securityhub.model.CreateMembersRequest;
import com.amazonaws.services.securityhub.model.CreateMembersResult;
import com.amazonaws.services.securityhub.model.DeclineInvitationsRequest;
import com.amazonaws.services.securityhub.model.DeclineInvitationsResult;
import com.amazonaws.services.securityhub.model.DeleteActionTargetRequest;
import com.amazonaws.services.securityhub.model.DeleteActionTargetResult;
import com.amazonaws.services.securityhub.model.DeleteInsightRequest;
import com.amazonaws.services.securityhub.model.DeleteInsightResult;
import com.amazonaws.services.securityhub.model.DeleteInvitationsRequest;
import com.amazonaws.services.securityhub.model.DeleteInvitationsResult;
import com.amazonaws.services.securityhub.model.DeleteMembersRequest;
import com.amazonaws.services.securityhub.model.DeleteMembersResult;
import com.amazonaws.services.securityhub.model.DescribeActionTargetsRequest;
import com.amazonaws.services.securityhub.model.DescribeActionTargetsResult;
import com.amazonaws.services.securityhub.model.DescribeHubRequest;
import com.amazonaws.services.securityhub.model.DescribeHubResult;
import com.amazonaws.services.securityhub.model.DescribeProductsRequest;
import com.amazonaws.services.securityhub.model.DescribeProductsResult;
import com.amazonaws.services.securityhub.model.DescribeStandardsControlsRequest;
import com.amazonaws.services.securityhub.model.DescribeStandardsControlsResult;
import com.amazonaws.services.securityhub.model.DescribeStandardsRequest;
import com.amazonaws.services.securityhub.model.DescribeStandardsResult;
import com.amazonaws.services.securityhub.model.DisableImportFindingsForProductRequest;
import com.amazonaws.services.securityhub.model.DisableImportFindingsForProductResult;
import com.amazonaws.services.securityhub.model.DisableSecurityHubRequest;
import com.amazonaws.services.securityhub.model.DisableSecurityHubResult;
import com.amazonaws.services.securityhub.model.DisassociateFromMasterAccountRequest;
import com.amazonaws.services.securityhub.model.DisassociateFromMasterAccountResult;
import com.amazonaws.services.securityhub.model.DisassociateMembersRequest;
import com.amazonaws.services.securityhub.model.DisassociateMembersResult;
import com.amazonaws.services.securityhub.model.EnableImportFindingsForProductRequest;
import com.amazonaws.services.securityhub.model.EnableImportFindingsForProductResult;
import com.amazonaws.services.securityhub.model.EnableSecurityHubRequest;
import com.amazonaws.services.securityhub.model.EnableSecurityHubResult;
import com.amazonaws.services.securityhub.model.GetEnabledStandardsRequest;
import com.amazonaws.services.securityhub.model.GetEnabledStandardsResult;
import com.amazonaws.services.securityhub.model.GetFindingsRequest;
import com.amazonaws.services.securityhub.model.GetFindingsResult;
import com.amazonaws.services.securityhub.model.GetInsightResultsRequest;
import com.amazonaws.services.securityhub.model.GetInsightResultsResult;
import com.amazonaws.services.securityhub.model.GetInsightsRequest;
import com.amazonaws.services.securityhub.model.GetInsightsResult;
import com.amazonaws.services.securityhub.model.GetInvitationsCountRequest;
import com.amazonaws.services.securityhub.model.GetInvitationsCountResult;
import com.amazonaws.services.securityhub.model.GetMasterAccountRequest;
import com.amazonaws.services.securityhub.model.GetMasterAccountResult;
import com.amazonaws.services.securityhub.model.GetMembersRequest;
import com.amazonaws.services.securityhub.model.GetMembersResult;
import com.amazonaws.services.securityhub.model.InviteMembersRequest;
import com.amazonaws.services.securityhub.model.InviteMembersResult;
import com.amazonaws.services.securityhub.model.ListEnabledProductsForImportRequest;
import com.amazonaws.services.securityhub.model.ListEnabledProductsForImportResult;
import com.amazonaws.services.securityhub.model.ListInvitationsRequest;
import com.amazonaws.services.securityhub.model.ListInvitationsResult;
import com.amazonaws.services.securityhub.model.ListMembersRequest;
import com.amazonaws.services.securityhub.model.ListMembersResult;
import com.amazonaws.services.securityhub.model.ListTagsForResourceRequest;
import com.amazonaws.services.securityhub.model.ListTagsForResourceResult;
import com.amazonaws.services.securityhub.model.TagResourceRequest;
import com.amazonaws.services.securityhub.model.TagResourceResult;
import com.amazonaws.services.securityhub.model.UntagResourceRequest;
import com.amazonaws.services.securityhub.model.UntagResourceResult;
import com.amazonaws.services.securityhub.model.UpdateActionTargetRequest;
import com.amazonaws.services.securityhub.model.UpdateActionTargetResult;
import com.amazonaws.services.securityhub.model.UpdateFindingsRequest;
import com.amazonaws.services.securityhub.model.UpdateFindingsResult;
import com.amazonaws.services.securityhub.model.UpdateInsightRequest;
import com.amazonaws.services.securityhub.model.UpdateInsightResult;
import com.amazonaws.services.securityhub.model.UpdateStandardsControlRequest;
import com.amazonaws.services.securityhub.model.UpdateStandardsControlResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSecurityHubAsyncClient
extends AWSSecurityHubClient
implements AWSSecurityHubAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSecurityHubAsyncClientBuilder asyncBuilder() {
        return AWSSecurityHubAsyncClientBuilder.standard();
    }

    AWSSecurityHubAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptInvitationResult> acceptInvitationAsync(AcceptInvitationRequest request) {
        return this.acceptInvitationAsync(request, null);
    }

    @Override
    public Future<AcceptInvitationResult> acceptInvitationAsync(AcceptInvitationRequest request, final AsyncHandler<AcceptInvitationRequest, AcceptInvitationResult> asyncHandler) {
        final AcceptInvitationRequest finalRequest = (AcceptInvitationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcceptInvitationResult>(){

            @Override
            public AcceptInvitationResult call() throws Exception {
                AcceptInvitationResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeAcceptInvitation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDisableStandardsResult> batchDisableStandardsAsync(BatchDisableStandardsRequest request) {
        return this.batchDisableStandardsAsync(request, null);
    }

    @Override
    public Future<BatchDisableStandardsResult> batchDisableStandardsAsync(BatchDisableStandardsRequest request, final AsyncHandler<BatchDisableStandardsRequest, BatchDisableStandardsResult> asyncHandler) {
        final BatchDisableStandardsRequest finalRequest = (BatchDisableStandardsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDisableStandardsResult>(){

            @Override
            public BatchDisableStandardsResult call() throws Exception {
                BatchDisableStandardsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeBatchDisableStandards(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchEnableStandardsResult> batchEnableStandardsAsync(BatchEnableStandardsRequest request) {
        return this.batchEnableStandardsAsync(request, null);
    }

    @Override
    public Future<BatchEnableStandardsResult> batchEnableStandardsAsync(BatchEnableStandardsRequest request, final AsyncHandler<BatchEnableStandardsRequest, BatchEnableStandardsResult> asyncHandler) {
        final BatchEnableStandardsRequest finalRequest = (BatchEnableStandardsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchEnableStandardsResult>(){

            @Override
            public BatchEnableStandardsResult call() throws Exception {
                BatchEnableStandardsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeBatchEnableStandards(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchImportFindingsResult> batchImportFindingsAsync(BatchImportFindingsRequest request) {
        return this.batchImportFindingsAsync(request, null);
    }

    @Override
    public Future<BatchImportFindingsResult> batchImportFindingsAsync(BatchImportFindingsRequest request, final AsyncHandler<BatchImportFindingsRequest, BatchImportFindingsResult> asyncHandler) {
        final BatchImportFindingsRequest finalRequest = (BatchImportFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchImportFindingsResult>(){

            @Override
            public BatchImportFindingsResult call() throws Exception {
                BatchImportFindingsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeBatchImportFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchUpdateFindingsResult> batchUpdateFindingsAsync(BatchUpdateFindingsRequest request) {
        return this.batchUpdateFindingsAsync(request, null);
    }

    @Override
    public Future<BatchUpdateFindingsResult> batchUpdateFindingsAsync(BatchUpdateFindingsRequest request, final AsyncHandler<BatchUpdateFindingsRequest, BatchUpdateFindingsResult> asyncHandler) {
        final BatchUpdateFindingsRequest finalRequest = (BatchUpdateFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchUpdateFindingsResult>(){

            @Override
            public BatchUpdateFindingsResult call() throws Exception {
                BatchUpdateFindingsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeBatchUpdateFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateActionTargetResult> createActionTargetAsync(CreateActionTargetRequest request) {
        return this.createActionTargetAsync(request, null);
    }

    @Override
    public Future<CreateActionTargetResult> createActionTargetAsync(CreateActionTargetRequest request, final AsyncHandler<CreateActionTargetRequest, CreateActionTargetResult> asyncHandler) {
        final CreateActionTargetRequest finalRequest = (CreateActionTargetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateActionTargetResult>(){

            @Override
            public CreateActionTargetResult call() throws Exception {
                CreateActionTargetResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeCreateActionTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInsightResult> createInsightAsync(CreateInsightRequest request) {
        return this.createInsightAsync(request, null);
    }

    @Override
    public Future<CreateInsightResult> createInsightAsync(CreateInsightRequest request, final AsyncHandler<CreateInsightRequest, CreateInsightResult> asyncHandler) {
        final CreateInsightRequest finalRequest = (CreateInsightRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateInsightResult>(){

            @Override
            public CreateInsightResult call() throws Exception {
                CreateInsightResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeCreateInsight(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMembersResult> createMembersAsync(CreateMembersRequest request) {
        return this.createMembersAsync(request, null);
    }

    @Override
    public Future<CreateMembersResult> createMembersAsync(CreateMembersRequest request, final AsyncHandler<CreateMembersRequest, CreateMembersResult> asyncHandler) {
        final CreateMembersRequest finalRequest = (CreateMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMembersResult>(){

            @Override
            public CreateMembersResult call() throws Exception {
                CreateMembersResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeCreateMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeclineInvitationsResult> declineInvitationsAsync(DeclineInvitationsRequest request) {
        return this.declineInvitationsAsync(request, null);
    }

    @Override
    public Future<DeclineInvitationsResult> declineInvitationsAsync(DeclineInvitationsRequest request, final AsyncHandler<DeclineInvitationsRequest, DeclineInvitationsResult> asyncHandler) {
        final DeclineInvitationsRequest finalRequest = (DeclineInvitationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeclineInvitationsResult>(){

            @Override
            public DeclineInvitationsResult call() throws Exception {
                DeclineInvitationsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDeclineInvitations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteActionTargetResult> deleteActionTargetAsync(DeleteActionTargetRequest request) {
        return this.deleteActionTargetAsync(request, null);
    }

    @Override
    public Future<DeleteActionTargetResult> deleteActionTargetAsync(DeleteActionTargetRequest request, final AsyncHandler<DeleteActionTargetRequest, DeleteActionTargetResult> asyncHandler) {
        final DeleteActionTargetRequest finalRequest = (DeleteActionTargetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteActionTargetResult>(){

            @Override
            public DeleteActionTargetResult call() throws Exception {
                DeleteActionTargetResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDeleteActionTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInsightResult> deleteInsightAsync(DeleteInsightRequest request) {
        return this.deleteInsightAsync(request, null);
    }

    @Override
    public Future<DeleteInsightResult> deleteInsightAsync(DeleteInsightRequest request, final AsyncHandler<DeleteInsightRequest, DeleteInsightResult> asyncHandler) {
        final DeleteInsightRequest finalRequest = (DeleteInsightRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInsightResult>(){

            @Override
            public DeleteInsightResult call() throws Exception {
                DeleteInsightResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDeleteInsight(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInvitationsResult> deleteInvitationsAsync(DeleteInvitationsRequest request) {
        return this.deleteInvitationsAsync(request, null);
    }

    @Override
    public Future<DeleteInvitationsResult> deleteInvitationsAsync(DeleteInvitationsRequest request, final AsyncHandler<DeleteInvitationsRequest, DeleteInvitationsResult> asyncHandler) {
        final DeleteInvitationsRequest finalRequest = (DeleteInvitationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInvitationsResult>(){

            @Override
            public DeleteInvitationsResult call() throws Exception {
                DeleteInvitationsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDeleteInvitations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMembersResult> deleteMembersAsync(DeleteMembersRequest request) {
        return this.deleteMembersAsync(request, null);
    }

    @Override
    public Future<DeleteMembersResult> deleteMembersAsync(DeleteMembersRequest request, final AsyncHandler<DeleteMembersRequest, DeleteMembersResult> asyncHandler) {
        final DeleteMembersRequest finalRequest = (DeleteMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMembersResult>(){

            @Override
            public DeleteMembersResult call() throws Exception {
                DeleteMembersResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDeleteMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeActionTargetsResult> describeActionTargetsAsync(DescribeActionTargetsRequest request) {
        return this.describeActionTargetsAsync(request, null);
    }

    @Override
    public Future<DescribeActionTargetsResult> describeActionTargetsAsync(DescribeActionTargetsRequest request, final AsyncHandler<DescribeActionTargetsRequest, DescribeActionTargetsResult> asyncHandler) {
        final DescribeActionTargetsRequest finalRequest = (DescribeActionTargetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeActionTargetsResult>(){

            @Override
            public DescribeActionTargetsResult call() throws Exception {
                DescribeActionTargetsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDescribeActionTargets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHubResult> describeHubAsync(DescribeHubRequest request) {
        return this.describeHubAsync(request, null);
    }

    @Override
    public Future<DescribeHubResult> describeHubAsync(DescribeHubRequest request, final AsyncHandler<DescribeHubRequest, DescribeHubResult> asyncHandler) {
        final DescribeHubRequest finalRequest = (DescribeHubRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeHubResult>(){

            @Override
            public DescribeHubResult call() throws Exception {
                DescribeHubResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDescribeHub(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProductsResult> describeProductsAsync(DescribeProductsRequest request) {
        return this.describeProductsAsync(request, null);
    }

    @Override
    public Future<DescribeProductsResult> describeProductsAsync(DescribeProductsRequest request, final AsyncHandler<DescribeProductsRequest, DescribeProductsResult> asyncHandler) {
        final DescribeProductsRequest finalRequest = (DescribeProductsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeProductsResult>(){

            @Override
            public DescribeProductsResult call() throws Exception {
                DescribeProductsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDescribeProducts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStandardsResult> describeStandardsAsync(DescribeStandardsRequest request) {
        return this.describeStandardsAsync(request, null);
    }

    @Override
    public Future<DescribeStandardsResult> describeStandardsAsync(DescribeStandardsRequest request, final AsyncHandler<DescribeStandardsRequest, DescribeStandardsResult> asyncHandler) {
        final DescribeStandardsRequest finalRequest = (DescribeStandardsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeStandardsResult>(){

            @Override
            public DescribeStandardsResult call() throws Exception {
                DescribeStandardsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDescribeStandards(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStandardsControlsResult> describeStandardsControlsAsync(DescribeStandardsControlsRequest request) {
        return this.describeStandardsControlsAsync(request, null);
    }

    @Override
    public Future<DescribeStandardsControlsResult> describeStandardsControlsAsync(DescribeStandardsControlsRequest request, final AsyncHandler<DescribeStandardsControlsRequest, DescribeStandardsControlsResult> asyncHandler) {
        final DescribeStandardsControlsRequest finalRequest = (DescribeStandardsControlsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeStandardsControlsResult>(){

            @Override
            public DescribeStandardsControlsResult call() throws Exception {
                DescribeStandardsControlsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDescribeStandardsControls(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableImportFindingsForProductResult> disableImportFindingsForProductAsync(DisableImportFindingsForProductRequest request) {
        return this.disableImportFindingsForProductAsync(request, null);
    }

    @Override
    public Future<DisableImportFindingsForProductResult> disableImportFindingsForProductAsync(DisableImportFindingsForProductRequest request, final AsyncHandler<DisableImportFindingsForProductRequest, DisableImportFindingsForProductResult> asyncHandler) {
        final DisableImportFindingsForProductRequest finalRequest = (DisableImportFindingsForProductRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableImportFindingsForProductResult>(){

            @Override
            public DisableImportFindingsForProductResult call() throws Exception {
                DisableImportFindingsForProductResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDisableImportFindingsForProduct(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableSecurityHubResult> disableSecurityHubAsync(DisableSecurityHubRequest request) {
        return this.disableSecurityHubAsync(request, null);
    }

    @Override
    public Future<DisableSecurityHubResult> disableSecurityHubAsync(DisableSecurityHubRequest request, final AsyncHandler<DisableSecurityHubRequest, DisableSecurityHubResult> asyncHandler) {
        final DisableSecurityHubRequest finalRequest = (DisableSecurityHubRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableSecurityHubResult>(){

            @Override
            public DisableSecurityHubResult call() throws Exception {
                DisableSecurityHubResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDisableSecurityHub(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateFromMasterAccountResult> disassociateFromMasterAccountAsync(DisassociateFromMasterAccountRequest request) {
        return this.disassociateFromMasterAccountAsync(request, null);
    }

    @Override
    public Future<DisassociateFromMasterAccountResult> disassociateFromMasterAccountAsync(DisassociateFromMasterAccountRequest request, final AsyncHandler<DisassociateFromMasterAccountRequest, DisassociateFromMasterAccountResult> asyncHandler) {
        final DisassociateFromMasterAccountRequest finalRequest = (DisassociateFromMasterAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateFromMasterAccountResult>(){

            @Override
            public DisassociateFromMasterAccountResult call() throws Exception {
                DisassociateFromMasterAccountResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDisassociateFromMasterAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateMembersResult> disassociateMembersAsync(DisassociateMembersRequest request) {
        return this.disassociateMembersAsync(request, null);
    }

    @Override
    public Future<DisassociateMembersResult> disassociateMembersAsync(DisassociateMembersRequest request, final AsyncHandler<DisassociateMembersRequest, DisassociateMembersResult> asyncHandler) {
        final DisassociateMembersRequest finalRequest = (DisassociateMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateMembersResult>(){

            @Override
            public DisassociateMembersResult call() throws Exception {
                DisassociateMembersResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeDisassociateMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableImportFindingsForProductResult> enableImportFindingsForProductAsync(EnableImportFindingsForProductRequest request) {
        return this.enableImportFindingsForProductAsync(request, null);
    }

    @Override
    public Future<EnableImportFindingsForProductResult> enableImportFindingsForProductAsync(EnableImportFindingsForProductRequest request, final AsyncHandler<EnableImportFindingsForProductRequest, EnableImportFindingsForProductResult> asyncHandler) {
        final EnableImportFindingsForProductRequest finalRequest = (EnableImportFindingsForProductRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableImportFindingsForProductResult>(){

            @Override
            public EnableImportFindingsForProductResult call() throws Exception {
                EnableImportFindingsForProductResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeEnableImportFindingsForProduct(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableSecurityHubResult> enableSecurityHubAsync(EnableSecurityHubRequest request) {
        return this.enableSecurityHubAsync(request, null);
    }

    @Override
    public Future<EnableSecurityHubResult> enableSecurityHubAsync(EnableSecurityHubRequest request, final AsyncHandler<EnableSecurityHubRequest, EnableSecurityHubResult> asyncHandler) {
        final EnableSecurityHubRequest finalRequest = (EnableSecurityHubRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableSecurityHubResult>(){

            @Override
            public EnableSecurityHubResult call() throws Exception {
                EnableSecurityHubResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeEnableSecurityHub(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEnabledStandardsResult> getEnabledStandardsAsync(GetEnabledStandardsRequest request) {
        return this.getEnabledStandardsAsync(request, null);
    }

    @Override
    public Future<GetEnabledStandardsResult> getEnabledStandardsAsync(GetEnabledStandardsRequest request, final AsyncHandler<GetEnabledStandardsRequest, GetEnabledStandardsResult> asyncHandler) {
        final GetEnabledStandardsRequest finalRequest = (GetEnabledStandardsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEnabledStandardsResult>(){

            @Override
            public GetEnabledStandardsResult call() throws Exception {
                GetEnabledStandardsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeGetEnabledStandards(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFindingsResult> getFindingsAsync(GetFindingsRequest request) {
        return this.getFindingsAsync(request, null);
    }

    @Override
    public Future<GetFindingsResult> getFindingsAsync(GetFindingsRequest request, final AsyncHandler<GetFindingsRequest, GetFindingsResult> asyncHandler) {
        final GetFindingsRequest finalRequest = (GetFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFindingsResult>(){

            @Override
            public GetFindingsResult call() throws Exception {
                GetFindingsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeGetFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInsightResultsResult> getInsightResultsAsync(GetInsightResultsRequest request) {
        return this.getInsightResultsAsync(request, null);
    }

    @Override
    public Future<GetInsightResultsResult> getInsightResultsAsync(GetInsightResultsRequest request, final AsyncHandler<GetInsightResultsRequest, GetInsightResultsResult> asyncHandler) {
        final GetInsightResultsRequest finalRequest = (GetInsightResultsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInsightResultsResult>(){

            @Override
            public GetInsightResultsResult call() throws Exception {
                GetInsightResultsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeGetInsightResults(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInsightsResult> getInsightsAsync(GetInsightsRequest request) {
        return this.getInsightsAsync(request, null);
    }

    @Override
    public Future<GetInsightsResult> getInsightsAsync(GetInsightsRequest request, final AsyncHandler<GetInsightsRequest, GetInsightsResult> asyncHandler) {
        final GetInsightsRequest finalRequest = (GetInsightsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInsightsResult>(){

            @Override
            public GetInsightsResult call() throws Exception {
                GetInsightsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeGetInsights(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInvitationsCountResult> getInvitationsCountAsync(GetInvitationsCountRequest request) {
        return this.getInvitationsCountAsync(request, null);
    }

    @Override
    public Future<GetInvitationsCountResult> getInvitationsCountAsync(GetInvitationsCountRequest request, final AsyncHandler<GetInvitationsCountRequest, GetInvitationsCountResult> asyncHandler) {
        final GetInvitationsCountRequest finalRequest = (GetInvitationsCountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInvitationsCountResult>(){

            @Override
            public GetInvitationsCountResult call() throws Exception {
                GetInvitationsCountResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeGetInvitationsCount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMasterAccountResult> getMasterAccountAsync(GetMasterAccountRequest request) {
        return this.getMasterAccountAsync(request, null);
    }

    @Override
    public Future<GetMasterAccountResult> getMasterAccountAsync(GetMasterAccountRequest request, final AsyncHandler<GetMasterAccountRequest, GetMasterAccountResult> asyncHandler) {
        final GetMasterAccountRequest finalRequest = (GetMasterAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMasterAccountResult>(){

            @Override
            public GetMasterAccountResult call() throws Exception {
                GetMasterAccountResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeGetMasterAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMembersResult> getMembersAsync(GetMembersRequest request) {
        return this.getMembersAsync(request, null);
    }

    @Override
    public Future<GetMembersResult> getMembersAsync(GetMembersRequest request, final AsyncHandler<GetMembersRequest, GetMembersResult> asyncHandler) {
        final GetMembersRequest finalRequest = (GetMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMembersResult>(){

            @Override
            public GetMembersResult call() throws Exception {
                GetMembersResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeGetMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InviteMembersResult> inviteMembersAsync(InviteMembersRequest request) {
        return this.inviteMembersAsync(request, null);
    }

    @Override
    public Future<InviteMembersResult> inviteMembersAsync(InviteMembersRequest request, final AsyncHandler<InviteMembersRequest, InviteMembersResult> asyncHandler) {
        final InviteMembersRequest finalRequest = (InviteMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InviteMembersResult>(){

            @Override
            public InviteMembersResult call() throws Exception {
                InviteMembersResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeInviteMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEnabledProductsForImportResult> listEnabledProductsForImportAsync(ListEnabledProductsForImportRequest request) {
        return this.listEnabledProductsForImportAsync(request, null);
    }

    @Override
    public Future<ListEnabledProductsForImportResult> listEnabledProductsForImportAsync(ListEnabledProductsForImportRequest request, final AsyncHandler<ListEnabledProductsForImportRequest, ListEnabledProductsForImportResult> asyncHandler) {
        final ListEnabledProductsForImportRequest finalRequest = (ListEnabledProductsForImportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEnabledProductsForImportResult>(){

            @Override
            public ListEnabledProductsForImportResult call() throws Exception {
                ListEnabledProductsForImportResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeListEnabledProductsForImport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInvitationsResult> listInvitationsAsync(ListInvitationsRequest request) {
        return this.listInvitationsAsync(request, null);
    }

    @Override
    public Future<ListInvitationsResult> listInvitationsAsync(ListInvitationsRequest request, final AsyncHandler<ListInvitationsRequest, ListInvitationsResult> asyncHandler) {
        final ListInvitationsRequest finalRequest = (ListInvitationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInvitationsResult>(){

            @Override
            public ListInvitationsResult call() throws Exception {
                ListInvitationsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeListInvitations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMembersResult> listMembersAsync(ListMembersRequest request) {
        return this.listMembersAsync(request, null);
    }

    @Override
    public Future<ListMembersResult> listMembersAsync(ListMembersRequest request, final AsyncHandler<ListMembersRequest, ListMembersResult> asyncHandler) {
        final ListMembersRequest finalRequest = (ListMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMembersResult>(){

            @Override
            public ListMembersResult call() throws Exception {
                ListMembersResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeListMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateActionTargetResult> updateActionTargetAsync(UpdateActionTargetRequest request) {
        return this.updateActionTargetAsync(request, null);
    }

    @Override
    public Future<UpdateActionTargetResult> updateActionTargetAsync(UpdateActionTargetRequest request, final AsyncHandler<UpdateActionTargetRequest, UpdateActionTargetResult> asyncHandler) {
        final UpdateActionTargetRequest finalRequest = (UpdateActionTargetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateActionTargetResult>(){

            @Override
            public UpdateActionTargetResult call() throws Exception {
                UpdateActionTargetResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeUpdateActionTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFindingsResult> updateFindingsAsync(UpdateFindingsRequest request) {
        return this.updateFindingsAsync(request, null);
    }

    @Override
    public Future<UpdateFindingsResult> updateFindingsAsync(UpdateFindingsRequest request, final AsyncHandler<UpdateFindingsRequest, UpdateFindingsResult> asyncHandler) {
        final UpdateFindingsRequest finalRequest = (UpdateFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFindingsResult>(){

            @Override
            public UpdateFindingsResult call() throws Exception {
                UpdateFindingsResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeUpdateFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateInsightResult> updateInsightAsync(UpdateInsightRequest request) {
        return this.updateInsightAsync(request, null);
    }

    @Override
    public Future<UpdateInsightResult> updateInsightAsync(UpdateInsightRequest request, final AsyncHandler<UpdateInsightRequest, UpdateInsightResult> asyncHandler) {
        final UpdateInsightRequest finalRequest = (UpdateInsightRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateInsightResult>(){

            @Override
            public UpdateInsightResult call() throws Exception {
                UpdateInsightResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeUpdateInsight(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateStandardsControlResult> updateStandardsControlAsync(UpdateStandardsControlRequest request) {
        return this.updateStandardsControlAsync(request, null);
    }

    @Override
    public Future<UpdateStandardsControlResult> updateStandardsControlAsync(UpdateStandardsControlRequest request, final AsyncHandler<UpdateStandardsControlRequest, UpdateStandardsControlResult> asyncHandler) {
        final UpdateStandardsControlRequest finalRequest = (UpdateStandardsControlRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateStandardsControlResult>(){

            @Override
            public UpdateStandardsControlResult call() throws Exception {
                UpdateStandardsControlResult result = null;
                try {
                    result = AWSSecurityHubAsyncClient.this.executeUpdateStandardsControl(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

