/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.securityhub.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Vulnerability JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class VulnerabilityJsonUnmarshaller implements Unmarshaller<Vulnerability, JsonUnmarshallerContext> {

    public Vulnerability unmarshall(JsonUnmarshallerContext context) throws Exception {
        Vulnerability vulnerability = new Vulnerability();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    vulnerability.setId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("VulnerablePackages", targetDepth)) {
                    context.nextToken();
                    vulnerability.setVulnerablePackages(new ListUnmarshaller<SoftwarePackage>(SoftwarePackageJsonUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("Cvss", targetDepth)) {
                    context.nextToken();
                    vulnerability.setCvss(new ListUnmarshaller<Cvss>(CvssJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("RelatedVulnerabilities", targetDepth)) {
                    context.nextToken();
                    vulnerability.setRelatedVulnerabilities(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Vendor", targetDepth)) {
                    context.nextToken();
                    vulnerability.setVendor(VulnerabilityVendorJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ReferenceUrls", targetDepth)) {
                    context.nextToken();
                    vulnerability.setReferenceUrls(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return vulnerability;
    }

    private static VulnerabilityJsonUnmarshaller instance;

    public static VulnerabilityJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new VulnerabilityJsonUnmarshaller();
        return instance;
    }
}
