/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.Partition;
import com.amazonaws.services.securityhub.model.ResourceDetails;
import com.amazonaws.services.securityhub.model.transform.ResourceMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Resource
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String id;
    private String partition;
    private String region;
    private String resourceRole;
    private Map<String, String> tags;
    private ResourceDetails details;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Resource withType(String type) {
        this.setType(type);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Resource withId(String id) {
        this.setId(id);
        return this;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    public String getPartition() {
        return this.partition;
    }

    public Resource withPartition(String partition) {
        this.setPartition(partition);
        return this;
    }

    public Resource withPartition(Partition partition) {
        this.partition = partition.toString();
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public Resource withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public void setResourceRole(String resourceRole) {
        this.resourceRole = resourceRole;
    }

    public String getResourceRole() {
        return this.resourceRole;
    }

    public Resource withResourceRole(String resourceRole) {
        this.setResourceRole(resourceRole);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Resource withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Resource addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Resource clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setDetails(ResourceDetails details) {
        this.details = details;
    }

    public ResourceDetails getDetails() {
        return this.details;
    }

    public Resource withDetails(ResourceDetails details) {
        this.setDetails(details);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getPartition() != null) {
            sb.append("Partition: ").append(this.getPartition()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getResourceRole() != null) {
            sb.append("ResourceRole: ").append(this.getResourceRole()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getDetails() != null) {
            sb.append("Details: ").append(this.getDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getPartition() == null ^ this.getPartition() == null) {
            return false;
        }
        if (other.getPartition() != null && !other.getPartition().equals(this.getPartition())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getResourceRole() == null ^ this.getResourceRole() == null) {
            return false;
        }
        if (other.getResourceRole() != null && !other.getResourceRole().equals(this.getResourceRole())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getDetails() == null ^ this.getDetails() == null) {
            return false;
        }
        return other.getDetails() == null || other.getDetails().equals(this.getDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getPartition() == null ? 0 : this.getPartition().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getResourceRole() == null ? 0 : this.getResourceRole().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getDetails() == null ? 0 : this.getDetails().hashCode());
        return hashCode;
    }

    public Resource clone() {
        try {
            return (Resource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

