/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.securityhub.model.Standard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeStandardsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Standard> standards;
    private String nextToken;

    public List<Standard> getStandards() {
        return this.standards;
    }

    public void setStandards(Collection<Standard> standards) {
        if (standards == null) {
            this.standards = null;
            return;
        }
        this.standards = new ArrayList<Standard>(standards);
    }

    public DescribeStandardsResult withStandards(Standard ... standards) {
        if (this.standards == null) {
            this.setStandards(new ArrayList<Standard>(standards.length));
        }
        for (Standard ele : standards) {
            this.standards.add(ele);
        }
        return this;
    }

    public DescribeStandardsResult withStandards(Collection<Standard> standards) {
        this.setStandards(standards);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeStandardsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStandards() != null) {
            sb.append("Standards: ").append(this.getStandards()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStandardsResult)) {
            return false;
        }
        DescribeStandardsResult other = (DescribeStandardsResult)obj;
        if (other.getStandards() == null ^ this.getStandards() == null) {
            return false;
        }
        if (other.getStandards() != null && !other.getStandards().equals(this.getStandards())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStandards() == null ? 0 : this.getStandards().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeStandardsResult clone() {
        try {
            return (DescribeStandardsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

