/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A list of malware related to a finding.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Malware" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Malware implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the malware that was observed.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     */
    private String type;
    /**
     * <p>
     * The file system path of the malware that was observed.
     * </p>
     */
    private String path;
    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     */
    private String state;

    /**
     * <p>
     * The name of the malware that was observed.
     * </p>
     * 
     * @param name
     *        The name of the malware that was observed.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the malware that was observed.
     * </p>
     * 
     * @return The name of the malware that was observed.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the malware that was observed.
     * </p>
     * 
     * @param name
     *        The name of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Malware withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     * 
     * @param type
     *        The type of the malware that was observed.
     * @see MalwareType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     * 
     * @return The type of the malware that was observed.
     * @see MalwareType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     * 
     * @param type
     *        The type of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MalwareType
     */

    public Malware withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     * 
     * @param type
     *        The type of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MalwareType
     */

    public Malware withType(MalwareType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * <p>
     * The file system path of the malware that was observed.
     * </p>
     * 
     * @param path
     *        The file system path of the malware that was observed.
     */

    public void setPath(String path) {
        this.path = path;
    }

    /**
     * <p>
     * The file system path of the malware that was observed.
     * </p>
     * 
     * @return The file system path of the malware that was observed.
     */

    public String getPath() {
        return this.path;
    }

    /**
     * <p>
     * The file system path of the malware that was observed.
     * </p>
     * 
     * @param path
     *        The file system path of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Malware withPath(String path) {
        setPath(path);
        return this;
    }

    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     * 
     * @param state
     *        The state of the malware that was observed.
     * @see MalwareState
     */

    public void setState(String state) {
        this.state = state;
    }

    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     * 
     * @return The state of the malware that was observed.
     * @see MalwareState
     */

    public String getState() {
        return this.state;
    }

    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     * 
     * @param state
     *        The state of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MalwareState
     */

    public Malware withState(String state) {
        setState(state);
        return this;
    }

    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     * 
     * @param state
     *        The state of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MalwareState
     */

    public Malware withState(MalwareState state) {
        this.state = state.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getPath() != null)
            sb.append("Path: ").append(getPath()).append(",");
        if (getState() != null)
            sb.append("State: ").append(getState());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Malware == false)
            return false;
        Malware other = (Malware) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getPath() == null ^ this.getPath() == null)
            return false;
        if (other.getPath() != null && other.getPath().equals(this.getPath()) == false)
            return false;
        if (other.getState() == null ^ this.getState() == null)
            return false;
        if (other.getState() != null && other.getState().equals(this.getState()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getPath() == null) ? 0 : getPath().hashCode());
        hashCode = prime * hashCode + ((getState() == null) ? 0 : getState().hashCode());
        return hashCode;
    }

    @Override
    public Malware clone() {
        try {
            return (Malware) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.MalwareMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
