/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.securityhub.model.Cell;

@SdkInternalApi
public class CellMarshaller {
    private static final MarshallingInfo<Long> COLUMN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Column").build();
    private static final MarshallingInfo<Long> ROW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Row").build();
    private static final MarshallingInfo<String> COLUMNNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ColumnName").build();
    private static final MarshallingInfo<String> CELLREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CellReference").build();
    private static final CellMarshaller instance = new CellMarshaller();

    public static CellMarshaller getInstance() {
        return instance;
    }

    public void marshall(Cell cell, ProtocolMarshaller protocolMarshaller) {
        if (cell == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cell.getColumn(), COLUMN_BINDING);
            protocolMarshaller.marshall((Object)cell.getRow(), ROW_BINDING);
            protocolMarshaller.marshall((Object)cell.getColumnName(), COLUMNNAME_BINDING);
            protocolMarshaller.marshall((Object)cell.getCellReference(), CELLREFERENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

