/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.securityhub.model.SoftwarePackage;

@SdkInternalApi
public class SoftwarePackageMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<String> EPOCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Epoch").build();
    private static final MarshallingInfo<String> RELEASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Release").build();
    private static final MarshallingInfo<String> ARCHITECTURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Architecture").build();
    private static final MarshallingInfo<String> PACKAGEMANAGER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PackageManager").build();
    private static final MarshallingInfo<String> FILEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FilePath").build();
    private static final MarshallingInfo<String> FIXEDINVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FixedInVersion").build();
    private static final MarshallingInfo<String> REMEDIATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Remediation").build();
    private static final MarshallingInfo<String> SOURCELAYERHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceLayerHash").build();
    private static final MarshallingInfo<String> SOURCELAYERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceLayerArn").build();
    private static final SoftwarePackageMarshaller instance = new SoftwarePackageMarshaller();

    public static SoftwarePackageMarshaller getInstance() {
        return instance;
    }

    public void marshall(SoftwarePackage softwarePackage, ProtocolMarshaller protocolMarshaller) {
        if (softwarePackage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)softwarePackage.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)softwarePackage.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)softwarePackage.getEpoch(), EPOCH_BINDING);
            protocolMarshaller.marshall((Object)softwarePackage.getRelease(), RELEASE_BINDING);
            protocolMarshaller.marshall((Object)softwarePackage.getArchitecture(), ARCHITECTURE_BINDING);
            protocolMarshaller.marshall((Object)softwarePackage.getPackageManager(), PACKAGEMANAGER_BINDING);
            protocolMarshaller.marshall((Object)softwarePackage.getFilePath(), FILEPATH_BINDING);
            protocolMarshaller.marshall((Object)softwarePackage.getFixedInVersion(), FIXEDINVERSION_BINDING);
            protocolMarshaller.marshall((Object)softwarePackage.getRemediation(), REMEDIATION_BINDING);
            protocolMarshaller.marshall((Object)softwarePackage.getSourceLayerHash(), SOURCELAYERHASH_BINDING);
            protocolMarshaller.marshall((Object)softwarePackage.getSourceLayerArn(), SOURCELAYERARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

