/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.workdocs.AmazonWorkDocs;
import com.amazonaws.services.workdocs.AmazonWorkDocsClientBuilder;
import com.amazonaws.services.workdocs.model.AbortDocumentVersionUploadRequest;
import com.amazonaws.services.workdocs.model.AbortDocumentVersionUploadResult;
import com.amazonaws.services.workdocs.model.ActivateUserRequest;
import com.amazonaws.services.workdocs.model.ActivateUserResult;
import com.amazonaws.services.workdocs.model.AddResourcePermissionsRequest;
import com.amazonaws.services.workdocs.model.AddResourcePermissionsResult;
import com.amazonaws.services.workdocs.model.AmazonWorkDocsException;
import com.amazonaws.services.workdocs.model.ConcurrentModificationException;
import com.amazonaws.services.workdocs.model.CreateFolderRequest;
import com.amazonaws.services.workdocs.model.CreateFolderResult;
import com.amazonaws.services.workdocs.model.CreateNotificationSubscriptionRequest;
import com.amazonaws.services.workdocs.model.CreateNotificationSubscriptionResult;
import com.amazonaws.services.workdocs.model.CreateUserRequest;
import com.amazonaws.services.workdocs.model.CreateUserResult;
import com.amazonaws.services.workdocs.model.DeactivateUserRequest;
import com.amazonaws.services.workdocs.model.DeactivateUserResult;
import com.amazonaws.services.workdocs.model.DeactivatingLastSystemUserException;
import com.amazonaws.services.workdocs.model.DeleteDocumentRequest;
import com.amazonaws.services.workdocs.model.DeleteDocumentResult;
import com.amazonaws.services.workdocs.model.DeleteFolderContentsRequest;
import com.amazonaws.services.workdocs.model.DeleteFolderContentsResult;
import com.amazonaws.services.workdocs.model.DeleteFolderRequest;
import com.amazonaws.services.workdocs.model.DeleteFolderResult;
import com.amazonaws.services.workdocs.model.DeleteNotificationSubscriptionRequest;
import com.amazonaws.services.workdocs.model.DeleteNotificationSubscriptionResult;
import com.amazonaws.services.workdocs.model.DeleteUserRequest;
import com.amazonaws.services.workdocs.model.DeleteUserResult;
import com.amazonaws.services.workdocs.model.DescribeDocumentVersionsRequest;
import com.amazonaws.services.workdocs.model.DescribeDocumentVersionsResult;
import com.amazonaws.services.workdocs.model.DescribeFolderContentsRequest;
import com.amazonaws.services.workdocs.model.DescribeFolderContentsResult;
import com.amazonaws.services.workdocs.model.DescribeNotificationSubscriptionsRequest;
import com.amazonaws.services.workdocs.model.DescribeNotificationSubscriptionsResult;
import com.amazonaws.services.workdocs.model.DescribeResourcePermissionsRequest;
import com.amazonaws.services.workdocs.model.DescribeResourcePermissionsResult;
import com.amazonaws.services.workdocs.model.DescribeUsersRequest;
import com.amazonaws.services.workdocs.model.DescribeUsersResult;
import com.amazonaws.services.workdocs.model.EntityAlreadyExistsException;
import com.amazonaws.services.workdocs.model.EntityNotExistsException;
import com.amazonaws.services.workdocs.model.FailedDependencyException;
import com.amazonaws.services.workdocs.model.GetDocumentPathRequest;
import com.amazonaws.services.workdocs.model.GetDocumentPathResult;
import com.amazonaws.services.workdocs.model.GetDocumentRequest;
import com.amazonaws.services.workdocs.model.GetDocumentResult;
import com.amazonaws.services.workdocs.model.GetDocumentVersionRequest;
import com.amazonaws.services.workdocs.model.GetDocumentVersionResult;
import com.amazonaws.services.workdocs.model.GetFolderPathRequest;
import com.amazonaws.services.workdocs.model.GetFolderPathResult;
import com.amazonaws.services.workdocs.model.GetFolderRequest;
import com.amazonaws.services.workdocs.model.GetFolderResult;
import com.amazonaws.services.workdocs.model.IllegalUserStateException;
import com.amazonaws.services.workdocs.model.InitiateDocumentVersionUploadRequest;
import com.amazonaws.services.workdocs.model.InitiateDocumentVersionUploadResult;
import com.amazonaws.services.workdocs.model.InvalidArgumentException;
import com.amazonaws.services.workdocs.model.InvalidOperationException;
import com.amazonaws.services.workdocs.model.LimitExceededException;
import com.amazonaws.services.workdocs.model.ProhibitedStateException;
import com.amazonaws.services.workdocs.model.RemoveAllResourcePermissionsRequest;
import com.amazonaws.services.workdocs.model.RemoveAllResourcePermissionsResult;
import com.amazonaws.services.workdocs.model.RemoveResourcePermissionRequest;
import com.amazonaws.services.workdocs.model.RemoveResourcePermissionResult;
import com.amazonaws.services.workdocs.model.ServiceUnavailableException;
import com.amazonaws.services.workdocs.model.StorageLimitExceededException;
import com.amazonaws.services.workdocs.model.StorageLimitWillExceedException;
import com.amazonaws.services.workdocs.model.TooManySubscriptionsException;
import com.amazonaws.services.workdocs.model.UnauthorizedOperationException;
import com.amazonaws.services.workdocs.model.UnauthorizedResourceAccessException;
import com.amazonaws.services.workdocs.model.UpdateDocumentRequest;
import com.amazonaws.services.workdocs.model.UpdateDocumentResult;
import com.amazonaws.services.workdocs.model.UpdateDocumentVersionRequest;
import com.amazonaws.services.workdocs.model.UpdateDocumentVersionResult;
import com.amazonaws.services.workdocs.model.UpdateFolderRequest;
import com.amazonaws.services.workdocs.model.UpdateFolderResult;
import com.amazonaws.services.workdocs.model.UpdateUserRequest;
import com.amazonaws.services.workdocs.model.UpdateUserResult;
import com.amazonaws.services.workdocs.model.transform.AbortDocumentVersionUploadRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.AbortDocumentVersionUploadResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.ActivateUserRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.ActivateUserResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.AddResourcePermissionsRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.AddResourcePermissionsResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.CreateFolderRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.CreateFolderResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.CreateNotificationSubscriptionRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.CreateNotificationSubscriptionResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.CreateUserRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.CreateUserResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.DeactivateUserRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.DeactivateUserResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.DeleteDocumentRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.DeleteDocumentResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.DeleteFolderContentsRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.DeleteFolderContentsResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.DeleteFolderRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.DeleteFolderResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.DeleteNotificationSubscriptionRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.DeleteNotificationSubscriptionResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.DeleteUserRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.DeleteUserResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.DescribeDocumentVersionsRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.DescribeDocumentVersionsResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.DescribeFolderContentsRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.DescribeFolderContentsResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.DescribeNotificationSubscriptionsRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.DescribeNotificationSubscriptionsResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.DescribeResourcePermissionsRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.DescribeResourcePermissionsResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.DescribeUsersRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.DescribeUsersResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.GetDocumentPathRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.GetDocumentPathResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.GetDocumentRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.GetDocumentResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.GetDocumentVersionRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.GetDocumentVersionResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.GetFolderPathRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.GetFolderPathResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.GetFolderRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.GetFolderResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.InitiateDocumentVersionUploadRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.InitiateDocumentVersionUploadResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.RemoveAllResourcePermissionsRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.RemoveAllResourcePermissionsResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.RemoveResourcePermissionRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.RemoveResourcePermissionResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.UpdateDocumentRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.UpdateDocumentResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.UpdateDocumentVersionRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.UpdateDocumentVersionResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.UpdateFolderRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.UpdateFolderResultJsonUnmarshaller;
import com.amazonaws.services.workdocs.model.transform.UpdateUserRequestProtocolMarshaller;
import com.amazonaws.services.workdocs.model.transform.UpdateUserResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonWorkDocsClient
extends AmazonWebServiceClient
implements AmazonWorkDocs {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonWorkDocs.class);
    private static final String DEFAULT_SIGNING_NAME = "workdocs";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FailedDependencyException").withModeledClass(FailedDependencyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidOperationException").withModeledClass(InvalidOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedResourceAccessException").withModeledClass(UnauthorizedResourceAccessException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManySubscriptionsException").withModeledClass(TooManySubscriptionsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EntityAlreadyExistsException").withModeledClass(EntityAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EntityNotExistsException").withModeledClass(EntityNotExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StorageLimitExceededException").withModeledClass(StorageLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StorageLimitWillExceedException").withModeledClass(StorageLimitWillExceedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProhibitedStateException").withModeledClass(ProhibitedStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IllegalUserStateException").withModeledClass(IllegalUserStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArgumentException").withModeledClass(InvalidArgumentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedOperationException").withModeledClass(UnauthorizedOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DeactivatingLastSystemUserException").withModeledClass(DeactivatingLastSystemUserException.class)).withBaseServiceExceptionClass(AmazonWorkDocsException.class));

    public static AmazonWorkDocsClientBuilder builder() {
        return AmazonWorkDocsClientBuilder.standard();
    }

    AmazonWorkDocsClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("workdocs.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/workdocs/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/workdocs/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AbortDocumentVersionUploadResult abortDocumentVersionUpload(AbortDocumentVersionUploadRequest request) {
        request = (AbortDocumentVersionUploadRequest)this.beforeClientExecution(request);
        return this.executeAbortDocumentVersionUpload(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AbortDocumentVersionUploadResult executeAbortDocumentVersionUpload(AbortDocumentVersionUploadRequest abortDocumentVersionUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(abortDocumentVersionUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AbortDocumentVersionUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AbortDocumentVersionUploadRequestProtocolMarshaller(this.protocolFactory).marshall((AbortDocumentVersionUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)abortDocumentVersionUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AbortDocumentVersionUploadResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AbortDocumentVersionUploadResult abortDocumentVersionUploadResult = (AbortDocumentVersionUploadResult)response.getAwsResponse();
            return abortDocumentVersionUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ActivateUserResult activateUser(ActivateUserRequest request) {
        request = (ActivateUserRequest)this.beforeClientExecution(request);
        return this.executeActivateUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ActivateUserResult executeActivateUser(ActivateUserRequest activateUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(activateUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ActivateUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ActivateUserRequestProtocolMarshaller(this.protocolFactory).marshall((ActivateUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)activateUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ActivateUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ActivateUserResult activateUserResult = (ActivateUserResult)response.getAwsResponse();
            return activateUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AddResourcePermissionsResult addResourcePermissions(AddResourcePermissionsRequest request) {
        request = (AddResourcePermissionsRequest)this.beforeClientExecution(request);
        return this.executeAddResourcePermissions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddResourcePermissionsResult executeAddResourcePermissions(AddResourcePermissionsRequest addResourcePermissionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addResourcePermissionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddResourcePermissionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddResourcePermissionsRequestProtocolMarshaller(this.protocolFactory).marshall((AddResourcePermissionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)addResourcePermissionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddResourcePermissionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddResourcePermissionsResult addResourcePermissionsResult = (AddResourcePermissionsResult)response.getAwsResponse();
            return addResourcePermissionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateFolderResult createFolder(CreateFolderRequest request) {
        request = (CreateFolderRequest)this.beforeClientExecution(request);
        return this.executeCreateFolder(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateFolderResult executeCreateFolder(CreateFolderRequest createFolderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFolderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFolderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFolderRequestProtocolMarshaller(this.protocolFactory).marshall((CreateFolderRequest)super.beforeMarshalling((AmazonWebServiceRequest)createFolderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFolderResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFolderResult createFolderResult = (CreateFolderResult)response.getAwsResponse();
            return createFolderResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateNotificationSubscriptionResult createNotificationSubscription(CreateNotificationSubscriptionRequest request) {
        request = (CreateNotificationSubscriptionRequest)this.beforeClientExecution(request);
        return this.executeCreateNotificationSubscription(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateNotificationSubscriptionResult executeCreateNotificationSubscription(CreateNotificationSubscriptionRequest createNotificationSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createNotificationSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateNotificationSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateNotificationSubscriptionRequestProtocolMarshaller(this.protocolFactory).marshall((CreateNotificationSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createNotificationSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateNotificationSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateNotificationSubscriptionResult createNotificationSubscriptionResult = (CreateNotificationSubscriptionResult)response.getAwsResponse();
            return createNotificationSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateUserResult createUser(CreateUserRequest request) {
        request = (CreateUserRequest)this.beforeClientExecution(request);
        return this.executeCreateUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateUserResult executeCreateUser(CreateUserRequest createUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateUserRequestProtocolMarshaller(this.protocolFactory).marshall((CreateUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)createUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateUserResult createUserResult = (CreateUserResult)response.getAwsResponse();
            return createUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeactivateUserResult deactivateUser(DeactivateUserRequest request) {
        request = (DeactivateUserRequest)this.beforeClientExecution(request);
        return this.executeDeactivateUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeactivateUserResult executeDeactivateUser(DeactivateUserRequest deactivateUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deactivateUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeactivateUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeactivateUserRequestProtocolMarshaller(this.protocolFactory).marshall((DeactivateUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)deactivateUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeactivateUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeactivateUserResult deactivateUserResult = (DeactivateUserResult)response.getAwsResponse();
            return deactivateUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDocumentResult deleteDocument(DeleteDocumentRequest request) {
        request = (DeleteDocumentRequest)this.beforeClientExecution(request);
        return this.executeDeleteDocument(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDocumentResult executeDeleteDocument(DeleteDocumentRequest deleteDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDocumentRequestProtocolMarshaller(this.protocolFactory).marshall((DeleteDocumentRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDocumentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDocumentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDocumentResult deleteDocumentResult = (DeleteDocumentResult)response.getAwsResponse();
            return deleteDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteFolderResult deleteFolder(DeleteFolderRequest request) {
        request = (DeleteFolderRequest)this.beforeClientExecution(request);
        return this.executeDeleteFolder(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteFolderResult executeDeleteFolder(DeleteFolderRequest deleteFolderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFolderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFolderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFolderRequestProtocolMarshaller(this.protocolFactory).marshall((DeleteFolderRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteFolderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFolderResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFolderResult deleteFolderResult = (DeleteFolderResult)response.getAwsResponse();
            return deleteFolderResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteFolderContentsResult deleteFolderContents(DeleteFolderContentsRequest request) {
        request = (DeleteFolderContentsRequest)this.beforeClientExecution(request);
        return this.executeDeleteFolderContents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteFolderContentsResult executeDeleteFolderContents(DeleteFolderContentsRequest deleteFolderContentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFolderContentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFolderContentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFolderContentsRequestProtocolMarshaller(this.protocolFactory).marshall((DeleteFolderContentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteFolderContentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFolderContentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFolderContentsResult deleteFolderContentsResult = (DeleteFolderContentsResult)response.getAwsResponse();
            return deleteFolderContentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteNotificationSubscriptionResult deleteNotificationSubscription(DeleteNotificationSubscriptionRequest request) {
        request = (DeleteNotificationSubscriptionRequest)this.beforeClientExecution(request);
        return this.executeDeleteNotificationSubscription(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteNotificationSubscriptionResult executeDeleteNotificationSubscription(DeleteNotificationSubscriptionRequest deleteNotificationSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteNotificationSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteNotificationSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteNotificationSubscriptionRequestProtocolMarshaller(this.protocolFactory).marshall((DeleteNotificationSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteNotificationSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNotificationSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteNotificationSubscriptionResult deleteNotificationSubscriptionResult = (DeleteNotificationSubscriptionResult)response.getAwsResponse();
            return deleteNotificationSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteUserResult deleteUser(DeleteUserRequest request) {
        request = (DeleteUserRequest)this.beforeClientExecution(request);
        return this.executeDeleteUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteUserResult executeDeleteUser(DeleteUserRequest deleteUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteUserRequestProtocolMarshaller(this.protocolFactory).marshall((DeleteUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteUserResult deleteUserResult = (DeleteUserResult)response.getAwsResponse();
            return deleteUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDocumentVersionsResult describeDocumentVersions(DescribeDocumentVersionsRequest request) {
        request = (DescribeDocumentVersionsRequest)this.beforeClientExecution(request);
        return this.executeDescribeDocumentVersions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDocumentVersionsResult executeDescribeDocumentVersions(DescribeDocumentVersionsRequest describeDocumentVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDocumentVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDocumentVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDocumentVersionsRequestProtocolMarshaller(this.protocolFactory).marshall((DescribeDocumentVersionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDocumentVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDocumentVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDocumentVersionsResult describeDocumentVersionsResult = (DescribeDocumentVersionsResult)response.getAwsResponse();
            return describeDocumentVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFolderContentsResult describeFolderContents(DescribeFolderContentsRequest request) {
        request = (DescribeFolderContentsRequest)this.beforeClientExecution(request);
        return this.executeDescribeFolderContents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFolderContentsResult executeDescribeFolderContents(DescribeFolderContentsRequest describeFolderContentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFolderContentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFolderContentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFolderContentsRequestProtocolMarshaller(this.protocolFactory).marshall((DescribeFolderContentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFolderContentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFolderContentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFolderContentsResult describeFolderContentsResult = (DescribeFolderContentsResult)response.getAwsResponse();
            return describeFolderContentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeNotificationSubscriptionsResult describeNotificationSubscriptions(DescribeNotificationSubscriptionsRequest request) {
        request = (DescribeNotificationSubscriptionsRequest)this.beforeClientExecution(request);
        return this.executeDescribeNotificationSubscriptions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeNotificationSubscriptionsResult executeDescribeNotificationSubscriptions(DescribeNotificationSubscriptionsRequest describeNotificationSubscriptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeNotificationSubscriptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeNotificationSubscriptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeNotificationSubscriptionsRequestProtocolMarshaller(this.protocolFactory).marshall((DescribeNotificationSubscriptionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeNotificationSubscriptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeNotificationSubscriptionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeNotificationSubscriptionsResult describeNotificationSubscriptionsResult = (DescribeNotificationSubscriptionsResult)response.getAwsResponse();
            return describeNotificationSubscriptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeResourcePermissionsResult describeResourcePermissions(DescribeResourcePermissionsRequest request) {
        request = (DescribeResourcePermissionsRequest)this.beforeClientExecution(request);
        return this.executeDescribeResourcePermissions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeResourcePermissionsResult executeDescribeResourcePermissions(DescribeResourcePermissionsRequest describeResourcePermissionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeResourcePermissionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeResourcePermissionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeResourcePermissionsRequestProtocolMarshaller(this.protocolFactory).marshall((DescribeResourcePermissionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeResourcePermissionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeResourcePermissionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeResourcePermissionsResult describeResourcePermissionsResult = (DescribeResourcePermissionsResult)response.getAwsResponse();
            return describeResourcePermissionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeUsersResult describeUsers(DescribeUsersRequest request) {
        request = (DescribeUsersRequest)this.beforeClientExecution(request);
        return this.executeDescribeUsers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeUsersResult executeDescribeUsers(DescribeUsersRequest describeUsersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeUsersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeUsersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeUsersRequestProtocolMarshaller(this.protocolFactory).marshall((DescribeUsersRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeUsersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeUsersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeUsersResult describeUsersResult = (DescribeUsersResult)response.getAwsResponse();
            return describeUsersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDocumentResult getDocument(GetDocumentRequest request) {
        request = (GetDocumentRequest)this.beforeClientExecution(request);
        return this.executeGetDocument(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDocumentResult executeGetDocument(GetDocumentRequest getDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDocumentRequestProtocolMarshaller(this.protocolFactory).marshall((GetDocumentRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDocumentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDocumentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDocumentResult getDocumentResult = (GetDocumentResult)response.getAwsResponse();
            return getDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDocumentPathResult getDocumentPath(GetDocumentPathRequest request) {
        request = (GetDocumentPathRequest)this.beforeClientExecution(request);
        return this.executeGetDocumentPath(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDocumentPathResult executeGetDocumentPath(GetDocumentPathRequest getDocumentPathRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDocumentPathRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDocumentPathRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDocumentPathRequestProtocolMarshaller(this.protocolFactory).marshall((GetDocumentPathRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDocumentPathRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDocumentPathResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDocumentPathResult getDocumentPathResult = (GetDocumentPathResult)response.getAwsResponse();
            return getDocumentPathResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDocumentVersionResult getDocumentVersion(GetDocumentVersionRequest request) {
        request = (GetDocumentVersionRequest)this.beforeClientExecution(request);
        return this.executeGetDocumentVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDocumentVersionResult executeGetDocumentVersion(GetDocumentVersionRequest getDocumentVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDocumentVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDocumentVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDocumentVersionRequestProtocolMarshaller(this.protocolFactory).marshall((GetDocumentVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDocumentVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDocumentVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDocumentVersionResult getDocumentVersionResult = (GetDocumentVersionResult)response.getAwsResponse();
            return getDocumentVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetFolderResult getFolder(GetFolderRequest request) {
        request = (GetFolderRequest)this.beforeClientExecution(request);
        return this.executeGetFolder(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFolderResult executeGetFolder(GetFolderRequest getFolderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFolderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFolderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFolderRequestProtocolMarshaller(this.protocolFactory).marshall((GetFolderRequest)super.beforeMarshalling((AmazonWebServiceRequest)getFolderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFolderResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFolderResult getFolderResult = (GetFolderResult)response.getAwsResponse();
            return getFolderResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetFolderPathResult getFolderPath(GetFolderPathRequest request) {
        request = (GetFolderPathRequest)this.beforeClientExecution(request);
        return this.executeGetFolderPath(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFolderPathResult executeGetFolderPath(GetFolderPathRequest getFolderPathRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFolderPathRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFolderPathRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFolderPathRequestProtocolMarshaller(this.protocolFactory).marshall((GetFolderPathRequest)super.beforeMarshalling((AmazonWebServiceRequest)getFolderPathRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFolderPathResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFolderPathResult getFolderPathResult = (GetFolderPathResult)response.getAwsResponse();
            return getFolderPathResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InitiateDocumentVersionUploadResult initiateDocumentVersionUpload(InitiateDocumentVersionUploadRequest request) {
        request = (InitiateDocumentVersionUploadRequest)this.beforeClientExecution(request);
        return this.executeInitiateDocumentVersionUpload(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InitiateDocumentVersionUploadResult executeInitiateDocumentVersionUpload(InitiateDocumentVersionUploadRequest initiateDocumentVersionUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initiateDocumentVersionUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateDocumentVersionUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateDocumentVersionUploadRequestProtocolMarshaller(this.protocolFactory).marshall((InitiateDocumentVersionUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)initiateDocumentVersionUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitiateDocumentVersionUploadResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InitiateDocumentVersionUploadResult initiateDocumentVersionUploadResult = (InitiateDocumentVersionUploadResult)response.getAwsResponse();
            return initiateDocumentVersionUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemoveAllResourcePermissionsResult removeAllResourcePermissions(RemoveAllResourcePermissionsRequest request) {
        request = (RemoveAllResourcePermissionsRequest)this.beforeClientExecution(request);
        return this.executeRemoveAllResourcePermissions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemoveAllResourcePermissionsResult executeRemoveAllResourcePermissions(RemoveAllResourcePermissionsRequest removeAllResourcePermissionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeAllResourcePermissionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveAllResourcePermissionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveAllResourcePermissionsRequestProtocolMarshaller(this.protocolFactory).marshall((RemoveAllResourcePermissionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeAllResourcePermissionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveAllResourcePermissionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveAllResourcePermissionsResult removeAllResourcePermissionsResult = (RemoveAllResourcePermissionsResult)response.getAwsResponse();
            return removeAllResourcePermissionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemoveResourcePermissionResult removeResourcePermission(RemoveResourcePermissionRequest request) {
        request = (RemoveResourcePermissionRequest)this.beforeClientExecution(request);
        return this.executeRemoveResourcePermission(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemoveResourcePermissionResult executeRemoveResourcePermission(RemoveResourcePermissionRequest removeResourcePermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeResourcePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveResourcePermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveResourcePermissionRequestProtocolMarshaller(this.protocolFactory).marshall((RemoveResourcePermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeResourcePermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveResourcePermissionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveResourcePermissionResult removeResourcePermissionResult = (RemoveResourcePermissionResult)response.getAwsResponse();
            return removeResourcePermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDocumentResult updateDocument(UpdateDocumentRequest request) {
        request = (UpdateDocumentRequest)this.beforeClientExecution(request);
        return this.executeUpdateDocument(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDocumentResult executeUpdateDocument(UpdateDocumentRequest updateDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDocumentRequestProtocolMarshaller(this.protocolFactory).marshall((UpdateDocumentRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDocumentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDocumentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDocumentResult updateDocumentResult = (UpdateDocumentResult)response.getAwsResponse();
            return updateDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDocumentVersionResult updateDocumentVersion(UpdateDocumentVersionRequest request) {
        request = (UpdateDocumentVersionRequest)this.beforeClientExecution(request);
        return this.executeUpdateDocumentVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDocumentVersionResult executeUpdateDocumentVersion(UpdateDocumentVersionRequest updateDocumentVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDocumentVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDocumentVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDocumentVersionRequestProtocolMarshaller(this.protocolFactory).marshall((UpdateDocumentVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDocumentVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDocumentVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDocumentVersionResult updateDocumentVersionResult = (UpdateDocumentVersionResult)response.getAwsResponse();
            return updateDocumentVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateFolderResult updateFolder(UpdateFolderRequest request) {
        request = (UpdateFolderRequest)this.beforeClientExecution(request);
        return this.executeUpdateFolder(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateFolderResult executeUpdateFolder(UpdateFolderRequest updateFolderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFolderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFolderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFolderRequestProtocolMarshaller(this.protocolFactory).marshall((UpdateFolderRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFolderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFolderResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFolderResult updateFolderResult = (UpdateFolderResult)response.getAwsResponse();
            return updateFolderResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateUserResult updateUser(UpdateUserRequest request) {
        request = (UpdateUserRequest)this.beforeClientExecution(request);
        return this.executeUpdateUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateUserResult executeUpdateUser(UpdateUserRequest updateUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateUserRequestProtocolMarshaller(this.protocolFactory).marshall((UpdateUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateUserResult updateUserResult = (UpdateUserResult)response.getAwsResponse();
            return updateUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

