/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.services.workdocs.ContentManager;
import com.amazonaws.services.workdocs.ContentManagerAsyncBuilder;
import com.amazonaws.services.workdocs.GetDocumentStreamRequest;
import com.amazonaws.services.workdocs.GetDocumentStreamResult;
import com.amazonaws.services.workdocs.UploadDocumentStreamRequest;
import com.amazonaws.services.workdocs.UploadDocumentStreamResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
@SdkInternalApi
public class ContentManagerAsync
extends ContentManager {
    private final ExecutorService executorService;

    @SdkInternalApi
    ContentManagerAsync(ContentManagerAsyncBuilder contentManagerAsyncBuilder) {
        super(contentManagerAsyncBuilder);
        ExecutorService executorService = contentManagerAsyncBuilder.getExecutorService();
        if (executorService == null) {
            throw new IllegalArgumentException("ExecutorService must be specified.");
        }
        this.executorService = executorService;
    }

    public Future<GetDocumentStreamResult> getDocumentStreamAsync(final GetDocumentStreamRequest getDocumentStreamRequest) {
        Callable<GetDocumentStreamResult> task = new Callable<GetDocumentStreamResult>(){

            @Override
            public GetDocumentStreamResult call() {
                return ContentManagerAsync.this.getDocumentStream(getDocumentStreamRequest);
            }
        };
        return this.executorService.submit(task);
    }

    public Future<UploadDocumentStreamResult> uploadDocumentStreamAsync(final UploadDocumentStreamRequest uploadDocumentStreamRequest) throws IllegalArgumentException {
        Callable<UploadDocumentStreamResult> task = new Callable<UploadDocumentStreamResult>(){

            @Override
            public UploadDocumentStreamResult call() {
                return ContentManagerAsync.this.uploadDocumentStream(uploadDocumentStreamRequest);
            }
        };
        return this.executorService.submit(task);
    }

    public void shutdownNow(boolean shutdownWorkDocsClient) {
        this.executorService.shutdownNow();
        if (shutdownWorkDocsClient) {
            super.getWorkDocsClient().shutdown();
        }
    }
}

