/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.comms;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IRelayCallback;
import com.bitheads.braincloud.client.IRelayConnectCallback;
import com.bitheads.braincloud.client.IRelaySystemCallback;
import com.bitheads.braincloud.client.RelayConnectionType;
import java.io.DataInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RelayComms {
    private final boolean VERBOSE_LOG = true;
    private final int MAX_PACKET_ID_HISTORY = 600;
    private final int MAX_PLAYERS = 40;
    private final int INVALID_NET_ID = 40;
    private final int CL2RS_CONNECT = 0;
    private final int CL2RS_DISCONNECT = 1;
    private final int CL2RS_RELAY = 2;
    private final int CL2RS_ACK = 3;
    private final int CL2RS_PING = 4;
    private final int CL2RS_RSMG_ACK = 5;
    private final int CL2RS_ENDMATCH = 6;
    private final int RS2CL_RSMG = 0;
    private final int RS2CL_DISCONNECT = 1;
    private final int RS2CL_RELAY = 2;
    private final int RS2CL_ACK = 3;
    private final int RS2CL_PONG = 4;
    private final int RELIABLE_BIT = 32768;
    private final int ORDERED_BIT = 16384;
    private final long CONNECT_RESEND_INTERVAL_MS = 500L;
    private final int MAX_PACKET_ID = 4095;
    private final int PACKET_LOWER_THRESHOLD = 1023;
    private final int PACKET_HIGHER_THRESHOLD = 3071;
    private final int MAX_PACKET_SIZE = 1024;
    private final int TIMEOUT_MS = 10000;
    private ArrayList<Reliable> _reliables = new ArrayList();
    private ArrayList<UdpRsmgPacket> _udpRsmgPackets = new ArrayList();
    private ArrayList<Integer> _rsmgHistory = new ArrayList();
    private int _nextExpectedUdpRsmgPacketId = 0;
    private BrainCloudClient _client;
    private boolean _loggingEnabled = false;
    private IRelayConnectCallback _connectCallback = null;
    private ArrayList<RelayCallback> _callbackEventQueue = new ArrayList();
    private boolean _isConnected = false;
    private boolean _isConnecting = false;
    private long _lastConnectTryTime = 0L;
    private int _netId = -1;
    private String _ownerCxId = null;
    private ConnectInfo _connectInfo = null;
    private HashMap<Integer, String> _netIdToCxId = new HashMap();
    private HashMap<String, Integer> _cxIdToNetId = new HashMap();
    private HashMap<Long, Integer> _sendPacketId = new HashMap();
    private HashMap<Long, Integer> _recvPacketId = new HashMap();
    private HashMap<Long, ArrayList<RelayPacket>> _orderedReliablePackets = new HashMap();
    private ArrayList<HashMap<Integer, Integer>> _trackedPacketIds = new ArrayList();
    private int _ping = 999;
    private int _pingIntervalMS = 1000;
    private long _lastPingTime = 0L;
    private long _lastRecvTime = 0L;
    private RelayConnectionType _connectionType = RelayConnectionType.WEBSOCKET;
    private WSClient _webSocketClient;
    private Socket _tcpSocket;
    private DatagramSocket _udpSocket;
    private InetAddress _udpAddr;
    private int _udpPort;
    private Object _lock = new Object();
    private IRelayCallback _relayCallback = null;
    private IRelaySystemCallback _relaySystemCallback = null;
    private boolean _endMatchRequested;

    public RelayComms(BrainCloudClient client) {
        this._client = client;
    }

    public boolean getLoggingEnabled() {
        return this._loggingEnabled;
    }

    public void enableLogging(boolean isEnabled) {
        this._loggingEnabled = isEnabled;
    }

    public void connect(RelayConnectionType connectionType, JSONObject options, IRelayConnectCallback callback) {
        String lobbyId;
        String passcode;
        int port;
        String host;
        boolean ssl;
        if (this._isConnected) {
            this.disconnect();
        }
        this._endMatchRequested = false;
        this._connectionType = connectionType;
        this._isConnected = false;
        this._connectCallback = callback;
        this._ping = 999;
        this._netIdToCxId.clear();
        this._cxIdToNetId.clear();
        this._netId = -1;
        this._ownerCxId = null;
        this._sendPacketId.clear();
        this._recvPacketId.clear();
        this._reliables.clear();
        this._orderedReliablePackets.clear();
        this._udpRsmgPackets.clear();
        this._rsmgHistory.clear();
        this._trackedPacketIds.clear();
        if (options == null) {
            this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Invalid arguments"));
            return;
        }
        try {
            ssl = options.has("ssl") ? options.getBoolean("ssl") : false;
            host = options.getString("host");
            port = options.getInt("port");
            passcode = options.getString("passcode");
            lobbyId = options.getString("lobbyId");
        }
        catch (JSONException e) {
            e.printStackTrace();
            this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Invalid arguments"));
            return;
        }
        this._connectInfo = new ConnectInfo(passcode, lobbyId);
        switch (this._connectionType) {
            case WEBSOCKET: {
                try {
                    String uri = (ssl ? "wss://" : "ws://") + host + ":" + port;
                    this._webSocketClient = new WSClient(uri);
                    if (ssl) {
                        this.setupSSL();
                    }
                    this._webSocketClient.connect();
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Failed to connect"));
                    this.disconnect();
                    return;
                }
            }
            case TCP: {
                Thread connectionThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RelayComms.this._tcpSocket = new Socket(InetAddress.getByName(host), port);
                            RelayComms.this._tcpSocket.setTcpNoDelay(true);
                            if (RelayComms.this._loggingEnabled) {
                                System.out.println("RELAY TCP: Connected");
                            }
                            RelayComms.this.onTCPConnected();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            RelayComms.this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Failed to connect"));
                            RelayComms.this.disconnect();
                            return;
                        }
                    }
                });
                connectionThread.start();
                break;
            }
            case UDP: {
                try {
                    this._lastRecvTime = System.currentTimeMillis();
                    this._udpAddr = InetAddress.getByName(host);
                    this._udpSocket = new DatagramSocket();
                    this._udpPort = port;
                    if (this._loggingEnabled) {
                        System.out.println("RELAY UDP: Socket Open");
                    }
                    this.onUDPConnected();
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Failed to connect"));
                    this.disconnect();
                    return;
                }
            }
            default: {
                this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Protocol Unimplemented"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this._isConnected && this._connectionType == RelayConnectionType.UDP) {
            ByteBuffer buffer = ByteBuffer.allocate(3);
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putShort((short)3);
            buffer.put((byte)1);
            this.send(buffer);
        }
        Object object = this._lock;
        synchronized (object) {
            this._isConnected = false;
            this._isConnecting = false;
            if (!this._endMatchRequested) {
                if (this._webSocketClient != null) {
                    this._webSocketClient.close();
                    this._webSocketClient = null;
                }
                try {
                    if (this._tcpSocket != null) {
                        this._tcpSocket.close();
                        this._tcpSocket = null;
                    }
                }
                catch (Exception e) {
                    this._tcpSocket = null;
                }
                try {
                    if (this._udpSocket != null) {
                        this._udpSocket.close();
                        this._udpSocket = null;
                    }
                }
                catch (Exception e) {
                    this._udpSocket = null;
                }
            }
            this._connectInfo = null;
            this._reliables.clear();
            this._udpRsmgPackets.clear();
            this._rsmgHistory.clear();
            this._nextExpectedUdpRsmgPacketId = 0;
            this._sendPacketId.clear();
            this._recvPacketId.clear();
            this._reliables.clear();
            this._orderedReliablePackets.clear();
        }
    }

    public void endMatch(JSONObject json) {
        if (this.isConnected()) {
            byte[] jsonPayload = json.toString().getBytes();
            ByteBuffer buffer = ByteBuffer.allocate(3 + jsonPayload.length);
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putShort((short)3);
            buffer.put((byte)6);
            buffer.put(jsonPayload);
            this.send(buffer);
            this._endMatchRequested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        boolean ret;
        Object object = this._lock;
        synchronized (object) {
            ret = this._isConnected;
        }
        return ret;
    }

    public int getPing() {
        return this._ping;
    }

    public void setPingInterval(int intervalMS) {
        this._pingIntervalMS = intervalMS;
    }

    public String getOwnerProfileId() {
        if (this._ownerCxId == null) {
            return null;
        }
        String[] splits = this._ownerCxId.split(":");
        if (splits.length != 3) {
            return null;
        }
        return splits[1];
    }

    public String getProfileIdForNetId(int netId) {
        if (!this._netIdToCxId.containsKey(netId)) {
            return null;
        }
        String[] splits = this._netIdToCxId.get(netId).split(":");
        if (splits.length != 3) {
            return null;
        }
        return splits[1];
    }

    public int getNetIdForProfileId(String profileId) {
        for (Map.Entry<String, Integer> entry : this._cxIdToNetId.entrySet()) {
            String id;
            String[] splits = entry.getKey().split(":");
            if (splits.length != 3 || !(id = splits[1]).equals(profileId)) continue;
            return entry.getValue();
        }
        return 40;
    }

    public String getOwnerCxId() {
        return this._ownerCxId;
    }

    public String getCxIdForNetId(int netId) {
        return this._netIdToCxId.get(netId);
    }

    public int getNetIdForCxId(String cxId) {
        if (this._cxIdToNetId.containsKey(cxId)) {
            return this._cxIdToNetId.get(cxId);
        }
        return 40;
    }

    public void registerRelayCallback(IRelayCallback callback) {
        this._relayCallback = callback;
    }

    public void deregisterRelayCallback() {
        this._relayCallback = null;
    }

    public void registerSystemCallback(IRelaySystemCallback callback) {
        this._relaySystemCallback = callback;
    }

    public void deregisterSystemCallback() {
        this._relaySystemCallback = null;
    }

    private void setupSSL() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        SSLSocketFactory factory = sc.getSocketFactory();
        this._webSocketClient.setSocket(factory.createSocket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWSConnected() {
        try {
            this.send(0, this.buildConnectionRequest());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
            synchronized (arrayList) {
                this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Failed to build Connection Request"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTCPConnected() {
        try {
            this.startTCPReceivingThread();
            this.send(0, this.buildConnectionRequest());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
            synchronized (arrayList) {
                this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Failed to build Connection Request"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUDPConnected() {
        try {
            this.startUDPReceivingThread();
            this._isConnecting = true;
            this._lastConnectTryTime = System.currentTimeMillis();
            this.send(0, this.buildConnectionRequest());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
            synchronized (arrayList) {
                this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Failed to build Connection Request"));
            }
        }
    }

    private JSONObject buildConnectionRequest() throws Exception {
        JSONObject json = new JSONObject();
        json.put("lobbyId", (Object)this._connectInfo._lobbyId);
        json.put("cxId", (Object)this._client.getRttConnectionId());
        json.put("passcode", (Object)this._connectInfo._passcode);
        json.put("version", (Object)this._client.getBrainCloudVersion());
        return json;
    }

    private void send(int netId, JSONObject json) {
        this.send(netId, json.toString());
    }

    private void send(int netId, String text) {
        byte[] textBytes = text.getBytes(StandardCharsets.US_ASCII);
        int bufferSize = textBytes.length + 3;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putShort((short)bufferSize);
        buffer.put((byte)netId);
        buffer.put(textBytes, 0, textBytes.length);
        buffer.rewind();
        this.send(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(ByteBuffer buffer) {
        buffer.rewind();
        try {
            Object object = this._lock;
            synchronized (object) {
                switch (this._connectionType) {
                    case WEBSOCKET: {
                        if (this._webSocketClient == null) break;
                        this._webSocketClient.send(buffer);
                        break;
                    }
                    case TCP: {
                        if (this._tcpSocket == null) break;
                        byte[] bytes = buffer.array();
                        this._tcpSocket.getOutputStream().write(bytes, 0, bytes.length);
                        this._tcpSocket.getOutputStream().flush();
                        break;
                    }
                    case UDP: {
                        if (this._udpSocket == null) break;
                        byte[] bytes = buffer.array();
                        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this._udpAddr, this._udpPort);
                        this._udpSocket.send(packet);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.disconnect();
            ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
            synchronized (arrayList) {
                this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "RELAY Send Failed"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRelay(byte[] data, long in_playerMask, boolean reliable, boolean ordered, int channel) {
        if (!this.isConnected()) {
            return;
        }
        if (data.length > 1024) {
            ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
            synchronized (arrayList) {
                this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Packet too big " + data.length + " > max " + 1024));
            }
            return;
        }
        int bufferSize = data.length + 11;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putShort((short)bufferSize);
        buffer.put((byte)2);
        int rh = 0;
        if (reliable) {
            rh |= 0x8000;
        }
        if (ordered) {
            rh |= 0x4000;
        }
        rh |= channel << 12;
        long playerMask = 0L;
        for (long i = 0L; i < 40L; ++i) {
            playerMask |= (in_playerMask >> (int)(40L - i - 1L) & 1L) << (int)i;
        }
        playerMask = playerMask << 8 & 0xFFFFFFFFFF00L;
        long ackIdWithoutPacketId = (long)rh << 48 & 0xF000000000000000L | playerMask;
        int packetId = 0;
        Integer it = this._sendPacketId.get(ackIdWithoutPacketId);
        if (it != null) {
            packetId = it;
        }
        int nextPacketId = packetId + 1 & 0xFFF;
        this._sendPacketId.put(ackIdWithoutPacketId, nextPacketId);
        buffer.putShort((short)(rh |= packetId));
        buffer.putShort((short)(playerMask >> 32 & 0xFFFFL));
        buffer.putShort((short)(playerMask >> 16 & 0xFFFFL));
        buffer.putShort((short)(playerMask & 0xFFFFL));
        buffer.put(data, 0, data.length);
        this.send(buffer);
        if (reliable && this._connectionType == RelayConnectionType.UDP) {
            long ackId = (long)rh << 48 & 0xFFFF000000000000L | playerMask;
            Object object = this._lock;
            synchronized (object) {
                this._reliables.add(new Reliable(buffer, ackId, packetId, channel));
            }
        }
    }

    private void startTCPReceivingThread() {
        Thread receiveThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DataInputStream in;
                try {
                    Object object = RelayComms.this._lock;
                    synchronized (object) {
                        in = new DataInputStream(RelayComms.this._tcpSocket.getInputStream());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RelayComms.this.disconnect();
                    ArrayList arrayList = RelayComms.this._callbackEventQueue;
                    synchronized (arrayList) {
                        RelayComms.this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "TCP Connect Failed"));
                    }
                    return;
                }
                try {
                    while (true) {
                        int len = in.readShort() & 0xFFFF;
                        byte[] bytes = new byte[len - 2];
                        in.readFully(bytes);
                        ByteBuffer buffer = ByteBuffer.allocate(len);
                        buffer.order(ByteOrder.BIG_ENDIAN);
                        buffer.putShort((short)len);
                        buffer.put(bytes, 0, bytes.length);
                        buffer.rewind();
                        RelayComms.this.onRecv(buffer);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RelayComms.this.disconnect();
                    ArrayList arrayList = RelayComms.this._callbackEventQueue;
                    synchronized (arrayList) {
                        RelayComms.this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "TCP Connect Failed"));
                    }
                    return;
                }
            }
        });
        receiveThread.start();
    }

    private void startUDPReceivingThread() {
        Thread receivingThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] receiveData = new byte[1400];
                DatagramPacket packet = new DatagramPacket(receiveData, receiveData.length);
                try {
                    DatagramSocket socket;
                    while ((socket = RelayComms.this._udpSocket) != null) {
                        try {
                            socket.receive(packet);
                        }
                        catch (SocketTimeoutException e) {
                            continue;
                        }
                        catch (SocketException e) {
                            if (!e.getMessage().equals("socket closed")) {
                                throw e;
                            }
                            break;
                        }
                        ByteBuffer buffer = ByteBuffer.allocate(packet.getLength());
                        buffer.order(ByteOrder.BIG_ENDIAN);
                        buffer.put(packet.getData(), 0, packet.getLength());
                        buffer.rewind();
                        RelayComms.this._lastRecvTime = System.currentTimeMillis();
                        RelayComms.this.onRecv(buffer);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RelayComms.this.disconnect();
                    ArrayList arrayList = RelayComms.this._callbackEventQueue;
                    synchronized (arrayList) {
                        RelayComms.this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "UDP Receive Failed"));
                    }
                    return;
                }
            }
        });
        receivingThread.start();
    }

    private void sendPing() {
        if (this._loggingEnabled) {
            System.out.println("RELAY SEND: PING");
        }
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putShort((short)5);
        buffer.put((byte)4);
        buffer.putShort((short)this._ping);
        this.send(buffer);
        this._lastPingTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRecv(ByteBuffer buffer) {
        int len = buffer.limit();
        if (len < 3) {
            this.disconnect();
            ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
            synchronized (arrayList) {
                this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Relay Recv Error: packet cannot be smaller than 3 bytes"));
            }
            return;
        }
        buffer.rewind();
        buffer.order(ByteOrder.BIG_ENDIAN);
        int size = buffer.getShort() & 0xFFFF;
        int controlByte = buffer.get() & 0xFF;
        if (len < size) {
            this.disconnect();
            ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
            synchronized (arrayList) {
                this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Relay Recv Error: Packet is smaller than header's size"));
            }
            return;
        }
        if (controlByte == 0) {
            if (size < 5) {
                this.disconnect();
                ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
                synchronized (arrayList) {
                    this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Relay Recv Error: RSMG cannot be smaller than 5 bytes"));
                }
                return;
            }
            this.onRSMG(buffer, size - 3);
        } else {
            if (controlByte == 1) {
                this.disconnect();
                ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
                synchronized (arrayList) {
                    this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Relay: Disconnected by server"));
                }
                return;
            }
            if (controlByte == 4) {
                this.onPONG();
            } else if (controlByte == 3) {
                if (size < 11) {
                    this.disconnect();
                    ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
                    synchronized (arrayList) {
                        this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Relay Recv Error: ack packet cannot be smaller than 11 bytes"));
                    }
                    return;
                }
                if (this._connectionType == RelayConnectionType.UDP) {
                    this.onACK(buffer, size - 3);
                }
            } else if (controlByte == 2) {
                if (size < 11) {
                    this.disconnect();
                    ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
                    synchronized (arrayList) {
                        this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Relay Recv Error: relay packet cannot be smaller than 11 bytes"));
                    }
                    return;
                }
                this.onRelay(buffer, size - 3);
            } else {
                this.disconnect();
                ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
                synchronized (arrayList) {
                    this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Relay Recv Error: Unknown control byte: " + controlByte));
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onACK(ByteBuffer buffer, int size) {
        short rh = buffer.getShort();
        short playerMask0 = buffer.getShort();
        short playerMask1 = buffer.getShort();
        short playerMask2 = buffer.getShort();
        long ackId = (long)rh << 48 & 0xFFFF000000000000L | (long)playerMask0 << 32 & 0xFFFF00000000L | (long)playerMask1 << 16 & 0xFFFF0000L | (long)playerMask2 & 0xFFFFL;
        Object object = this._lock;
        synchronized (object) {
            for (int i = 0; i < this._reliables.size(); ++i) {
                Reliable reliable = this._reliables.get(i);
                if (reliable.ackId != ackId) continue;
                this._reliables.remove(i);
                break;
            }
        }
    }

    private boolean packetLE(int a, int b) {
        if (a > 3071 && b <= 1023) {
            return true;
        }
        if (b > 3071 && a <= 1023) {
            return false;
        }
        return a <= b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRelay(ByteBuffer buffer, int size) {
        Object object;
        short rh = buffer.getShort();
        short playerMask0 = buffer.getShort();
        short playerMask1 = buffer.getShort();
        short playerMask2 = buffer.getShort();
        long ackId = (long)rh << 48 & 0xFFFF000000000000L | (long)playerMask0 << 32 & 0xFFFF00000000L | (long)playerMask1 << 16 & 0xFFFF0000L | (long)playerMask2 & 0xFFFFL;
        long ackIdWithoutPacketId = ackId & 0xF000FFFFFFFFFFFFL;
        boolean reliable = (rh & 0x8000) != 0;
        boolean ordered = (rh & 0x4000) != 0;
        int channel = (int)((long)(rh >> 12) & 3L);
        int packetId = (int)((long)rh & 0xFFFL);
        int netId = (int)((long)playerMask2 & 0xFFL);
        byte[] eventBuffer = new byte[size - 8];
        buffer.position(11);
        buffer.get(eventBuffer, 0, size - 8);
        if (this._connectionType == RelayConnectionType.UDP) {
            if (reliable) {
                ByteBuffer ack = ByteBuffer.allocate(11);
                ack.order(ByteOrder.BIG_ENDIAN);
                ack.putShort((short)11);
                ack.put((byte)3);
                ack.putShort(rh);
                ack.putShort(playerMask0);
                ack.putShort(playerMask1);
                ack.putShort(playerMask2);
                this.send(ack);
            }
            object = this._lock;
            synchronized (object) {
                if (ordered) {
                    int prevPacketId = 4095;
                    Integer it = this._recvPacketId.get(ackIdWithoutPacketId);
                    if (it != null) {
                        prevPacketId = it;
                    }
                    if (this._trackedPacketIds.size() > 0 && this._trackedPacketIds.get(channel).containsKey(netId)) {
                        prevPacketId = this._trackedPacketIds.get(channel).get(netId);
                        this._trackedPacketIds.get(channel).remove(netId);
                        System.out.printf("Found tracked packetId for channel: %d netId: %d which was %d%n", channel, netId, prevPacketId);
                    }
                    if (reliable) {
                        if (this.packetLE(packetId, prevPacketId)) {
                            if (this._loggingEnabled) {
                                System.out.println("Duplicated packet from: " + netId + ", got: " + packetId);
                            }
                            return;
                        }
                        if (!this._orderedReliablePackets.containsKey(ackIdWithoutPacketId)) {
                            this._orderedReliablePackets.put(ackIdWithoutPacketId, new ArrayList());
                        }
                        ArrayList<RelayPacket> orderedReliablePackets = this._orderedReliablePackets.get(ackIdWithoutPacketId);
                        if (packetId != (prevPacketId + 1 & 0xFFF)) {
                            int insertIdx;
                            if (orderedReliablePackets.size() > 600) {
                                this.disconnect();
                                ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
                                synchronized (arrayList) {
                                    this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Relay disconnected, too many queued out of order packets."));
                                }
                                return;
                            }
                            for (insertIdx = 0; insertIdx < orderedReliablePackets.size(); ++insertIdx) {
                                RelayPacket packet = orderedReliablePackets.get(insertIdx);
                                if (packet.packetId == packetId) {
                                    if (this._loggingEnabled) {
                                        System.out.println("Duplicated packet: " + packetId);
                                    }
                                    return;
                                }
                                if (this.packetLE(packetId, packet.packetId)) break;
                            }
                            if (this._loggingEnabled) {
                                System.out.println("Queuing out of order packet: " + packetId);
                            }
                            orderedReliablePackets.add(insertIdx, new RelayPacket(packetId, netId, eventBuffer));
                            return;
                        }
                        this._recvPacketId.put(ackIdWithoutPacketId, packetId);
                        ArrayList<RelayCallback> insertIdx = this._callbackEventQueue;
                        synchronized (insertIdx) {
                            this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.Relay, netId, eventBuffer));
                        }
                        while (orderedReliablePackets.size() > 0) {
                            RelayPacket packet = orderedReliablePackets.get(0);
                            if (packet.packetId != (packetId + 1 & 0xFFF)) break;
                            ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
                            synchronized (arrayList) {
                                this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.Relay, packet.netId, packet.data));
                            }
                            orderedReliablePackets.remove(0);
                            packetId = packet.packetId;
                            this._recvPacketId.put(ackIdWithoutPacketId, packetId);
                        }
                        return;
                    }
                    if (this.packetLE(packetId, prevPacketId)) {
                        if (this._loggingEnabled) {
                            System.out.println("RELAY Packet our of order: " + packetId + ", expected: " + (prevPacketId + 1 & 0xFFF));
                        }
                        return;
                    }
                    this._recvPacketId.put(ackIdWithoutPacketId, packetId);
                }
            }
        }
        object = this._callbackEventQueue;
        synchronized (object) {
            this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.Relay, netId, eventBuffer));
        }
    }

    private void onPONG() {
        this._ping = (int)Math.min(999L, System.currentTimeMillis() - this._lastPingTime);
        if (this._loggingEnabled) {
            System.out.println("RELAY PONG: " + this._ping);
        }
    }

    private void ackRSMG(int packetId) {
        if (this._loggingEnabled) {
            System.out.println("RELAY RSMG ACK: " + packetId);
        }
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putShort((short)5);
        buffer.put((byte)5);
        buffer.putShort((short)packetId);
        this.send(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRSMG(ByteBuffer buffer, int size) {
        block44: {
            try {
                ArrayList<RelayCallback> arrayList;
                int rsmgPacketId = buffer.getShort() & 0xFFFF;
                if (this._connectionType == RelayConnectionType.UDP) {
                    this.ackRSMG(rsmgPacketId);
                    for (int i = 0; i < this._rsmgHistory.size(); ++i) {
                        if (this._rsmgHistory.get(i) != rsmgPacketId) continue;
                        return;
                    }
                    this._rsmgHistory.add(rsmgPacketId);
                    while (this._rsmgHistory.size() > 600) {
                        this._rsmgHistory.remove(0);
                    }
                }
                byte[] bytes = new byte[size -= 2];
                buffer.get(bytes, 0, size);
                String jsonString = new String(bytes, StandardCharsets.US_ASCII);
                JSONObject json = new JSONObject(jsonString);
                if (this._loggingEnabled) {
                    System.out.println("RELAY System Msg: " + jsonString);
                }
                switch (json.getString("op")) {
                    case "CONNECT": {
                        int netId = json.getInt("netId");
                        String cxId = json.getString("cxId");
                        this._netIdToCxId.put(netId, cxId);
                        this._cxIdToNetId.put(cxId, netId);
                        if (!cxId.equals(this._client.getRttConnectionId())) break;
                        Object object = this._lock;
                        synchronized (object) {
                            if (!this._isConnected) {
                                this._isConnected = true;
                                this._isConnecting = false;
                                this._lastPingTime = System.currentTimeMillis();
                                this._netId = netId;
                                this._ownerCxId = json.getString("ownerCxId");
                                ArrayList<RelayCallback> arrayList2 = this._callbackEventQueue;
                                synchronized (arrayList2) {
                                    this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectSuccess, json));
                                }
                            }
                            break;
                        }
                    }
                    case "NET_ID": {
                        int netId = json.getInt("netId");
                        String cxId = json.getString("cxId");
                        JSONArray packetIdArray = json.getJSONArray("orderedPacketIds");
                        if (!packetIdArray.isEmpty()) {
                            for (int channelId = 0; channelId < packetIdArray.length(); ++channelId) {
                                int packetId = packetIdArray.getInt(channelId);
                                if (packetId == 0) continue;
                                HashMap<Integer, Integer> trackedPacketId = new HashMap<Integer, Integer>();
                                trackedPacketId.put(netId, packetId);
                                this._trackedPacketIds.add(trackedPacketId);
                                System.out.printf("Added tracked packetId %d for netId %d at channelId %d%n", packetId, netId, channelId);
                            }
                        }
                        this._netIdToCxId.put(netId, cxId);
                        this._cxIdToNetId.put(cxId, netId);
                        break;
                    }
                    case "MIGRATE_OWNER": {
                        this._ownerCxId = json.getString("cxId");
                        break;
                    }
                    case "END_MATCH": {
                        this._endMatchRequested = true;
                        this.disconnect();
                    }
                }
                if (this._connectionType == RelayConnectionType.UDP) {
                    int insertId;
                    if (rsmgPacketId == this._nextExpectedUdpRsmgPacketId) {
                        ++this._nextExpectedUdpRsmgPacketId;
                        arrayList = this._callbackEventQueue;
                        synchronized (arrayList) {
                            this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.System, json));
                        }
                        for (int i = 0; i < this._udpRsmgPackets.size(); ++i) {
                            UdpRsmgPacket packet = this._udpRsmgPackets.get(i);
                            if (packet.id != this._nextExpectedUdpRsmgPacketId) break block44;
                            ++this._nextExpectedUdpRsmgPacketId;
                            ArrayList<RelayCallback> arrayList3 = this._callbackEventQueue;
                            synchronized (arrayList3) {
                                this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.System, packet.json));
                            }
                            this._udpRsmgPackets.remove(i);
                            --i;
                        }
                        break block44;
                    }
                    for (insertId = 0; insertId < this._udpRsmgPackets.size(); ++insertId) {
                        UdpRsmgPacket packet = this._udpRsmgPackets.get(insertId);
                        if (packet.id == rsmgPacketId) {
                            return;
                        }
                        if (packet.id > rsmgPacketId) break;
                    }
                    UdpRsmgPacket packet = new UdpRsmgPacket();
                    packet.id = insertId;
                    packet.json = json;
                    this._udpRsmgPackets.add(insertId, packet);
                    break block44;
                }
                arrayList = this._callbackEventQueue;
                synchronized (arrayList) {
                    this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.System, json));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.disconnect();
                ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
                synchronized (arrayList) {
                    this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Relay System Msg error"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCallbacks() {
        long timeMs;
        ArrayList<RelayCallback> arrayList = this._callbackEventQueue;
        synchronized (arrayList) {
            while (!this._callbackEventQueue.isEmpty()) {
                RelayCallback relayCallback = this._callbackEventQueue.remove(0);
                switch (relayCallback._type) {
                    case ConnectSuccess: {
                        if (this._connectCallback == null) break;
                        this._connectCallback.relayConnectSuccess(relayCallback._json);
                        break;
                    }
                    case ConnectFailure: {
                        if (this._endMatchRequested || this._connectCallback == null) break;
                        this._connectCallback.relayConnectFailure(relayCallback._message);
                        break;
                    }
                    case Relay: {
                        if (this._relayCallback == null) break;
                        this._relayCallback.relayCallback(relayCallback._netId, relayCallback._data);
                        break;
                    }
                    case System: {
                        if (this._relaySystemCallback == null) break;
                        this._relaySystemCallback.relaySystemCallback(relayCallback._json);
                    }
                }
            }
        }
        if (this._isConnecting && (timeMs = System.currentTimeMillis()) - this._lastConnectTryTime > 500L) {
            this._lastConnectTryTime = timeMs;
            try {
                this.send(0, this.buildConnectionRequest());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.disconnect();
                ArrayList<RelayCallback> arrayList2 = this._callbackEventQueue;
                synchronized (arrayList2) {
                    this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Relay System Fail to build connection request"));
                }
                return;
            }
        }
        long nowMs = System.currentTimeMillis();
        if (this._connectionType == RelayConnectionType.UDP && this._isConnected) {
            boolean resendTimedOut = false;
            ArrayList<RelayCallback> arrayList3 = this._lock;
            synchronized (arrayList3) {
                for (int i = 0; i < this._reliables.size(); ++i) {
                    Reliable reliable = this._reliables.get(i);
                    long elapsedMs = nowMs - reliable.resendTimeMs;
                    if (elapsedMs < reliable.waitTimeMs) continue;
                    if (nowMs - reliable.sendTimeMs >= 10000L) {
                        resendTimedOut = true;
                        break;
                    }
                    reliable.waitTimeMs = Math.min(500L, reliable.waitTimeMs * 125L / 100L);
                    reliable.resendTimeMs = nowMs;
                    this.send(reliable.buffer);
                    if (!this._loggingEnabled) continue;
                    System.out.println("RELAY RESEND: " + reliable.packetId + ", " + reliable.ackId + ", Next resend in: " + reliable.waitTimeMs + "ms");
                }
            }
            if (resendTimedOut) {
                this.disconnect();
                arrayList3 = this._callbackEventQueue;
                synchronized (arrayList3) {
                    this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Timed out. Too many packet drops."));
                }
                return;
            }
        }
        if (this._connectionType == RelayConnectionType.UDP && (this._isConnecting || this._isConnected) && nowMs - this._lastRecvTime > 10000L) {
            this.disconnect();
            ArrayList<RelayCallback> arrayList4 = this._callbackEventQueue;
            synchronized (arrayList4) {
                this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "Relay Socket Timeout."));
            }
            return;
        }
        if (this._isConnected && System.currentTimeMillis() - this._lastPingTime >= (long)this._pingIntervalMS) {
            this.sendPing();
        }
    }

    private class ConnectInfo {
        public String _passcode;
        public String _lobbyId;

        ConnectInfo(String passcode, String lobbyId) {
            this._passcode = passcode;
            this._lobbyId = lobbyId;
        }
    }

    private class RelayCallback {
        public RelayCallbackType _type;
        public String _message;
        public JSONObject _json;
        public int _netId;
        public byte[] _data;

        RelayCallback(RelayCallbackType type) {
            this._type = type;
        }

        RelayCallback(RelayCallbackType type, String message) {
            this(type);
            this._message = message;
        }

        RelayCallback(RelayCallbackType type, JSONObject json) {
            this(type);
            this._json = json;
        }

        RelayCallback(RelayCallbackType type, int netId, byte[] data) {
            this(type);
            this._netId = netId;
            this._data = data;
        }
    }

    static enum RelayCallbackType {
        ConnectSuccess,
        ConnectFailure,
        Relay,
        System;

    }

    private class WSClient
    extends WebSocketClient {
        public WSClient(String ip) throws Exception {
            super(new URI(ip));
        }

        public void onMessage(String message) {
            RelayComms.this.onRecv(ByteBuffer.wrap(message.getBytes()));
        }

        public void onMessage(ByteBuffer bytes) {
            RelayComms.this.onRecv(bytes);
        }

        public void onOpen(ServerHandshake handshake) {
            System.out.println("Relay WS Connected");
            RelayComms.this.onWSConnected();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(int code, String reason, boolean remote) {
            if (RelayComms.this._endMatchRequested) {
                System.out.println("Relay WS onClose: end match");
            } else {
                System.out.println("Relay WS onClose: " + reason + ", code: " + Integer.toString(code) + ", remote: " + Boolean.toString(remote));
            }
            RelayComms.this.disconnect();
            ArrayList arrayList = RelayComms.this._callbackEventQueue;
            synchronized (arrayList) {
                RelayComms.this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "webSocket onClose: " + reason));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Exception e) {
            e.printStackTrace();
            RelayComms.this.disconnect();
            ArrayList arrayList = RelayComms.this._callbackEventQueue;
            synchronized (arrayList) {
                RelayComms.this._callbackEventQueue.add(new RelayCallback(RelayCallbackType.ConnectFailure, "webSocket onError"));
            }
        }
    }

    class Reliable {
        public ByteBuffer buffer;
        public int packetId;
        public long ackId;
        public long sendTimeMs;
        public long resendTimeMs;
        public long waitTimeMs;

        public Reliable(ByteBuffer _buffer, long _ackId, int _packetId, int channel) {
            this.buffer = _buffer;
            this.ackId = _ackId;
            this.packetId = _packetId;
            this.resendTimeMs = this.sendTimeMs = System.currentTimeMillis();
            this.waitTimeMs = channel <= 1 ? 50L : (channel == 2 ? 150L : 250L);
        }
    }

    class RelayPacket {
        public int packetId;
        public int netId;
        public byte[] data;

        public RelayPacket(int _packetId, int _netId, byte[] _data) {
            this.packetId = _packetId;
            this.netId = _netId;
            this.data = _data;
        }
    }

    public class UdpRsmgPacket {
        public int id;
        public JSONObject json;
    }
}

