/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.AuthenticationIds;
import com.bitheads.braincloud.client.AuthenticationType;
import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthenticationService {
    private BrainCloudClient _client;
    private PreviousAuthParams _previousAuthParams = new PreviousAuthParams();
    private String _anonymousId;
    private String _profileId;

    public AuthenticationService(BrainCloudClient client) {
        this._client = client;
    }

    public String getAnonymousId() {
        return this._anonymousId;
    }

    public void setAnonymousId(String anonymousId) {
        this._anonymousId = anonymousId;
    }

    public String getProfileId() {
        return this._profileId;
    }

    public void setProfileId(String profileId) {
        this._profileId = profileId;
    }

    public void retryPreviousAuthenticate(IServerCallback callback) {
        this.authenticate(this._previousAuthParams.externalId, this._previousAuthParams.authenticationToken, this._previousAuthParams.authenticationType, this._previousAuthParams.externalAuthName, this._previousAuthParams.forceCreate, this._previousAuthParams.extraJson, callback);
    }

    public void initialize(String profileId, String anonymousId) {
        this._anonymousId = anonymousId;
        this._profileId = profileId;
    }

    public void clearSavedProfileId() {
        this._profileId = "";
    }

    public String generateAnonymousId() {
        return UUID.randomUUID().toString();
    }

    public void authenticateAnonymous(boolean forceCreate, IServerCallback callback) {
        this.authenticate(this._anonymousId, "", AuthenticationType.Anonymous, null, forceCreate, null, callback);
    }

    public void authenticateAnonymous(String anonymousId, boolean forceCreate, IServerCallback callback) {
        this._anonymousId = anonymousId;
        this.authenticateAnonymous(forceCreate, callback);
    }

    public void authenticateEmailPassword(String email, String password, boolean forceCreate, IServerCallback callback) {
        this.authenticate(email, password, AuthenticationType.Email, null, forceCreate, null, callback);
    }

    public void authenticateExternal(String userId, String token, String externalAuthName, boolean forceCreate, IServerCallback callback) {
        this.authenticate(userId, token, AuthenticationType.External, externalAuthName, forceCreate, null, callback);
    }

    public void authenticateFacebook(String fbUserId, String fbAuthToken, boolean forceCreate, IServerCallback callback) {
        this.authenticate(fbUserId, fbAuthToken, AuthenticationType.Facebook, null, forceCreate, null, callback);
    }

    public void authenticateFacebookLimited(String fbLimitedUserId, String fbAuthToken, boolean forceCreate, IServerCallback callback) {
        this.authenticate(fbLimitedUserId, fbAuthToken, AuthenticationType.FacebookLimited, null, forceCreate, null, callback);
    }

    public void authenticateOculus(String oculusUserId, String oculusNonce, boolean forceCreate, IServerCallback callback) {
        this.authenticate(oculusUserId, oculusNonce, AuthenticationType.Oculus, null, forceCreate, null, callback);
    }

    public void authenticateApple(String appleUserId, String identityToken, boolean forceCreate, IServerCallback callback) {
        this.authenticate(appleUserId, identityToken, AuthenticationType.Apple, null, forceCreate, null, callback);
    }

    public void authenticateGoogle(String googleUserId, String serverAuthCode, boolean forceCreate, IServerCallback callback) {
        this.authenticate(googleUserId, serverAuthCode, AuthenticationType.Google, null, forceCreate, null, callback);
    }

    public void authenticateGoogleOpenId(String googleUserAccountEmail, String IdToken, boolean forceCreate, IServerCallback callback) {
        this.authenticate(googleUserAccountEmail, IdToken, AuthenticationType.GoogleOpenId, null, forceCreate, null, callback);
    }

    public void authenticateSteam(String steamUserId, String steamSessionTicket, boolean forceCreate, IServerCallback callback) {
        this.authenticate(steamUserId, steamSessionTicket, AuthenticationType.Steam, null, forceCreate, null, callback);
    }

    public void authenticateUltra(String ultraUsername, String ultraIdToken, boolean forceCreate, IServerCallback callback) {
        this.authenticate(ultraUsername, ultraIdToken, AuthenticationType.Ultra, null, forceCreate, null, callback);
    }

    public void authenticateTwitter(String userId, String token, String secret, boolean forceCreate, IServerCallback callback) {
        String tokenSecretCombo = token + ":" + secret;
        this.authenticate(userId, tokenSecretCombo, AuthenticationType.Twitter, null, forceCreate, null, callback);
    }

    public void authenticateUniversal(String userId, String userPassword, boolean forceCreate, IServerCallback callback) {
        this.authenticate(userId, userPassword, AuthenticationType.Universal, null, forceCreate, null, callback);
    }

    public void authenticateAdvanced(AuthenticationType authenticationType, AuthenticationIds ids, boolean forceCreate, String extraJson, IServerCallback callback) {
        this.authenticate(ids.externalId, ids.authenticationToken, AuthenticationType.Universal, ids.authenticationSubType, forceCreate, extraJson, callback);
    }

    public void authenticateParse(String userId, String authenticationToken, boolean forceCreate, IServerCallback callback) {
        this.authenticate(userId, authenticationToken, AuthenticationType.Parse, null, forceCreate, null, callback);
    }

    public void authenticateHandoff(String handoffId, String securityToken, IServerCallback callback) {
        this.authenticate(handoffId, securityToken, AuthenticationType.Handoff, null, false, null, callback);
    }

    public void authenticateSettopHandoff(String handoffCode, IServerCallback callback) {
        this.authenticate(handoffCode, "", AuthenticationType.SettopHandoff, null, false, null, callback);
    }

    public void resetEmailPassword(String email, IServerCallback callback) {
        try {
            JSONObject message = new JSONObject();
            message.put(Parameter.externalId.name(), (Object)email);
            message.put(Parameter.gameId.name(), (Object)this._client.getAppId());
            ServerCall serverCall = new ServerCall(ServiceName.authenticationV2, ServiceOperation.RESET_EMAIL_PASSWORD, message, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void resetEmailPasswordAdvanced(String email, String serviceParams, IServerCallback callback) {
        try {
            String appId = this._client.getAppId();
            JSONObject message = new JSONObject();
            message.put(Parameter.gameId.name(), (Object)appId);
            message.put(Parameter.emailAddress.name(), (Object)email);
            message.put(Parameter.serviceParams.name(), (Object)new JSONObject(serviceParams));
            ServerCall serverCall = new ServerCall(ServiceName.authenticationV2, ServiceOperation.RESET_EMAIL_PASSWORD_ADVANCED, message, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void resetEmailPasswordWithExpiry(String email, int tokenTtlInMinutes, IServerCallback callback) {
        try {
            JSONObject message = new JSONObject();
            message.put(Parameter.externalId.name(), (Object)email);
            message.put(Parameter.tokenTtlInMinutes.name(), tokenTtlInMinutes);
            message.put(Parameter.gameId.name(), (Object)this._client.getAppId());
            ServerCall serverCall = new ServerCall(ServiceName.authenticationV2, ServiceOperation.RESET_EMAIL_PASSWORD_WITH_EXPIRY, message, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void resetEmailPasswordAdvancedWithExpiry(String email, String serviceParams, int tokenTtlInMinutes, IServerCallback callback) {
        try {
            String appId = this._client.getAppId();
            JSONObject message = new JSONObject();
            message.put(Parameter.gameId.name(), (Object)appId);
            message.put(Parameter.emailAddress.name(), (Object)email);
            message.put(Parameter.serviceParams.name(), (Object)new JSONObject(serviceParams));
            message.put(Parameter.tokenTtlInMinutes.name(), tokenTtlInMinutes);
            ServerCall serverCall = new ServerCall(ServiceName.authenticationV2, ServiceOperation.RESET_EMAIL_PASSWORD_ADVANCED_WITH_EXPIRY, message, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void resetUniversalIdPassword(String universalId, IServerCallback callback) {
        try {
            JSONObject message = new JSONObject();
            message.put(Parameter.universalId.name(), (Object)universalId);
            message.put(Parameter.gameId.name(), (Object)this._client.getAppId());
            ServerCall serverCall = new ServerCall(ServiceName.authenticationV2, ServiceOperation.RESET_UNIVERSAL_ID_PASSWORD, message, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void resetUniversalIdPasswordAdvanced(String universalId, String serviceParams, IServerCallback callback) {
        try {
            String appId = this._client.getAppId();
            JSONObject message = new JSONObject();
            message.put(Parameter.gameId.name(), (Object)appId);
            message.put(Parameter.universalId.name(), (Object)universalId);
            message.put(Parameter.serviceParams.name(), (Object)new JSONObject(serviceParams));
            ServerCall serverCall = new ServerCall(ServiceName.authenticationV2, ServiceOperation.RESET_UNIVERSAL_ID_PASSWORD_ADVANCED, message, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void resetUniversalIdPasswordWithExpiry(String universalId, int tokenTtlInMinutes, IServerCallback callback) {
        try {
            JSONObject message = new JSONObject();
            message.put(Parameter.universalId.name(), (Object)universalId);
            message.put(Parameter.gameId.name(), (Object)this._client.getAppId());
            message.put(Parameter.tokenTtlInMinutes.name(), tokenTtlInMinutes);
            ServerCall serverCall = new ServerCall(ServiceName.authenticationV2, ServiceOperation.RESET_UNIVERSAL_ID_PASSWORD_WITH_EXPIRY, message, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void resetUniversalIdPasswordAdvancedWithExpiry(String universalId, String serviceParams, int tokenTtlInMinutes, IServerCallback callback) {
        try {
            String appId = this._client.getAppId();
            JSONObject message = new JSONObject();
            message.put(Parameter.gameId.name(), (Object)appId);
            message.put(Parameter.universalId.name(), (Object)universalId);
            message.put(Parameter.serviceParams.name(), (Object)new JSONObject(serviceParams));
            message.put(Parameter.tokenTtlInMinutes.name(), tokenTtlInMinutes);
            ServerCall serverCall = new ServerCall(ServiceName.authenticationV2, ServiceOperation.RESET_UNIVERSAL_ID_PASSWORD_ADVANCED_WITH_EXPIRY, message, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void authenticate(String externalId, String authenticationToken, AuthenticationType authenticationType, String externalAuthName, boolean forceCreate, String extraJson, IServerCallback callback) {
        try {
            this._previousAuthParams.externalId = externalId == null ? "" : externalId;
            this._previousAuthParams.authenticationToken = authenticationToken == null ? "" : authenticationToken;
            this._previousAuthParams.authenticationType = authenticationType;
            this._previousAuthParams.externalAuthName = externalAuthName == null ? "" : externalAuthName;
            this._previousAuthParams.forceCreate = forceCreate;
            this._previousAuthParams.extraJson = extraJson;
            JSONObject message = new JSONObject();
            message.put(Parameter.externalId.name(), (Object)externalId);
            message.put(Parameter.authenticationToken.name(), (Object)authenticationToken);
            message.put(Parameter.authenticationType.name(), (Object)authenticationType.toString());
            message.put(Parameter.forceCreate.name(), forceCreate);
            message.put(Parameter.profileId.name(), (Object)this._profileId);
            message.put(Parameter.anonymousId.name(), (Object)this._anonymousId);
            message.put(Parameter.gameId.name(), (Object)this._client.getAppId());
            message.put(Parameter.releasePlatform.name(), (Object)this._client.getReleasePlatform());
            message.put(Parameter.gameVersion.name(), (Object)this._client.getAppVersion());
            message.put(Parameter.clientLibVersion.name(), (Object)this._client.getBrainCloudVersion());
            if (StringUtil.IsOptionalParameterValid(externalAuthName)) {
                message.put(Parameter.externalAuthName.name(), (Object)externalAuthName);
            }
            message.put(Parameter.countryCode.name(), (Object)this._client.getCountryCode());
            message.put(Parameter.languageCode.name(), (Object)this._client.getLanguageCode());
            message.put(Parameter.timeZoneOffset.name(), this._client.getTimeZoneOffset());
            message.put("clientLib", (Object)"java");
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                message.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            ServerCall serverCall = new ServerCall(ServiceName.authenticationV2, ServiceOperation.AUTHENTICATE, message, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private class PreviousAuthParams {
        public String externalId = "";
        public String authenticationToken = "";
        public AuthenticationType authenticationType = AuthenticationType.Unknown;
        public String externalAuthName = "";
        public boolean forceCreate = true;
        public String extraJson;

        private PreviousAuthParams() {
        }
    }

    private static enum Parameter {
        externalId,
        emailAddress,
        authenticationToken,
        authenticationType,
        tokenTtlInMinutes,
        appId,
        gameId,
        forceCreate,
        releasePlatform,
        clientLibVersion,
        externalAuthName,
        extraJson,
        profileId,
        anonymousId,
        gameVersion,
        countryCode,
        serviceParams,
        languageCode,
        timeZoneOffset,
        universalId,
        handoffCode,
        serverAuthCode,
        googleUserId,
        googleUserAccountEmail,
        IdToken;

    }
}

