/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomEntityService {
    private BrainCloudClient _client;

    public CustomEntityService(BrainCloudClient client) {
        this._client = client;
    }

    public void createEntity(String entityType, String dataJson, String acl, long timeToLive, Boolean isOwned, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            JSONObject jsonData = new JSONObject(dataJson);
            data.put(Parameter.dataJson.name(), (Object)jsonData);
            if (StringUtil.IsOptionalParameterValid(acl)) {
                JSONObject jsonAcl = new JSONObject(acl);
                data.put(Parameter.acl.name(), (Object)jsonAcl);
            }
            data.put(Parameter.timeToLive.name(), timeToLive);
            data.put(Parameter.isOwned.name(), (Object)isOwned);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.CREATE_ENTITY, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void deleteEntity(String entityType, String entityId, int version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.DELETE_ENTITY, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getCount(String entityType, String whereJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            JSONObject whereData = new JSONObject(whereJson);
            data.put(Parameter.whereJson.name(), (Object)whereData);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.GET_COUNT, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getRandomEntitiesMatching(String entityType, String whereJson, int maxReturn, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            JSONObject whereData = new JSONObject(whereJson);
            data.put(Parameter.whereJson.name(), (Object)whereData);
            data.put(Parameter.maxReturn.name(), maxReturn);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.GET_RANDOM_ENTITIES_MATCHING, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void getPage(String entityType, int rowsPerPage, String searchJson, String sortJson, Boolean doCount, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.rowsPerPage.name(), rowsPerPage);
            JSONObject searchData = new JSONObject(searchJson);
            data.put(Parameter.searchJson.name(), (Object)searchData);
            JSONObject sortData = new JSONObject(sortJson);
            data.put(Parameter.sortJson.name(), (Object)sortData);
            data.put(Parameter.doCount.name(), (Object)doCount);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.GET_PAGE, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getEntityPage(String entityType, String context, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONObject jsonContext = new JSONObject(context);
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.context.name(), (Object)jsonContext);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.GET_ENTITY_PAGE, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void getPageOffset(String entityType, String context, int pageOffset, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.context.name(), (Object)context);
            data.put(Parameter.pageOffset.name(), pageOffset);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.GET_PAGE_BY_OFFSET, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getEntityPageOffset(String entityType, String context, int pageOffset, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.context.name(), (Object)context);
            data.put(Parameter.pageOffset.name(), pageOffset);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.GET_ENTITY_PAGE_OFFSET, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void readEntity(String entityType, String entityId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.entityId.name(), (Object)entityId);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.READ_ENTITY, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateEntity(String entityType, String entityId, int version, String dataJson, String acl, long timeToLive, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            JSONObject jsonData = new JSONObject(dataJson);
            data.put(Parameter.dataJson.name(), (Object)jsonData);
            if (StringUtil.IsOptionalParameterValid(acl)) {
                JSONObject jsonAcl = new JSONObject(acl);
                data.put(Parameter.acl.name(), (Object)jsonAcl);
            }
            data.put(Parameter.timeToLive.name(), timeToLive);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.UPDATE_ENTITY, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateEntityFields(String entityType, String entityId, int version, String fieldsJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            JSONObject fieldsData = new JSONObject(fieldsJson);
            data.put(Parameter.fieldsJson.name(), (Object)fieldsData);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.UPDATE_ENTITY_FIELDS, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateEntityFieldsSharded(String entityType, String entityId, int version, String fieldsJson, String shardKeyJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            JSONObject fieldsData = new JSONObject(fieldsJson);
            data.put(Parameter.fieldsJson.name(), (Object)fieldsData);
            JSONObject shardKeyData = new JSONObject(shardKeyJson);
            data.put(Parameter.shardKeyJson.name(), (Object)shardKeyData);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.UPDATE_ENTITY_FIELDS_SHARDED, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void deleteEntities(String entityType, String deleteCriteria, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            JSONObject Data = new JSONObject(deleteCriteria);
            data.put(Parameter.deleteCriteria.name(), (Object)Data);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.DELETE_ENTITIES, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void deleteSingleton(String entityType, int version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.version.name(), version);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.DELETE_SINGLETON, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateSingleton(String entityType, int version, String dataJson, String acl, long timeToLive, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.version.name(), version);
            JSONObject jsonData = new JSONObject(dataJson);
            data.put(Parameter.dataJson.name(), (Object)jsonData);
            if (StringUtil.IsOptionalParameterValid(acl)) {
                JSONObject jsonAcl = new JSONObject(acl);
                data.put(Parameter.acl.name(), (Object)jsonAcl);
            }
            data.put(Parameter.timeToLive.name(), timeToLive);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.UPDATE_SINGLETON, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateSingletonFields(String entityType, int version, String fieldsJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.version.name(), version);
            JSONObject fieldsData = new JSONObject(fieldsJson);
            data.put(Parameter.fieldsJson.name(), (Object)fieldsData);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.UPDATE_SINGLETON_FIELDS, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void incrementData(String entityType, String entityId, String fieldsJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.entityId.name(), (Object)entityId);
            JSONObject fieldsData = new JSONObject(fieldsJson);
            data.put(Parameter.fieldsJson.name(), (Object)fieldsData);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.INCREMENT_DATA, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void readSingleton(String entityType, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.READ_SINGLETON, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void incrementSingletonData(String entityType, String fieldsJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            JSONObject fieldsData = new JSONObject(fieldsJson);
            data.put(Parameter.fieldsJson.name(), (Object)fieldsData);
            ServerCall serverCall = new ServerCall(ServiceName.customEntity, ServiceOperation.INCREMENT_SINGLETON_DATA, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static enum Parameter {
        entityId,
        dataJson,
        acl,
        timeToLive,
        isOwned,
        entityType,
        version,
        deleteCriteria,
        whereJson,
        maxReturn,
        rowsPerPage,
        searchJson,
        sortJson,
        doCount,
        pageOffset,
        context,
        fieldsJson,
        shardKeyJson;

    }
}

