/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONException;
import org.json.JSONObject;

public class EventService {
    private BrainCloudClient _client;

    public EventService(BrainCloudClient client) {
        this._client = client;
    }

    public void sendEvent(String toProfileId, String eventType, String jsonEventData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.toId.name(), (Object)toProfileId);
            data.put(Parameter.eventType.name(), (Object)eventType);
            JSONObject jsonData = new JSONObject(jsonEventData);
            data.put(Parameter.eventData.name(), (Object)jsonData);
            ServerCall sc = new ServerCall(ServiceName.event, ServiceOperation.SEND, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void updateIncomingEventData(String evId, String jsonEventData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.evId.name(), (Object)evId);
            JSONObject jsonData = new JSONObject(jsonEventData);
            data.put(Parameter.eventData.name(), (Object)jsonData);
            ServerCall sc = new ServerCall(ServiceName.event, ServiceOperation.UPDATE_EVENT_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void deleteIncomingEvent(String evId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.evId.name(), (Object)evId);
            ServerCall sc = new ServerCall(ServiceName.event, ServiceOperation.DELETE_INCOMING, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void deleteIncomingEvents(String[] evIds, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.evIds.name(), (Object)evIds);
            ServerCall serverCall = new ServerCall(ServiceName.event, ServiceOperation.DELETE_INCOMING_EVENTS, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void deleteIncomingEventsByTypeOlderThan(String eventType, long dateMillis, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.eventType.name(), (Object)eventType);
            data.put(Parameter.dateMillis.name(), dateMillis);
            ServerCall serverCall = new ServerCall(ServiceName.event, ServiceOperation.DELETE_INCOMING_EVENTS_BY_TYPE_OLDER_THAN, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void deleteIncomingEventsOlderThan(long dateMillis, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.dateMillis.name(), dateMillis);
            ServerCall serverCall = new ServerCall(ServiceName.event, ServiceOperation.DELETE_INCOMING_EVENTS_OLDER_THAN, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getEvents(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.event, ServiceOperation.GET_EVENTS, null, callback);
        this._client.sendRequest(sc);
    }

    private static enum Parameter {
        toId,
        eventType,
        eventData,
        recordLocally,
        fromId,
        eventId,
        includeIncomingEvents,
        includeSentEvents,
        evId,
        evIds,
        dateMillis;

    }
}

