/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.GroupACL;
import com.bitheads.braincloud.services.StringUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GroupService {
    private BrainCloudClient _client;

    public GroupService(BrainCloudClient client) {
        this._client = client;
    }

    public void acceptGroupInvitation(String groupId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.ACCEPT_GROUP_INVITATION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void addGroupMember(String groupId, String profileId, Role role, String jsonAttributes, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.profileId.name(), (Object)profileId);
            data.put(Parameter.role.name(), (Object)role.name());
            if (StringUtil.IsOptionalParameterValid(jsonAttributes)) {
                JSONObject obj = new JSONObject(jsonAttributes);
                data.put(Parameter.attributes.name(), (Object)obj);
            }
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.ADD_GROUP_MEMBER, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void approveGroupJoinRequest(String groupId, String profileId, Role role, String jsonAttributes, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.profileId.name(), (Object)profileId);
            data.put(Parameter.role.name(), (Object)role.name());
            if (StringUtil.IsOptionalParameterValid(jsonAttributes)) {
                data.put(Parameter.attributes.name(), (Object)new JSONObject(jsonAttributes));
            }
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.APPROVE_GROUP_JOIN_REQUEST, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void autoJoinGroup(String groupType, AutoJoinStrategy autoJoinStrategy, String dataQueryJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupType.name(), (Object)groupType);
            data.put(Parameter.autoJoinStrategy.name(), (Object)autoJoinStrategy);
            if (StringUtil.IsOptionalParameterValid(dataQueryJson)) {
                data.put(Parameter.where.name(), (Object)dataQueryJson);
            }
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.AUTO_JOIN_GROUP, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void autoJoinGroupMulti(String[] groupTypes, AutoJoinStrategy autoJoinStrategy, String where, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONArray jsonData = new JSONArray();
            for (String att : groupTypes) {
                jsonData.put((Object)att);
            }
            data.put(Parameter.groupTypes.name(), (Object)groupTypes);
            data.put(Parameter.autoJoinStrategy.name(), (Object)autoJoinStrategy);
            if (StringUtil.IsOptionalParameterValid(where)) {
                data.put(Parameter.where.name(), (Object)where);
            }
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.AUTO_JOIN_GROUP_MULTI, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void cancelGroupInvitation(String groupId, String profileId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.profileId.name(), (Object)profileId);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.CANCEL_GROUP_INVITATION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void createGroup(String name, String groupType, boolean isOpenGroup, GroupACL acl, String jsonData, String jsonOwnerAttributes, String jsonDefaultMemberAttributes, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.name.name(), (Object)name);
            data.put(Parameter.groupType.name(), (Object)groupType);
            data.put(Parameter.isOpenGroup.name(), isOpenGroup);
            if (acl != null) {
                data.put(Parameter.acl.name(), (Object)new JSONObject(acl.toJsonString()));
            }
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            }
            if (StringUtil.IsOptionalParameterValid(jsonOwnerAttributes)) {
                data.put(Parameter.ownerAttributes.name(), (Object)new JSONObject(jsonOwnerAttributes));
            }
            if (StringUtil.IsOptionalParameterValid(jsonDefaultMemberAttributes)) {
                data.put(Parameter.defaultMemberAttributes.name(), (Object)new JSONObject(jsonDefaultMemberAttributes));
            }
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.CREATE_GROUP, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void createGroupWithSummaryData(String name, String groupType, boolean isOpenGroup, GroupACL acl, String jsonData, String jsonOwnerAttributes, String jsonDefaultMemberAttributes, String summaryData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.name.name(), (Object)name);
            data.put(Parameter.groupType.name(), (Object)groupType);
            data.put(Parameter.isOpenGroup.name(), isOpenGroup);
            if (acl != null) {
                data.put(Parameter.acl.name(), (Object)new JSONObject(acl.toJsonString()));
            }
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            }
            if (StringUtil.IsOptionalParameterValid(jsonOwnerAttributes)) {
                data.put(Parameter.ownerAttributes.name(), (Object)new JSONObject(jsonOwnerAttributes));
            }
            if (StringUtil.IsOptionalParameterValid(jsonDefaultMemberAttributes)) {
                data.put(Parameter.defaultMemberAttributes.name(), (Object)new JSONObject(jsonDefaultMemberAttributes));
            }
            if (StringUtil.IsOptionalParameterValid(summaryData)) {
                data.put(Parameter.summaryData.name(), (Object)new JSONObject(summaryData));
            }
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.CREATE_GROUP, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void createGroupEntity(String groupId, String entityType, boolean isOwnedByGroupMember, GroupACL acl, String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            if (StringUtil.IsOptionalParameterValid(entityType)) {
                data.put(Parameter.entityType.name(), (Object)entityType);
            }
            data.put(Parameter.isOwnedByGroupMember.name(), isOwnedByGroupMember);
            if (acl != null) {
                data.put(Parameter.acl.name(), (Object)new JSONObject(acl.toJsonString()));
            }
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            }
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.CREATE_GROUP_ENTITY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void deleteGroup(String groupId, long version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.version.name(), version);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.DELETE_GROUP, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void deleteGroupEntity(String groupId, String entityId, long version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.DELETE_GROUP_ENTITY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getMyGroups(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.GET_MY_GROUPS, null, callback);
        this._client.sendRequest(sc);
    }

    public void incrementGroupData(String groupId, String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.INCREMENT_GROUP_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void incrementGroupEntityData(String groupId, String entityId, String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.INCREMENT_GROUP_ENTITY_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void inviteGroupMember(String groupId, String profileId, Role role, String jsonAttributes, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.profileId.name(), (Object)profileId);
            data.put(Parameter.role.name(), (Object)role.name());
            if (StringUtil.IsOptionalParameterValid(jsonAttributes)) {
                JSONObject obj = new JSONObject(jsonAttributes);
                data.put(Parameter.attributes.name(), (Object)obj);
            }
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.INVITE_GROUP_MEMBER, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void joinGroup(String groupId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.JOIN_GROUP, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void leaveGroup(String groupId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.LEAVE_GROUP, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void listGroupsPage(String jsonContext, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.context.name(), (Object)new JSONObject(jsonContext));
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.LIST_GROUPS_PAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void listGroupsPageByOffset(String encodedContext, int pageOffset, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.context.name(), (Object)encodedContext);
            data.put(Parameter.pageOffset.name(), pageOffset);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.LIST_GROUPS_PAGE_BY_OFFSET, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void listGroupsWithMember(String profileId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileId.name(), (Object)profileId);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.LIST_GROUPS_WITH_MEMBER, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void readGroup(String groupId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.READ_GROUP, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void readGroupEntitiesPage(String jsonContext, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.context.name(), (Object)new JSONObject(jsonContext));
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.READ_GROUP_ENTITIES_PAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void readGroupEntitiesPageByOffset(String encodedContext, int pageOffset, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.context.name(), (Object)encodedContext);
            data.put(Parameter.pageOffset.name(), pageOffset);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.READ_GROUP_ENTITIES_PAGE_BY_OFFSET, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void readGroupData(String groupId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.READ_GROUP_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void readGroupEntity(String groupId, String entityId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.entityId.name(), (Object)entityId);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.READ_GROUP_ENTITY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void readGroupMembers(String groupId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.READ_GROUP_MEMBERS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void rejectGroupInvitation(String groupId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.REJECT_GROUP_INVITATION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void rejectGroupJoinRequest(String groupId, String profileId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.profileId.name(), (Object)profileId);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.REJECT_GROUP_JOIN_REQUEST, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void removeGroupMember(String groupId, String profileId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.profileId.name(), (Object)profileId);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.REMOVE_GROUP_MEMBER, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void setGroupOpen(String groupId, boolean isOpenGroup, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.isOpenGroup.name(), isOpenGroup);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.SET_GROUP_OPEN, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void updateGroupData(String groupId, long version, String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.UPDATE_GROUP_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void updateGroupEntityData(String groupId, String entityId, long version, String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.UPDATE_GROUP_ENTITY_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void updateGroupMember(String groupId, String profileId, Role role, String jsonAttributes, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.profileId.name(), (Object)profileId);
            if (role != null) {
                data.put(Parameter.role.name(), (Object)role.name());
            }
            if (StringUtil.IsOptionalParameterValid(jsonAttributes)) {
                data.put(Parameter.attributes.name(), (Object)new JSONObject(jsonAttributes));
            }
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.UPDATE_GROUP_MEMBER, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void updateGroupName(String groupId, String name, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.name.name(), (Object)name);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.UPDATE_GROUP_NAME, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void updateGroupSummaryData(String groupId, int version, String jsonSummaryData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.version.name(), version);
            if (StringUtil.IsOptionalParameterValid(jsonSummaryData)) {
                data.put(Parameter.summaryData.name(), (Object)new JSONObject(jsonSummaryData));
            }
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.UPDATE_GROUP_SUMMARY_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getRandomGroupsMatching(String jsonWhere, int maxReturn, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (StringUtil.IsOptionalParameterValid(jsonWhere)) {
                data.put(Parameter.where.name(), (Object)new JSONObject(jsonWhere));
            }
            data.put(Parameter.maxReturn.name(), maxReturn);
            ServerCall sc = new ServerCall(ServiceName.group, ServiceOperation.GET_RANDOM_GROUPS_MATCHING, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private static enum Parameter {
        groupId,
        profileId,
        role,
        attributes,
        name,
        groupType,
        groupTypes,
        isOpenGroup,
        acl,
        data,
        ownerAttributes,
        defaultMemberAttributes,
        isOwnedByGroupMember,
        entityId,
        entityType,
        version,
        context,
        pageOffset,
        autoJoinStrategy,
        where,
        summaryData,
        maxReturn;

    }

    public static enum Role {
        OWNER,
        ADMIN,
        MEMBER,
        OTHER;

    }

    public static enum AutoJoinStrategy {
        JoinFirstGroup,
        JoinRandomGroup;

    }
}

