/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONException;
import org.json.JSONObject;

public class VirtualCurrencyService {
    private BrainCloudClient _client;

    public VirtualCurrencyService(BrainCloudClient client) {
        this._client = client;
    }

    public void getCurrency(String vcId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.vcId.name(), (Object)vcId);
            ServerCall sc = new ServerCall(ServiceName.virtualCurrency, ServiceOperation.GET_PLAYER_VC, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getParentCurrency(String vcId, String levelName, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.vcId.name(), (Object)vcId);
            data.put(Parameter.levelName.name(), (Object)levelName);
            ServerCall sc = new ServerCall(ServiceName.virtualCurrency, ServiceOperation.GET_PARENT_VC, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getPeerCurrency(String vcId, String peerCode, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.vcId.name(), (Object)vcId);
            data.put(Parameter.peerCode.name(), (Object)peerCode);
            ServerCall sc = new ServerCall(ServiceName.virtualCurrency, ServiceOperation.GET_PEER_VC, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void resetCurrency(IServerCallback callback) {
        JSONObject data = new JSONObject();
        ServerCall sc = new ServerCall(ServiceName.virtualCurrency, ServiceOperation.RESET_PLAYER_VC, data, callback);
        this._client.sendRequest(sc);
    }

    public void awardCurrency(String vcId, int vcAmount, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.vcId.name(), (Object)vcId);
            data.put(Parameter.vcAmount.name(), vcAmount);
            ServerCall sc = new ServerCall(ServiceName.virtualCurrency, ServiceOperation.AWARD_VC, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void consumeCurrency(String vcId, int vcAmount, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.vcId.name(), (Object)vcId);
            data.put(Parameter.vcAmount.name(), vcAmount);
            ServerCall sc = new ServerCall(ServiceName.virtualCurrency, ServiceOperation.CONSUME_VC, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private static enum Parameter {
        vcId,
        vcAmount,
        levelName,
        peerCode;

    }
}

