/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.client;

import com.bitheads.braincloud.client.AuthenticationIds;
import com.bitheads.braincloud.client.AuthenticationType;
import com.bitheads.braincloud.client.IBrainCloudWrapper;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import org.json.JSONObject;

public class SmartSwitchCallback
implements IServerCallback {
    protected IBrainCloudWrapper _wrapper;
    protected IServerCallback _callback;

    public SmartSwitchCallback(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
        this._wrapper = in_wrapper;
        this._callback = in_callback;
    }

    public void clearIds() {
        this._wrapper.resetStoredAnonymousId();
        this._wrapper.resetStoredProfileId();
        this._wrapper.getClient().getAuthenticationService().clearSavedProfileId();
    }

    @Override
    public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
        this._callback.serverCallback(serviceName, serviceOperation, jsonData);
    }

    @Override
    public void serverError(ServiceName in_serviceName, ServiceOperation in_serviceOperation, int in_statusCode, int in_reasonCode, String jsonString) {
        this._callback.serverError(in_serviceName, in_serviceOperation, in_statusCode, in_reasonCode, jsonString);
    }

    public class SmartSwitchAdvanced
    extends SmartSwitchCallback {
        private AuthenticationType _authenticationType;
        private AuthenticationIds _ids;
        private boolean _forceCreate;
        private String _extraJson;

        public SmartSwitchAdvanced(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
        }

        public SmartSwitchAdvanced(AuthenticationType in_authenticationType, AuthenticationIds in_ids, boolean in_forceCreate, String in_extraJson, IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
            this._authenticationType = in_authenticationType;
            this._ids = in_ids;
            this._forceCreate = in_forceCreate;
            this._extraJson = in_extraJson;
        }

        public void serverCallback(ServiceName in_serviceName, ServiceOperation serviceOperation, String jsonString) {
            this.clearIds();
            this._wrapper.getClient().getAuthenticationService().authenticateAdvanced(this._authenticationType, this._ids, this._forceCreate, this._extraJson, this._callback);
        }
    }

    public class SmartSwitchUltra
    extends SmartSwitchCallback {
        private String _ultraUserId;
        private String _ultraIdToken;
        private boolean _forceCreate;

        public SmartSwitchUltra(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
        }

        public SmartSwitchUltra(String in_ultraUserId, String in_ultraIdToken, boolean in_forceCreate, IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
            this._ultraUserId = in_ultraUserId;
            this._ultraIdToken = in_ultraIdToken;
            this._forceCreate = in_forceCreate;
        }

        public void serverCallback(ServiceName in_serviceName, ServiceOperation serviceOperation, String jsonString) {
            this.clearIds();
            this._wrapper.getClient().getAuthenticationService().authenticateUltra(this._ultraUserId, this._ultraIdToken, this._forceCreate, this._callback);
        }
    }

    public class SmartSwitchUniversal
    extends SmartSwitchCallback {
        private String _userId;
        private String _password;
        private boolean _forceCreate;

        public SmartSwitchUniversal(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
        }

        public SmartSwitchUniversal(String in_userId, String in_password, boolean in_forceCreate, IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
            this._userId = in_userId;
            this._password = in_password;
            this._forceCreate = in_forceCreate;
        }

        public void serverCallback(ServiceName in_serviceName, ServiceOperation serviceOperation, String jsonString) {
            this.clearIds();
            this._wrapper.getClient().getAuthenticationService().authenticateUniversal(this._userId, this._password, this._forceCreate, this._callback);
        }
    }

    public class SmartSwitchTwitter
    extends SmartSwitchCallback {
        private String _userId;
        private String _token;
        private String _secret;
        private boolean _forceCreate;

        public SmartSwitchTwitter(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
        }

        public SmartSwitchTwitter(String in_userId, String in_token, String in_secret, boolean in_forceCreate, IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
            this._userId = in_userId;
            this._token = in_token;
            this._secret = in_secret;
            this._forceCreate = in_forceCreate;
        }

        public void serverCallback(ServiceName in_serviceName, ServiceOperation serviceOperation, String jsonString) {
            this.clearIds();
            this._wrapper.getClient().getAuthenticationService().authenticateTwitter(this._userId, this._token, this._secret, this._forceCreate, this._callback);
        }
    }

    public class SmartSwitchSteam
    extends SmartSwitchCallback {
        private String _steamUserId;
        private String _sessionTicket;
        private boolean _forceCreate;

        public SmartSwitchSteam(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
        }

        public SmartSwitchSteam(String in_steamUserId, String in_sessionTicket, boolean in_forceCreate, IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
            this._steamUserId = in_steamUserId;
            this._sessionTicket = in_sessionTicket;
            this._forceCreate = in_forceCreate;
        }

        public void serverCallback(ServiceName in_serviceName, ServiceOperation serviceOperation, String jsonString) {
            this.clearIds();
            this._wrapper.getClient().getAuthenticationService().authenticateSteam(this._steamUserId, this._sessionTicket, this._forceCreate, this._callback);
        }
    }

    public class SmartSwitchApple
    extends SmartSwitchCallback {
        private String _appleUserId;
        private String _token;
        private boolean _forceCreate;

        public SmartSwitchApple(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
        }

        public SmartSwitchApple(String in_appleUserId, String in_token, boolean in_forceCreate, IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
            this._appleUserId = in_appleUserId;
            this._token = in_token;
            this._forceCreate = in_forceCreate;
        }

        public void serverCallback(ServiceName in_serviceName, ServiceOperation serviceOperation, String jsonString) {
            this.clearIds();
            this._wrapper.getClient().getAuthenticationService().authenticateApple(this._appleUserId, this._token, this._forceCreate, this._callback);
        }
    }

    public class SmartSwitchGoogleOpenId
    extends SmartSwitchCallback {
        private String _googleUserAccountEmail;
        private String _IdToken;
        private boolean _forceCreate;

        public SmartSwitchGoogleOpenId(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
        }

        public SmartSwitchGoogleOpenId(String in_googleUserAccountEmail, String in_IdToken, boolean in_forceCreate, IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
            this._googleUserAccountEmail = in_googleUserAccountEmail;
            this._IdToken = in_IdToken;
            this._forceCreate = in_forceCreate;
        }

        public void serverCallback(ServiceName in_serviceName, ServiceOperation serviceOperation, String jsonString) {
            this.clearIds();
            this._wrapper.getClient().getAuthenticationService().authenticateGoogle(this._googleUserAccountEmail, this._IdToken, this._forceCreate, this._callback);
        }
    }

    public class SmartSwitchGoogle
    extends SmartSwitchCallback {
        private String _googleUserId;
        private String _serverAuthCode;
        private boolean _forceCreate;

        public SmartSwitchGoogle(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
        }

        public SmartSwitchGoogle(String in_googleUserId, String in_serverAuthCode, boolean in_forceCreate, IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
            this._googleUserId = in_googleUserId;
            this._serverAuthCode = in_serverAuthCode;
            this._forceCreate = in_forceCreate;
        }

        public void serverCallback(ServiceName in_serviceName, ServiceOperation serviceOperation, String jsonString) {
            this.clearIds();
            this._wrapper.getClient().getAuthenticationService().authenticateGoogle(this._googleUserId, this._serverAuthCode, this._forceCreate, this._callback);
        }
    }

    public class SmartSwitchOculus
    extends SmartSwitchCallback {
        private String _oculusUserId;
        private String _oculusNonce;
        private boolean _forceCreate;

        public SmartSwitchOculus(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
        }

        public SmartSwitchOculus(String in_oculusUserId, String in_oculusNonce, boolean in_forceCreate, IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
            this._oculusUserId = in_oculusUserId;
            this._oculusNonce = in_oculusNonce;
            this._forceCreate = in_forceCreate;
        }

        public void serverCallback(ServiceName in_serviceName, ServiceOperation serviceOperation, String jsonString) {
            this.clearIds();
            this._wrapper.getClient().getAuthenticationService().authenticateOculus(this._oculusUserId, this._oculusNonce, this._forceCreate, this._callback);
        }
    }

    public class SmartSwitchFacebook
    extends SmartSwitchCallback {
        private String _fbUserId;
        private String _fbAuthToken;
        private boolean _forceCreate;

        public SmartSwitchFacebook(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
        }

        public SmartSwitchFacebook(String in_fbUserId, String in_fbAuthToken, boolean in_forceCreate, IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
            this._fbUserId = in_fbUserId;
            this._fbAuthToken = in_fbAuthToken;
            this._forceCreate = in_forceCreate;
        }

        public void serverCallback(ServiceName in_serviceName, ServiceOperation serviceOperation, String jsonString) {
            this.clearIds();
            this._wrapper.getClient().getAuthenticationService().authenticateFacebook(this._fbUserId, this._fbAuthToken, this._forceCreate, this._callback);
        }
    }

    public class SmartSwitchExternal
    extends SmartSwitchCallback {
        private String _userId;
        private String _token;
        private String _externalAuthName;
        private boolean _forceCreate;

        public SmartSwitchExternal(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
        }

        public SmartSwitchExternal(String in_userId, String in_token, String in_externalAuthName, boolean in_forceCreate, IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
            this._userId = in_userId;
            this._token = in_token;
            this._externalAuthName = in_externalAuthName;
            this._forceCreate = in_forceCreate;
        }

        public void serverCallback(ServiceName in_serviceName, ServiceOperation serviceOperation, String jsonString) {
            this.clearIds();
            this._wrapper.getClient().getAuthenticationService().authenticateExternal(this._userId, this._token, this._externalAuthName, this._forceCreate, this._callback);
        }
    }

    public class SmartSwitchEmail
    extends SmartSwitchCallback {
        private String _email;
        private String _password;
        private boolean _forceCreate;

        public SmartSwitchEmail(IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
        }

        public SmartSwitchEmail(String in_email, String in_password, boolean in_forceCreate, IBrainCloudWrapper in_wrapper, IServerCallback in_callback) {
            super(in_wrapper, in_callback);
            this._email = in_email;
            this._password = in_password;
            this._forceCreate = in_forceCreate;
        }

        public void serverCallback(ServiceName in_serviceName, ServiceOperation serviceOperation, String jsonString) {
            this.clearIds();
            this._wrapper.getClient().getAuthenticationService().authenticateEmailPassword(this._email, this._password, this._forceCreate, this._callback);
        }
    }
}

