/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONException;
import org.json.JSONObject;

public class AppStoreService {
    private BrainCloudClient _client;

    public AppStoreService(BrainCloudClient client) {
        this._client = client;
    }

    public void verifyPurchase(String storeId, String jsonReceiptData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.storeId.name(), (Object)storeId);
            data.put(Parameter.receiptData.name(), (Object)new JSONObject(jsonReceiptData));
            ServerCall sc = new ServerCall(ServiceName.appStore, ServiceOperation.VERIFY_PURCHASE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getEligiblePromotions(IServerCallback callback) {
        JSONObject data = new JSONObject();
        ServerCall sc = new ServerCall(ServiceName.appStore, ServiceOperation.ELIGIBLE_PROMOTIONS, data, callback);
        this._client.sendRequest(sc);
    }

    public void getSalesInventory(String storeId, String userCurrency, IServerCallback callback) {
        this.getSalesInventoryByCategory(storeId, userCurrency, null, callback);
    }

    public void getSalesInventoryByCategory(String storeId, String userCurrency, String category, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.storeId.name(), (Object)storeId);
            data.put(Parameter.category.name(), (Object)category);
            JSONObject priceInfoCriteria = new JSONObject();
            if (userCurrency != null) {
                priceInfoCriteria.put(Parameter.userCurrency.name(), (Object)userCurrency);
            }
            data.put(Parameter.priceInfoCriteria.name(), (Object)priceInfoCriteria);
            ServerCall sc = new ServerCall(ServiceName.appStore, ServiceOperation.GET_INVENTORY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void startPurchase(String storeId, String jsonPurchaseData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.storeId.name(), (Object)storeId);
            data.put(Parameter.purchaseData.name(), (Object)new JSONObject(jsonPurchaseData));
            ServerCall sc = new ServerCall(ServiceName.appStore, ServiceOperation.START_PURCHASE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void finalizePurchase(String storeId, String transactionId, String jsonTransactionData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.storeId.name(), (Object)storeId);
            data.put(Parameter.transactionId.name(), (Object)transactionId);
            data.put(Parameter.transactionData.name(), (Object)new JSONObject(jsonTransactionData));
            ServerCall sc = new ServerCall(ServiceName.appStore, ServiceOperation.FINALIZE_PURCHASE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void refreshPromotions(IServerCallback callback) {
        JSONObject data = new JSONObject();
        ServerCall sc = new ServerCall(ServiceName.appStore, ServiceOperation.REFRESH_PROMOTIONS, data, callback);
        this._client.sendRequest(sc);
    }

    private static enum Parameter {
        storeId,
        receiptData,
        category,
        priceInfoCriteria,
        userCurrency,
        purchaseData,
        transactionId,
        transactionData;

    }
}

