/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.AuthenticationType;
import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FriendService {
    private BrainCloudClient _client;

    public FriendService(BrainCloudClient client) {
        this._client = client;
    }

    public void getProfileInfoForCredential(String externalId, AuthenticationType authenticationType, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.externalId.name(), (Object)externalId);
            data.put(Parameter.authenticationType.name(), (Object)authenticationType.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.GET_PROFILE_INFO_FOR_CREDENTIAL, data, callback);
        this._client.sendRequest(sc);
    }

    public void getProfileInfoForExternalAuthId(String externalId, String externalAuthType, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.externalId.name(), (Object)externalId);
            data.put(Parameter.externalAuthType.name(), (Object)externalAuthType);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.GET_PROFILE_INFO_FOR_EXTERNAL_AUTH_ID, data, callback);
        this._client.sendRequest(sc);
    }

    public void getExternalIdForProfileId(String profileId, String authenticationType, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.profileId.name(), (Object)profileId);
            data.put(Parameter.authenticationType.name(), (Object)authenticationType);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.GET_EXTERNAL_ID_FOR_PROFILE_ID, data, callback);
        this._client.sendRequest(sc);
    }

    public void findUsersByExactName(String searchText, int maxResults, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.searchText.name(), (Object)searchText);
            data.put(Parameter.maxResults.name(), maxResults);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.FIND_USERS_BY_EXACT_NAME, data, callback);
        this._client.sendRequest(sc);
    }

    public void findUsersBySubstrName(String searchText, int maxResults, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.searchText.name(), (Object)searchText);
            data.put(Parameter.maxResults.name(), maxResults);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.FIND_USERS_BY_SUBSTR_NAME, data, callback);
        this._client.sendRequest(sc);
    }

    public void findUserByExactUniversalId(String searchText, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.searchText.name(), (Object)searchText);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.FIND_USER_BY_EXACT_UNIVERSAL_ID, data, callback);
        this._client.sendRequest(sc);
    }

    public void readFriendEntity(String friendId, String entityId, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.friendId.name(), (Object)friendId);
            data.put(Parameter.entityId.name(), (Object)entityId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.READ_FRIEND_ENTITY, data, callback);
        this._client.sendRequest(sc);
    }

    public void readFriendsEntities(String entityType, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            if (StringUtil.IsOptionalParameterValid(entityType)) {
                data.put(Parameter.entityType.name(), (Object)entityType);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.READ_FRIENDS_ENTITIES, data, callback);
        this._client.sendRequest(sc);
    }

    public void readFriendUserState(String friendId, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.friendId.name(), (Object)friendId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.READ_FRIEND_PLAYER_STATE, data, callback);
        this._client.sendRequest(sc);
    }

    public void listFriends(FriendPlatform friendPlatform, Boolean includeSummaryData, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.friendPlatform.name(), (Object)friendPlatform.name());
            data.put(Parameter.includeSummaryData.name(), (Object)includeSummaryData);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.LIST_FRIENDS, data, callback);
        this._client.sendRequest(sc);
    }

    public void getMySocialInfo(FriendPlatform friendPlatform, Boolean includeSummaryData, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.friendPlatform.name(), (Object)friendPlatform.name());
            data.put(Parameter.includeSummaryData.name(), (Object)includeSummaryData);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.GET_MY_SOCIAL_INFO, data, callback);
        this._client.sendRequest(sc);
    }

    public void addFriends(String[] profileIds, IServerCallback callback) {
        JSONArray profiles = new JSONArray();
        for (String achId : profileIds) {
            profiles.put((Object)achId);
        }
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.profileIds.name(), (Object)profiles);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.ADD_FRIENDS, data, callback);
        this._client.sendRequest(sc);
    }

    public void addFriendsFromPlatform(FriendPlatform friendPlatform, String mode, String[] externalIds, IServerCallback callback) {
        JSONArray externals = new JSONArray();
        for (String extId : externalIds) {
            externals.put((Object)extId);
        }
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.friendPlatform.name(), (Object)friendPlatform.name());
            data.put(Parameter.mode.name(), (Object)mode);
            data.put(Parameter.externalIds.name(), (Object)externals);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.ADD_FRIENDS_FROM_PLATFORM, data, callback);
        this._client.sendRequest(sc);
    }

    public void removeFriends(String[] profileIds, IServerCallback callback) {
        JSONArray profiles = new JSONArray();
        for (String achId : profileIds) {
            profiles.put((Object)achId);
        }
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.profileIds.name(), (Object)profiles);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.REMOVE_FRIENDS, data, callback);
        this._client.sendRequest(sc);
    }

    public void getSummaryDataForProfileId(String profileId, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.profileId.name(), (Object)profileId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.GET_SUMMARY_DATA_FOR_PROFILE_ID, data, callback);
        this._client.sendRequest(sc);
    }

    public void getUsersOnlineStatus(String[] profileIds, IServerCallback callback) {
        JSONArray profiles = new JSONArray();
        for (String achId : profileIds) {
            profiles.put((Object)achId);
        }
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.profileIds.name(), (Object)profiles);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.GET_USERS_ONLINE_STATUS, data, callback);
        this._client.sendRequest(sc);
    }

    public void findUsersByNameStartingWith(String searchText, int maxResults, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.searchText.name(), (Object)searchText);
            data.put(Parameter.entityId.name(), maxResults);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.FIND_USERS_BY_NAME_STARTING_WITH, data, callback);
        this._client.sendRequest(sc);
    }

    public void findUsersByUniversalIdStartingWith(String searchText, int maxResults, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.searchText.name(), (Object)searchText);
            data.put(Parameter.entityId.name(), maxResults);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.friend, ServiceOperation.FIND_USERS_BY_UNIVERSAL_ID_STARTING_WITH, data, callback);
        this._client.sendRequest(sc);
    }

    private static enum Parameter {
        externalId,
        externalIds,
        mode,
        authenticationType,
        profileId,
        searchText,
        maxResults,
        includeSummaryData,
        friendId,
        entityId,
        entityType,
        friendPlatform,
        profileIds,
        externalAuthType;

    }

    public static enum FriendPlatform {
        All,
        brainCloud,
        Facebook;

    }
}

