/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONException;
import org.json.JSONObject;

public class PlaybackStreamService {
    private BrainCloudClient _client;

    public PlaybackStreamService(BrainCloudClient client) {
        this._client = client;
    }

    public void startStream(String targetPlayerId, boolean includeSharedData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.targetPlayerId.name(), (Object)targetPlayerId);
            data.put(Parameter.includeSharedData.name(), includeSharedData);
            ServerCall sc = new ServerCall(ServiceName.playbackStream, ServiceOperation.START_STREAM, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readStream(String playbackStreamId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.playbackStreamId.name(), (Object)playbackStreamId);
            ServerCall sc = new ServerCall(ServiceName.playbackStream, ServiceOperation.READ_STREAM, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void endStream(String playbackStreamId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.playbackStreamId.name(), (Object)playbackStreamId);
            ServerCall sc = new ServerCall(ServiceName.playbackStream, ServiceOperation.END_STREAM, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void deleteStream(String playbackStreamId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.playbackStreamId.name(), (Object)playbackStreamId);
            ServerCall sc = new ServerCall(ServiceName.playbackStream, ServiceOperation.DELETE_STREAM, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void addEvent(String playbackStreamId, String eventData, String summary, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.playbackStreamId.name(), (Object)playbackStreamId);
            data.put(Parameter.eventData.name(), (Object)new JSONObject(eventData));
            data.put(Parameter.summary.name(), (Object)new JSONObject(summary));
            ServerCall sc = new ServerCall(ServiceName.playbackStream, ServiceOperation.ADD_EVENT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getRecentStreamsForInitiatingPlayer(String initiatingPlayerId, int maxNumStreams, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.initiatingPlayerId.name(), (Object)initiatingPlayerId);
            data.put(Parameter.maxNumStreams.name(), maxNumStreams);
            ServerCall sc = new ServerCall(ServiceName.playbackStream, ServiceOperation.GET_RECENT_STREAMS_FOR_INITIATING_PLAYER, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getRecentStreamsForTargetPlayer(String targetPlayerId, int maxNumStreams, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.targetPlayerId.name(), (Object)targetPlayerId);
            data.put(Parameter.maxNumStreams.name(), maxNumStreams);
            ServerCall sc = new ServerCall(ServiceName.playbackStream, ServiceOperation.GET_RECENT_STREAMS_FOR_TARGET_PLAYER, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static enum Parameter {
        targetPlayerId,
        initiatingPlayerId,
        maxNumStreams,
        includeSharedData,
        playbackStreamId,
        eventData,
        summary;

    }
}

