/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IRTTCallback;
import com.bitheads.braincloud.client.IRTTConnectCallback;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.RTTComms;
import com.bitheads.braincloud.comms.ServerCall;

public class RTTService {
    private BrainCloudClient _client;

    public RTTService(BrainCloudClient client) {
        this._client = client;
    }

    public void enableRTT(IRTTConnectCallback callback, boolean useWebSocket) {
        this._client.getRTTComms().enableRTT(callback, useWebSocket);
    }

    public void enableRTT(IRTTConnectCallback callback) {
        this.enableRTT(callback, true);
    }

    public void disableRTT() {
        this._client.getRTTComms().disableRTT();
    }

    public boolean getRTTEnabled() {
        return this._client.getRTTComms().isRTTEnabled();
    }

    public RTTComms.RttConnectionStatus getConnectionStatus() {
        return this._client.getRTTComms().getConnectionStatus();
    }

    public String getRTTConnectionId() {
        return this._client.getRTTComms().getConnectionId();
    }

    public void registerRTTEventCallback(IRTTCallback callback) {
        this._client.getRTTComms().registerRTTCallback(ServiceName.event.toString(), callback);
    }

    public void deregisterRTTEventCallback() {
        this._client.getRTTComms().deregisterRTTCallback(ServiceName.event.toString());
    }

    public void registerRTTChatCallback(IRTTCallback callback) {
        this._client.getRTTComms().registerRTTCallback(ServiceName.chat.toString(), callback);
    }

    public void deregisterRTTChatCallback() {
        this._client.getRTTComms().deregisterRTTCallback(ServiceName.chat.toString());
    }

    public void registerRTTMessagingCallback(IRTTCallback callback) {
        this._client.getRTTComms().registerRTTCallback(ServiceName.messaging.toString(), callback);
    }

    public void deregisterRTTMessagingCallback() {
        this._client.getRTTComms().deregisterRTTCallback(ServiceName.messaging.toString());
    }

    public void registerRTTLobbyCallback(IRTTCallback callback) {
        this._client.getRTTComms().registerRTTCallback(ServiceName.lobby.toString(), callback);
    }

    public void deregisterRTTLobbyCallback() {
        this._client.getRTTComms().deregisterRTTCallback(ServiceName.lobby.toString());
    }

    public void registerRTTPresenceCallback(IRTTCallback callback) {
        this._client.getRTTComms().registerRTTCallback(ServiceName.presence.toString(), callback);
    }

    public void deregisterRTTPresenceCallback() {
        this._client.getRTTComms().deregisterRTTCallback(ServiceName.presence.toString());
    }

    public void registerRTTBlockchainRefreshCallback(IRTTCallback callback) {
        this._client.getRTTComms().registerRTTCallback(ServiceName.userItems.toString(), callback);
    }

    public void deregisterRTTBlockchainRefreshCallback() {
        this._client.getRTTComms().deregisterRTTCallback(ServiceName.userItems.toString());
    }

    public void deregisterAllCallbacks() {
        this._client.getRTTComms().deregisterAllCallbacks();
    }

    public void requestClientConnection(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.rttRegistration, ServiceOperation.REQUEST_CLIENT_CONNECTION, null, callback);
        this._client.sendRequest(sc);
    }
}

