/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.client;

import com.bitheads.braincloud.client.IEventCallback;
import com.bitheads.braincloud.client.IFileUploadCallback;
import com.bitheads.braincloud.client.IGlobalErrorCallback;
import com.bitheads.braincloud.client.INetworkErrorCallback;
import com.bitheads.braincloud.client.IRewardCallback;
import com.bitheads.braincloud.client.Platform;
import com.bitheads.braincloud.comms.BrainCloudRestClient;
import com.bitheads.braincloud.comms.RTTComms;
import com.bitheads.braincloud.comms.RelayComms;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.AppStoreService;
import com.bitheads.braincloud.services.AsyncMatchService;
import com.bitheads.braincloud.services.AuthenticationService;
import com.bitheads.braincloud.services.BlockchainService;
import com.bitheads.braincloud.services.ChatService;
import com.bitheads.braincloud.services.CustomEntityService;
import com.bitheads.braincloud.services.DataStreamService;
import com.bitheads.braincloud.services.EntityService;
import com.bitheads.braincloud.services.EventService;
import com.bitheads.braincloud.services.FileService;
import com.bitheads.braincloud.services.FriendService;
import com.bitheads.braincloud.services.GamificationService;
import com.bitheads.braincloud.services.GlobalAppService;
import com.bitheads.braincloud.services.GlobalEntityService;
import com.bitheads.braincloud.services.GlobalFileService;
import com.bitheads.braincloud.services.GlobalStatisticsService;
import com.bitheads.braincloud.services.GroupFileService;
import com.bitheads.braincloud.services.GroupService;
import com.bitheads.braincloud.services.IdentityService;
import com.bitheads.braincloud.services.ItemCatalogService;
import com.bitheads.braincloud.services.LobbyService;
import com.bitheads.braincloud.services.MailService;
import com.bitheads.braincloud.services.MatchMakingService;
import com.bitheads.braincloud.services.MessagingService;
import com.bitheads.braincloud.services.OneWayMatchService;
import com.bitheads.braincloud.services.PlaybackStreamService;
import com.bitheads.braincloud.services.PlayerStateService;
import com.bitheads.braincloud.services.PlayerStatisticsEventService;
import com.bitheads.braincloud.services.PlayerStatisticsService;
import com.bitheads.braincloud.services.PresenceService;
import com.bitheads.braincloud.services.ProfanityService;
import com.bitheads.braincloud.services.PushNotificationService;
import com.bitheads.braincloud.services.RTTService;
import com.bitheads.braincloud.services.RedemptionCodeService;
import com.bitheads.braincloud.services.RelayService;
import com.bitheads.braincloud.services.S3HandlingService;
import com.bitheads.braincloud.services.ScriptService;
import com.bitheads.braincloud.services.SocialLeaderboardService;
import com.bitheads.braincloud.services.TimeService;
import com.bitheads.braincloud.services.TournamentService;
import com.bitheads.braincloud.services.UserItemsService;
import com.bitheads.braincloud.services.VirtualCurrencyService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class BrainCloudClient {
    public static final boolean EnableSingletonMode = false;
    public static final String SingletonUseErrorMessage = "Singleton usage is disabled. If called by mistake, use your own variable that holds an instance of the bcWrapper/bcClient.";
    private String _appId;
    private Platform _releasePlatform;
    private String _appVersion;
    private Map<String, String> _secretMap = new HashMap<String, String>();
    private String _countryCode;
    private String _languageCode;
    private double _timeZoneOffset;
    private static final String BRAINCLOUD_VERSION = "4.15.0";
    private BrainCloudRestClient _restClient;
    private RTTComms _rttComms;
    private RelayComms _relayComms;
    private AppStoreService _appStoreService = new AppStoreService(this);
    private AuthenticationService _authenticationService = new AuthenticationService(this);
    private AsyncMatchService _asyncMatchService = new AsyncMatchService(this);
    private ChatService _chatService = new ChatService(this);
    private DataStreamService _dataStreamService = new DataStreamService(this);
    private EntityService _entityService = new EntityService(this);
    private EventService _eventService = new EventService(this);
    private FileService _fileService = new FileService(this);
    private FriendService _friendService = new FriendService(this);
    private GamificationService _gamificationService = new GamificationService(this);
    private GlobalAppService _globalAppService = new GlobalAppService(this);
    private GlobalEntityService _globalEntityService = new GlobalEntityService(this);
    private GlobalStatisticsService _globalStatisticsService = new GlobalStatisticsService(this);
    private GroupFileService _groupFileService = new GroupFileService(this);
    private GroupService _groupService = new GroupService(this);
    private IdentityService _identityService = new IdentityService(this);
    private LobbyService _lobbyService = new LobbyService(this);
    private MailService _mailService = new MailService(this);
    private MessagingService _messagingService = new MessagingService(this);
    private BlockchainService _blockchainService = new BlockchainService(this);
    private MatchMakingService _matchMakingService = new MatchMakingService(this);
    private OneWayMatchService _oneWayMatchService = new OneWayMatchService(this);
    private PlaybackStreamService _playbackStreamService = new PlaybackStreamService(this);
    private PlayerStateService _playerStateService = new PlayerStateService(this);
    private PlayerStatisticsService _playerStatisticsService = new PlayerStatisticsService(this);
    private PlayerStatisticsEventService _playerStatisticsEventService = new PlayerStatisticsEventService(this);
    private PresenceService _presenceService = new PresenceService(this);
    private ProfanityService _profanityService = new ProfanityService(this);
    private PushNotificationService _pushNotificationService = new PushNotificationService(this);
    private RedemptionCodeService _redemptionCodeService = new RedemptionCodeService(this);
    private RelayService _relayService = new RelayService(this);
    private RTTService _rttService = new RTTService(this);
    private S3HandlingService _s3HandlingService = new S3HandlingService(this);
    private ScriptService _scriptService = new ScriptService(this);
    private SocialLeaderboardService _socialLeaderboardService = new SocialLeaderboardService(this);
    private TimeService _timeService = new TimeService(this);
    private TournamentService _tournamentService = new TournamentService(this);
    private GlobalFileService _globalFileService = new GlobalFileService(this);
    private CustomEntityService _customEntityService = new CustomEntityService(this);
    private VirtualCurrencyService _virtualCurrencyService = new VirtualCurrencyService(this);
    private ItemCatalogService _itemCatalogService = new ItemCatalogService(this);
    private UserItemsService _userItemsService = new UserItemsService(this);
    private static String DEFAULT_SERVER_URL = "https://api.braincloudservers.com/dispatcherv2";

    public BrainCloudClient() {
        this._restClient = new BrainCloudRestClient(this);
        this._rttComms = new RTTComms(this);
        this._relayComms = new RelayComms(this);
    }

    public String getRttConnectionId() {
        return this._rttComms.getConnectionId();
    }

    public static BrainCloudClient getInstance() {
        throw new AssertionError((Object)SingletonUseErrorMessage);
    }

    public static void setInstance(BrainCloudClient client) {
    }

    public BrainCloudRestClient getRestClient() {
        return this._restClient;
    }

    public RTTComms getRTTComms() {
        return this._rttComms;
    }

    public RelayComms getRelayComms() {
        return this._relayComms;
    }

    public void initialize(String appId, String secretKey, String appVersion) {
        this.initialize(DEFAULT_SERVER_URL, appId, secretKey, appVersion);
    }

    public void initialize(String serverURL, String appId, String secretKey, String appVersion) {
        this.resetCommunication();
        String error = null;
        if (BrainCloudClient.isNullOrEmpty(serverURL)) {
            error = "serverUrl was null or empty";
        } else if (BrainCloudClient.isNullOrEmpty(secretKey)) {
            error = "secretKey was null or empty";
        } else if (BrainCloudClient.isNullOrEmpty(appId)) {
            error = "appId was null or empty";
        } else if (BrainCloudClient.isNullOrEmpty(appVersion)) {
            error = "appVersion was null or empty";
        }
        if (error != null) {
            System.out.println("ERROR | Failed to initialize brainCloud - " + error);
            return;
        }
        this._appId = appId;
        this._appVersion = appVersion;
        this._secretMap.put(this._appId, secretKey);
        if (this._releasePlatform == null) {
            this.setReleasePlatform(Platform.detectGenericPlatform(System.getProperty("os.name").toLowerCase()));
            System.out.println("Detected Platform: " + System.getProperty("os.name"));
            if (this._releasePlatform == null) {
                this.setReleasePlatform(Platform.GooglePlayAndroid);
            }
        }
        Locale locale = Locale.getDefault();
        if (this._countryCode == null || this._countryCode.isEmpty()) {
            this._countryCode = locale.getCountry();
        }
        if (this._languageCode == null || this._languageCode.isEmpty()) {
            this._languageCode = locale.getLanguage();
        }
        TimeZone timeZone = TimeZone.getDefault();
        this._timeZoneOffset = (double)timeZone.getRawOffset() / 3600000.0;
        this._restClient.initialize(serverURL.endsWith("/dispatcherv2") ? serverURL : serverURL + "/dispatcherv2", appId, secretKey);
    }

    public void initializeWithApps(String appId, Map<String, String> secretMap, String appVersion) {
        this.initializeWithApps(DEFAULT_SERVER_URL, appId, secretMap, appVersion);
    }

    public void initializeWithApps(String serverUrl, String appId, Map<String, String> secretMap, String appVersion) {
        this.resetCommunication();
        String error = null;
        if (BrainCloudClient.isNullOrEmpty(serverUrl)) {
            error = "serverUrl was null or empty";
        } else if (BrainCloudClient.isNullOrEmpty(appId)) {
            error = "appId was null or empty";
        } else if (BrainCloudClient.isNullOrEmpty(secretMap.get(appId))) {
            error = "no matching secret for appId";
        } else if (BrainCloudClient.isNullOrEmpty(appVersion)) {
            error = "appVersion was null or empty";
        }
        if (error != null) {
            System.out.println("ERROR | Failed to initialize brainCloud - " + error);
            return;
        }
        this._appId = appId;
        this._appVersion = appVersion;
        this._secretMap = secretMap;
        if (this._releasePlatform == null) {
            this.setReleasePlatform(Platform.detectGenericPlatform(System.getProperty("os.name").toLowerCase()));
            System.out.println("Detected Platform: " + System.getProperty("os.name"));
            if (this._releasePlatform == null) {
                this.setReleasePlatform(Platform.GooglePlayAndroid);
            }
        }
        Locale locale = Locale.getDefault();
        if (this._countryCode == null || this._countryCode.isEmpty()) {
            this._countryCode = locale.getCountry();
        }
        if (this._languageCode == null || this._languageCode.isEmpty()) {
            this._languageCode = locale.getLanguage();
        }
        TimeZone timeZone = TimeZone.getDefault();
        this._timeZoneOffset = (double)timeZone.getRawOffset() / 3600000.0;
        this._restClient.initializeWithApps(serverUrl.endsWith("/dispatcherv2") ? serverUrl : serverUrl + "/dispatcherv2", appId, secretMap);
    }

    private static boolean isNullOrEmpty(String param) {
        return param == null || param.trim().length() == 0;
    }

    public void initializeIdentity(String profileId, String anonymousId) {
        this.getAuthenticationService().setProfileId(profileId);
        this.getAuthenticationService().setAnonymousId(anonymousId);
    }

    public void resetCommunication() {
        this._relayComms.disconnect();
        this._rttComms.disableRTT();
        this._restClient.resetCommunication();
    }

    public void runCallbacks() {
        this.runCallbacks(BrainCloudUpdateType.ALL);
    }

    public void runCallbacks(BrainCloudUpdateType updateType) {
        switch (updateType) {
            case REST: {
                this._restClient.runCallbacks();
                break;
            }
            case RTT: {
                this._rttComms.runCallbacks();
                break;
            }
            case PING: {
                this._lobbyService.runPingCallbacks();
                break;
            }
            case RS: {
                this._relayComms.runCallbacks();
                break;
            }
            case ALL: {
                this._restClient.runCallbacks();
                this._lobbyService.runPingCallbacks();
                this._rttComms.runCallbacks();
                this._relayComms.runCallbacks();
            }
        }
    }

    public void enableCompression() {
        this._restClient.enableCompression();
    }

    public void disableCompression() {
        this._restClient.disableCompression();
    }

    public boolean isAuthenticated() {
        return this._restClient != null && this._restClient.isAuthenticated();
    }

    public boolean isInitialized() {
        return this._restClient != null && this._restClient.isInitialized();
    }

    public void enableLogging(boolean shouldEnable) {
        this._restClient.enableLogging(shouldEnable);
        this._rttComms.enableLogging(shouldEnable);
        this._relayComms.enableLogging(shouldEnable);
        this._lobbyService.enableLogging(shouldEnable);
    }

    public void restoreRecentSession(String sessionId) {
        if (sessionId.equals("")) {
            return;
        }
        this._restClient.setSessionId(sessionId);
        this._restClient.setAuthenticated();
    }

    public void registerEventCallback(IEventCallback callback) {
        this._restClient.registerEventCallback(callback);
    }

    public void deregisterEventCallback() {
        this._restClient.deregisterEventCallback();
    }

    public void registerRewardCallback(IRewardCallback in_rewardCallback) {
        this._restClient.registerRewardCallback(in_rewardCallback);
    }

    public void deregisterRewardCallback() {
        this._restClient.deregisterRewardCallback();
    }

    public void registerFileUploadCallback(IFileUploadCallback fileUploadCallback) {
        this._restClient.registerFileUploadCallback(fileUploadCallback);
    }

    public void deregisterFileUploadCallback() {
        this._restClient.deregisterFileUploadCallback();
    }

    public void registerGlobalErrorCallback(IGlobalErrorCallback in_globalErrorCallback) {
        this._restClient.registerGlobalErrorCallback(in_globalErrorCallback);
    }

    public void deregisterGlobalErrorCallback() {
        this._restClient.deregisterGlobalErrorCallback();
    }

    public void registerNetworkErrorCallback(INetworkErrorCallback in_networkErrorCallback) {
        this._restClient.registerNetworkErrorCallback(in_networkErrorCallback);
    }

    public void deregisterNetworkErrorCallback() {
        this._restClient.deregisterNetworkErrorCallback();
    }

    public ArrayList<Integer> getPacketTimeouts() {
        return this._restClient.getPacketTimeouts();
    }

    public void setPacketTimeouts(ArrayList<Integer> in_packetTimeouts) {
        this._restClient.setPacketTimeouts(in_packetTimeouts);
    }

    public void setPacketTimeoutsToDefault() {
        this._restClient.setPacketTimeoutsToDefault();
    }

    public int getAuthenticationPacketTimeout() {
        return this._restClient.getAuthenticationPacketTimeout();
    }

    public void setAuthenticationPacketTimeout(int in_timeoutSecs) {
        this._restClient.setAuthenticationPacketTimeout(in_timeoutSecs);
    }

    public void setOldStyleStatusMessageErrorCallback(boolean in_enabled) {
        this._restClient.setOldStyleStatusMessageErrorCallback(in_enabled);
    }

    public int getUploadLowTransferRateTimeout() {
        return this._restClient.getUploadLowTransferRateTimeout();
    }

    public void setUploadLowTransferRateTimeout(int timeoutSecs) {
        this._restClient.setUploadLowTransferRateTimeout(timeoutSecs);
    }

    public int getUploadLowTransferRateThreshold() {
        return this._restClient.getUploadLowTransferRateThreshold();
    }

    public void setUploadLowTransferRateThreshold(int bytesPerSec) {
        this._restClient.setUploadLowTransferRateThreshold(bytesPerSec);
    }

    public void enableNetworkErrorMessageCaching(boolean in_enabled) {
        this._restClient.enableNetworkErrorMessageCaching(in_enabled);
    }

    public void retryCachedMessages() {
        this._restClient.retryCachedMessages();
    }

    public void flushCachedMessages(boolean in_sendApiErrorCallbacks) {
        this._restClient.flushCachedMessages(in_sendApiErrorCallbacks);
    }

    public void insertEndOfMessageBundleMarker() {
        this._restClient.insertEndOfMessageBundleMarker();
    }

    public void sendRequest(ServerCall serverCall) {
        this._restClient.addToQueue(serverCall);
    }

    public void getSessionId() {
        this._restClient.getSessionId();
    }

    public String getAppId() {
        if (this._restClient == null) {
            return null;
        }
        return this._restClient.getAppId();
    }

    public Platform getReleasePlatform() {
        return this._releasePlatform;
    }

    public void setReleasePlatform(Platform _releasePlatform) {
        this._releasePlatform = _releasePlatform;
    }

    public String getAppVersion() {
        return this._appVersion;
    }

    public void setAppVersion(String appVersion) {
        this._appVersion = appVersion;
    }

    public String getBrainCloudVersion() {
        return BRAINCLOUD_VERSION;
    }

    public String getCountryCode() {
        return this._countryCode;
    }

    public void overrideCountryCode(String countryCode) {
        this._countryCode = countryCode;
    }

    public String getLanguageCode() {
        return this._languageCode;
    }

    public long getHeartbeatInterval() {
        return this._restClient.getHeartbeatInterval();
    }

    public void setHeartbeatInterval(long intervalMillis) {
        this._restClient.setHeartbeatInterval(intervalMillis);
    }

    public void overrideLanguageCode(String languageCode) {
        this._languageCode = languageCode;
    }

    public double getTimeZoneOffset() {
        return this._timeZoneOffset;
    }

    public AppStoreService getAppStoreService() {
        return this._appStoreService;
    }

    public AuthenticationService getAuthenticationService() {
        return this._authenticationService;
    }

    public AsyncMatchService getAsyncMatchService() {
        return this._asyncMatchService;
    }

    public ChatService getChatService() {
        return this._chatService;
    }

    public LobbyService getLobbyService() {
        return this._lobbyService;
    }

    public DataStreamService getDataStreamService() {
        return this._dataStreamService;
    }

    public EntityService getEntityService() {
        return this._entityService;
    }

    public EventService getEventService() {
        return this._eventService;
    }

    public FileService getFileService() {
        return this._fileService;
    }

    public FriendService getFriendService() {
        return this._friendService;
    }

    public GamificationService getGamificationService() {
        return this._gamificationService;
    }

    public GlobalAppService getGlobalAppService() {
        return this._globalAppService;
    }

    public GlobalEntityService getGlobalEntityService() {
        return this._globalEntityService;
    }

    public GlobalStatisticsService getGlobalStatisticsService() {
        return this._globalStatisticsService;
    }

    public GroupFileService getGroupFileService() {
        return this._groupFileService;
    }

    public GroupService getGroupService() {
        return this._groupService;
    }

    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public MailService getMailService() {
        return this._mailService;
    }

    public MessagingService getMessagingService() {
        return this._messagingService;
    }

    public BlockchainService getBlockchainService() {
        return this._blockchainService;
    }

    public MatchMakingService getMatchMakingService() {
        return this._matchMakingService;
    }

    public OneWayMatchService getOneWayMatchService() {
        return this._oneWayMatchService;
    }

    public PlaybackStreamService getPlaybackStreamService() {
        return this._playbackStreamService;
    }

    public PlayerStateService getPlayerStateService() {
        return this._playerStateService;
    }

    public PlayerStatisticsService getPlayerStatisticsService() {
        return this._playerStatisticsService;
    }

    public PlayerStatisticsEventService getPlayerStatisticsEventService() {
        return this._playerStatisticsEventService;
    }

    public PresenceService getPresenceService() {
        return this._presenceService;
    }

    public VirtualCurrencyService getVirtualCurrencyService() {
        return this._virtualCurrencyService;
    }

    public ProfanityService getProfanityService() {
        return this._profanityService;
    }

    public PushNotificationService getPushNotificationService() {
        return this._pushNotificationService;
    }

    public RedemptionCodeService getRedemptionCodeService() {
        return this._redemptionCodeService;
    }

    public RelayService getRelayService() {
        return this._relayService;
    }

    public RTTService getRTTService() {
        return this._rttService;
    }

    public S3HandlingService getS3HandlingService() {
        return this._s3HandlingService;
    }

    public ScriptService getScriptService() {
        return this._scriptService;
    }

    public SocialLeaderboardService getSocialLeaderboardService() {
        return this._socialLeaderboardService;
    }

    public SocialLeaderboardService getLeaderboardService() {
        return this._socialLeaderboardService;
    }

    public TimeService getTimeService() {
        return this._timeService;
    }

    public TournamentService getTournamentService() {
        return this._tournamentService;
    }

    public GlobalFileService getGlobalFileService() {
        return this._globalFileService;
    }

    public CustomEntityService getCustomEntityService() {
        return this._customEntityService;
    }

    public ItemCatalogService getItemCatalogService() {
        return this._itemCatalogService;
    }

    public UserItemsService getUserItemsService() {
        return this._userItemsService;
    }

    public static enum BrainCloudUpdateType {
        ALL,
        REST,
        RTT,
        RS,
        PING;

    }
}

