/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.comms;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IRTTCallback;
import com.bitheads.braincloud.client.IRTTConnectCallback;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.BrainCloudRestClient;
import com.bitheads.braincloud.services.AuthenticationService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RTTComms
implements IServerCallback {
    private BrainCloudClient _client;
    private boolean _loggingEnabled = false;
    private IRTTConnectCallback _connectCallback = null;
    private HashMap<String, IRTTCallback> _callbacks = new HashMap();
    private String _appId;
    private String _sessionId;
    private String _profileId;
    private String _connectionId;
    private WebsocketStatus _webSocketStatus = WebsocketStatus.None;
    private RttConnectionStatus _rttConnectionStatus = RttConnectionStatus.Disconnected;
    private JSONObject _auth;
    private JSONObject _endpoint;
    private JSONObject _disconnectMessage;
    private Socket _socket = null;
    private boolean _useWebSocket = false;
    private WSClient _webSocketClient;
    private int _heartbeatSeconds = 30;
    private long _lastHeartbeatTime = 0L;
    private ArrayList<RTTCallback> _callbackEventQueue = new ArrayList();
    private boolean _disconnectedWithReason = false;

    public RTTComms(BrainCloudClient client) {
        this._client = client;
    }

    public void enableRTT(IRTTConnectCallback callback, boolean useWebSocket) {
        this._disconnectedWithReason = false;
        switch (this._rttConnectionStatus) {
            case Connected: {
                System.out.println("enableRTT: Already connected");
                break;
            }
            case Disconnected: {
                this._rttConnectionStatus = RttConnectionStatus.RequestingConnectionInfo;
                this._connectCallback = callback;
                this._useWebSocket = useWebSocket;
                BrainCloudRestClient restClient = this._client.getRestClient();
                this._appId = restClient.getAppId();
                this._sessionId = restClient.getSessionId();
                AuthenticationService authenticationService = this._client.getAuthenticationService();
                this._profileId = authenticationService.getProfileId();
                this._client.getRTTService().requestClientConnection(this);
                break;
            }
            case RequestingConnectionInfo: 
            case Connecting: {
                System.out.println("enableRTT: Already in the process of connecting");
                break;
            }
            case Disconnecting: {
                System.out.println("enableRTT: Is currently disconnecting");
            }
        }
    }

    public void disableRTT() {
        switch (this._rttConnectionStatus) {
            case RequestingConnectionInfo: 
            case Connecting: 
            case Connected: {
                if (this._webSocketClient != null) {
                    this._rttConnectionStatus = RttConnectionStatus.Disconnecting;
                    this._webSocketClient.close();
                    this._webSocketClient = null;
                }
                this._rttConnectionStatus = RttConnectionStatus.Disconnected;
                break;
            }
        }
    }

    public boolean isRTTEnabled() {
        return this._rttConnectionStatus == RttConnectionStatus.Connected;
    }

    public RttConnectionStatus getConnectionStatus() {
        return this._rttConnectionStatus;
    }

    public boolean getLoggingEnabled() {
        return this._loggingEnabled;
    }

    public String getConnectionId() {
        return this._connectionId;
    }

    public void enableLogging(boolean isEnabled) {
        this._loggingEnabled = isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runCallbacks() {
        ArrayList<RTTCallback> arrayList = this._callbackEventQueue;
        synchronized (arrayList) {
            block11: while (!this._callbackEventQueue.isEmpty()) {
                RTTCallback rttCallback = this._callbackEventQueue.remove(0);
                switch (rttCallback._type) {
                    case ConnectSuccess: {
                        this._connectCallback.rttConnectSuccess();
                        break;
                    }
                    case ConnectFailure: {
                        this._connectCallback.rttConnectFailure(rttCallback._message);
                        break;
                    }
                    case Event: {
                        try {
                            String serviceName = rttCallback._json.getString("service");
                            if (!this._callbacks.containsKey(serviceName)) continue block11;
                            this._callbacks.get(serviceName).rttCallback(rttCallback._json);
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue block11;
                        }
                    }
                }
            }
        }
        if (!this.isRTTEnabled()) return;
        if (System.currentTimeMillis() - this._lastHeartbeatTime < (long)(this._heartbeatSeconds * 1000)) return;
        this._lastHeartbeatTime = System.currentTimeMillis();
        try {
            JSONObject json = new JSONObject();
            json.put("operation", (Object)"HEARTBEAT");
            json.put("service", (Object)"rtt");
            if (this._useWebSocket) {
                this.sendWS(json);
                return;
            }
            this.send(json);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failedToConnect() {
        ArrayList<RTTCallback> arrayList = this._callbackEventQueue;
        synchronized (arrayList) {
            String host = "";
            int port = 0;
            try {
                if (this._endpoint != null) {
                    host = this._endpoint.getString("host");
                    port = this._endpoint.getInt("port");
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this._callbackEventQueue.add(new RTTCallback(RTTCallbackType.ConnectFailure, "Failed to connect to RTT Event server: " + host + ":" + Integer.toString(port)));
        }
    }

    private JSONObject buildConnectionRequest(String protocol) throws Exception {
        JSONObject json = new JSONObject();
        json.put("operation", (Object)"CONNECT");
        json.put("service", (Object)"rtt");
        JSONObject system = new JSONObject();
        system.put("protocol", (Object)protocol);
        system.put("platform", (Object)"JAVA");
        JSONObject jsonData = new JSONObject();
        jsonData.put("appId", (Object)this._appId);
        jsonData.put("profileId", (Object)this._profileId);
        jsonData.put("sessionId", (Object)this._sessionId);
        jsonData.put("auth", (Object)this._auth);
        jsonData.put("system", (Object)system);
        json.put("data", (Object)jsonData);
        return json;
    }

    private void onSocketConnected(DataInputStream in) throws Exception {
        this.startReceiving(in);
        if (!this.send(this.buildConnectionRequest("tcp"))) {
            this.failedToConnect();
        }
    }

    private void onWSConnected() throws Exception {
        this.sendWS(this.buildConnectionRequest("ws"));
    }

    private void connectTCP() {
        Thread connectionThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (RTTComms.this._loggingEnabled) {
                        System.out.println("RTT TCP: Connecting...");
                    }
                    InetAddress serverIP = InetAddress.getByName(RTTComms.this._endpoint.getString("host"));
                    int port = RTTComms.this._endpoint.getInt("port");
                    RTTComms.this._socket = new Socket(serverIP, port);
                    RTTComms.this._lastHeartbeatTime = System.currentTimeMillis();
                    if (RTTComms.this._loggingEnabled) {
                        System.out.println("RTT TCP: connected");
                    }
                    RTTComms.this.onSocketConnected(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RTTComms.this.failedToConnect();
                    return;
                }
            }
        });
        connectionThread.start();
    }

    private void connectWebSocket() throws JSONException {
        boolean sslEnabled = this._endpoint.getBoolean("ssl");
        String scheme = sslEnabled ? "wss://" : "ws://";
        StringBuilder uri = new StringBuilder(scheme).append(this._endpoint.getString("host")).append(':').append(this._endpoint.getInt("port"));
        if (this._auth != null) {
            int separator = 63;
            Iterator it = this._auth.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                uri.append((char)separator).append(key).append('=').append(this._auth.getString(key));
                if (separator != 63) continue;
                separator = 38;
            }
        }
        if (this._loggingEnabled) {
            System.out.println("RTT WS: Connecting " + uri);
        }
        try {
            this._webSocketClient = new WSClient(uri.toString());
            if (sslEnabled) {
                this.setupSSL();
            }
            this._webSocketClient.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.failedToConnect();
            return;
        }
    }

    private void setupSSL() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        SSLSocketFactory factory = sc.getSocketFactory();
        this._webSocketClient.setSocket(factory.createSocket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        this._rttConnectionStatus = RttConnectionStatus.Disconnecting;
        try {
            if (this._socket != null) {
                Socket socket = this._socket;
                synchronized (socket) {
                    if (this._socket != null) {
                        this._socket.close();
                        this._socket = null;
                    }
                }
            }
            if (this._webSocketClient != null) {
                this._webSocketClient = null;
            }
            this._rttConnectionStatus = RttConnectionStatus.Disconnected;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._loggingEnabled && this._disconnectedWithReason) {
            System.out.println("RTT Disconnect:" + this._disconnectMessage.toString());
        }
    }

    private boolean send(JSONObject jsonData) {
        try {
            String message = jsonData.toString();
            if (this._loggingEnabled) {
                System.out.println("RTT SEND: " + message);
            }
            DataOutputStream out = new DataOutputStream(this._socket.getOutputStream());
            out.writeInt(message.length());
            out.writeBytes(message);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean sendWS(JSONObject jsonData) {
        try {
            String message = jsonData.toString();
            if (this._loggingEnabled) {
                System.out.println("RTT SEND: " + message);
            }
            this._webSocketClient.send(message);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRecv(String message) throws Exception {
        if (this._loggingEnabled) {
            System.out.println("RTT RECV: " + message);
        }
        try {
            String service;
            JSONObject jsonData = new JSONObject(message);
            switch (service = jsonData.getString("service")) {
                case "evs": 
                case "rtt": {
                    this.processRttMessage(jsonData);
                    break;
                }
                default: {
                    ArrayList<RTTCallback> arrayList = this._callbackEventQueue;
                    synchronized (arrayList) {
                        this._callbackEventQueue.add(new RTTCallback(RTTCallbackType.Event, jsonData));
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            ArrayList<RTTCallback> arrayList = this._callbackEventQueue;
            synchronized (arrayList) {
                this.disconnect();
                this._callbackEventQueue.add(new RTTCallback(RTTCallbackType.ConnectFailure, "Bad message: " + message));
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRttMessage(JSONObject json) throws JSONException {
        String operation;
        switch (operation = json.getString("operation")) {
            case "CONNECT": {
                this._rttConnectionStatus = RttConnectionStatus.Connected;
                this._heartbeatSeconds = json.getJSONObject("data").getInt("heartbeatSeconds");
                this._lastHeartbeatTime = System.currentTimeMillis();
                this._connectionId = json.getJSONObject("data").getString("cxId");
                if (json.getString("service").equals("rtt")) {
                    ArrayList<RTTCallback> arrayList = this._callbackEventQueue;
                    synchronized (arrayList) {
                        this._callbackEventQueue.add(new RTTCallback(RTTCallbackType.ConnectSuccess));
                        break;
                    }
                }
                ArrayList<RTTCallback> arrayList = this._callbackEventQueue;
                synchronized (arrayList) {
                    this.disconnect();
                    this._callbackEventQueue.add(new RTTCallback(RTTCallbackType.ConnectFailure));
                    break;
                }
            }
            case "DISCONNECT": {
                this._disconnectedWithReason = true;
                this._disconnectMessage.put("severity", (Object)"ERROR");
                this._disconnectMessage.put("reason", (Object)json.getJSONObject("data").getString("reason"));
                this._disconnectMessage.put("reasonCode", (Object)json.getJSONObject("data").getString("reasonCode"));
            }
        }
    }

    private void startReceiving(DataInputStream in_in) {
        final DataInputStream capture_in_in = in_in;
        Thread receiveThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DataInputStream in;
                try {
                    in = capture_in_in != null ? capture_in_in : new DataInputStream(RTTComms.this._socket.getInputStream());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RTTComms.this._rttConnectionStatus = RttConnectionStatus.Disconnected;
                    return;
                }
                while (RTTComms.this.isRTTEnabled()) {
                    try {
                        int len = in.readInt();
                        byte[] bytes = new byte[len];
                        in.readFully(bytes);
                        String message = new String(bytes);
                        RTTComms.this.onRecv(message);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
                RTTComms.this.disconnect();
            }
        });
        receiveThread.start();
    }

    @Override
    public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
        switch (serviceName) {
            case rttRegistration: {
                this.processRTTMessage(serviceOperation, jsonData);
                break;
            }
        }
    }

    private void processRTTMessage(ServiceOperation serviceOperation, JSONObject jsonData) {
        block1 : switch (this._rttConnectionStatus) {
            case RequestingConnectionInfo: {
                switch (serviceOperation) {
                    case REQUEST_CLIENT_CONNECTION: {
                        try {
                            JSONObject data = jsonData.getJSONObject("data");
                            this._endpoint = this.getEndpointToUse(data.getJSONArray("endpoints"));
                            if (this._endpoint == null) {
                                this.disconnect();
                                this._connectCallback.rttConnectFailure("No endpoint available");
                                return;
                            }
                            this._auth = data.getJSONObject("auth");
                            this._rttConnectionStatus = RttConnectionStatus.Connecting;
                            if (this._useWebSocket) {
                                this.connectWebSocket();
                                break block1;
                            }
                            this.connectTCP();
                            break block1;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.disconnect();
                            this._connectCallback.rttConnectFailure("Failed to establish connection");
                            return;
                        }
                    }
                }
                break;
            }
        }
    }

    private JSONObject getEndpointToUse(JSONArray endpoints) throws JSONException {
        if (this._useWebSocket) {
            JSONObject endpoint = this.getEndpointForType(endpoints, "ws", true);
            if (endpoint != null) {
                return endpoint;
            }
            return this.getEndpointForType(endpoints, "ws", false);
        }
        JSONObject endpoint = this.getEndpointForType(endpoints, "tcp", false);
        if (endpoint != null) {
            return endpoint;
        }
        return this.getEndpointForType(endpoints, "tcp", true);
    }

    private JSONObject getEndpointForType(JSONArray endpoints, String type, boolean wantSsl) throws JSONException {
        for (int i = 0; i < endpoints.length(); ++i) {
            JSONObject endpoint = endpoints.getJSONObject(i);
            String protocol = endpoint.getString("protocol");
            if (!protocol.equals(type)) continue;
            if (wantSsl) {
                if (!endpoint.getBoolean("ssl")) continue;
                return endpoint;
            }
            return endpoint;
        }
        return null;
    }

    @Override
    public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
        this._connectCallback.rttConnectFailure(jsonError);
    }

    public void registerRTTCallback(String serviceName, IRTTCallback callback) {
        this._callbacks.put(serviceName, callback);
    }

    public void deregisterRTTCallback(String serviceName) {
        this._callbacks.remove(serviceName);
    }

    public void deregisterAllCallbacks() {
        this._callbacks.clear();
    }

    public static enum RttConnectionStatus {
        Connected,
        Disconnected,
        RequestingConnectionInfo,
        Connecting,
        Disconnecting;

    }

    public static enum WebsocketStatus {
        Open,
        Closed,
        Message,
        Error,
        None;

    }

    private class WSClient
    extends WebSocketClient {
        public WSClient(String ip) throws Exception {
            super(new URI(ip));
        }

        public void onMessage(String message) {
            try {
                RTTComms.this.onRecv(message);
                RTTComms.this._webSocketStatus = WebsocketStatus.Message;
            }
            catch (Exception e) {
                e.printStackTrace();
                RTTComms.this.disconnect();
                return;
            }
        }

        public void onMessage(ByteBuffer bytes) {
            String message = new String(bytes.array());
            try {
                RTTComms.this.onRecv(message);
                RTTComms.this._webSocketStatus = WebsocketStatus.Message;
            }
            catch (Exception e) {
                e.printStackTrace();
                RTTComms.this.disconnect();
                return;
            }
        }

        public void onOpen(ServerHandshake handshake) {
            if (RTTComms.this._loggingEnabled) {
                System.out.println("RTT WS Connected");
            }
            try {
                RTTComms.this.onWSConnected();
                RTTComms.this._webSocketStatus = WebsocketStatus.Open;
            }
            catch (Exception e) {
                e.printStackTrace();
                RTTComms.this.failedToConnect();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(int code, String reason, boolean remote) {
            if (RTTComms.this._loggingEnabled) {
                System.out.println("RTT WS onClose: " + reason + ", code: " + Integer.toString(code) + ", remote: " + Boolean.toString(remote));
            }
            switch (RTTComms.this._rttConnectionStatus) {
                case RequestingConnectionInfo: 
                case Connecting: 
                case Connected: {
                    ArrayList arrayList = RTTComms.this._callbackEventQueue;
                    synchronized (arrayList) {
                        RTTComms.this.disconnect();
                        RTTComms.this._webSocketStatus = WebsocketStatus.Closed;
                        RTTComms.this._callbackEventQueue.add(new RTTCallback(RTTCallbackType.ConnectFailure, "webSocket onClose: " + reason));
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Exception e) {
            e.printStackTrace();
            ArrayList arrayList = RTTComms.this._callbackEventQueue;
            synchronized (arrayList) {
                RTTComms.this.disconnect();
                RTTComms.this._webSocketStatus = WebsocketStatus.Error;
                RTTComms.this._callbackEventQueue.add(new RTTCallback(RTTCallbackType.ConnectFailure, "webSocket onError"));
            }
        }
    }

    private class RTTCallback {
        public RTTCallbackType _type;
        public String _message;
        public JSONObject _json;

        RTTCallback(RTTCallbackType type) {
            this._type = type;
        }

        RTTCallback(RTTCallbackType type, String message) {
            this._type = type;
            this._message = message;
        }

        RTTCallback(RTTCallbackType type, JSONObject json) {
            this._type = type;
            this._json = json;
        }
    }

    static enum RTTCallbackType {
        ConnectSuccess,
        ConnectFailure,
        Event;

    }
}

