/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class DataStreamService {
    private BrainCloudClient _client;

    public DataStreamService(BrainCloudClient client) {
        this._client = client;
    }

    public void customPageEvent(String eventName, String jsonEventProperties, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.eventName.name(), (Object)eventName);
            if (StringUtil.IsOptionalParameterValid(jsonEventProperties)) {
                JSONObject jsonEventPropertiesObj = new JSONObject(jsonEventProperties);
                data.put(Parameter.eventProperties.name(), (Object)jsonEventPropertiesObj);
            }
            ServerCall serverCall = new ServerCall(ServiceName.dataStream, ServiceOperation.CUSTOM_PAGE_EVENT, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void customScreenEvent(String eventName, String jsonEventProperties, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.eventName.name(), (Object)eventName);
            if (StringUtil.IsOptionalParameterValid(jsonEventProperties)) {
                JSONObject jsonEventPropertiesObj = new JSONObject(jsonEventProperties);
                data.put(Parameter.eventProperties.name(), (Object)jsonEventPropertiesObj);
            }
            ServerCall serverCall = new ServerCall(ServiceName.dataStream, ServiceOperation.CUSTOM_SCREEN_EVENT, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void customTrackEvent(String eventName, String jsonEventProperties, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.eventName.name(), (Object)eventName);
            if (StringUtil.IsOptionalParameterValid(jsonEventProperties)) {
                JSONObject jsonEventPropertiesObj = new JSONObject(jsonEventProperties);
                data.put(Parameter.eventProperties.name(), (Object)jsonEventPropertiesObj);
            }
            ServerCall serverCall = new ServerCall(ServiceName.dataStream, ServiceOperation.CUSTOM_TRACK_EVENT, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void submitCrashReport(String crashType, String errorMsg, String crashJson, String crashLog, String userName, String userEmail, String userNotes, Boolean userSubmitted, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.crashType.name(), (Object)crashType);
            data.put(Parameter.errorMsg.name(), (Object)errorMsg);
            JSONObject crashJsonData = new JSONObject(crashJson);
            data.put(Parameter.crashJson.name(), (Object)crashJsonData);
            data.put(Parameter.crashLog.name(), (Object)crashLog);
            data.put(Parameter.userName.name(), (Object)userName);
            data.put(Parameter.userEmail.name(), (Object)userEmail);
            data.put(Parameter.userNotes.name(), (Object)userNotes);
            data.put(Parameter.userSubmitted.name(), (Object)userSubmitted);
            ServerCall serverCall = new ServerCall(ServiceName.dataStream, ServiceOperation.SEND_CRASH_REPORT, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static enum Parameter {
        eventName,
        eventProperties,
        crashType,
        errorMsg,
        crashJson,
        crashLog,
        userName,
        userEmail,
        userNotes,
        userSubmitted;

    }
}

