/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalEntityService {
    private BrainCloudClient _client;

    public GlobalEntityService(BrainCloudClient client) {
        this._client = client;
    }

    public void createEntity(String entityType, long timeToLive, String jsonEntityAcl, String jsonEntityData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.timeToLive.name(), timeToLive);
            JSONObject jsonData = new JSONObject(jsonEntityData);
            data.put(Parameter.data.name(), (Object)jsonData);
            if (StringUtil.IsOptionalParameterValid(jsonEntityAcl)) {
                JSONObject jsonAcl = new JSONObject(jsonEntityAcl);
                data.put(Parameter.acl.name(), (Object)jsonAcl);
            }
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.CREATE, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void createEntityWithIndexedId(String entityType, String indexedId, long timeToLive, String jsonEntityAcl, String jsonEntityData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.entityIndexedId.name(), (Object)indexedId);
            data.put(Parameter.timeToLive.name(), timeToLive);
            JSONObject jsonData = new JSONObject(jsonEntityData);
            data.put(Parameter.data.name(), (Object)jsonData);
            if (StringUtil.IsOptionalParameterValid(jsonEntityAcl)) {
                JSONObject jsonAcl = new JSONObject(jsonEntityAcl);
                data.put(Parameter.acl.name(), (Object)jsonAcl);
            }
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.CREATE_WITH_INDEXED_ID, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void updateEntity(String entityId, int version, String jsonEntityData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            JSONObject jsonData = new JSONObject(jsonEntityData);
            data.put(Parameter.data.name(), (Object)jsonData);
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.UPDATE, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void updateEntityAcl(String entityId, int version, String jsonEntityAcl, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            if (StringUtil.IsOptionalParameterValid(jsonEntityAcl)) {
                JSONObject jsonAcl = new JSONObject(jsonEntityAcl);
                data.put(Parameter.acl.name(), (Object)jsonAcl);
            }
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.UPDATE_ACL, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void updateEntityTimeToLive(String entityId, int version, long timeToLive, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.timeToLive.name(), timeToLive);
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.UPDATE_TIME_TO_LIVE, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void deleteEntity(String entityId, int version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.DELETE, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readEntity(String entityId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.READ, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getList(String where, String orderBy, int maxReturn, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (StringUtil.IsOptionalParameterValid(where)) {
                JSONObject whereObj = new JSONObject(where);
                data.put(Parameter.where.name(), (Object)whereObj);
            }
            if (StringUtil.IsOptionalParameterValid(orderBy)) {
                JSONObject orderByObj = new JSONObject(orderBy);
                data.put(Parameter.orderBy.name(), (Object)orderByObj);
            }
            data.put(Parameter.maxReturn.name(), maxReturn);
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.GET_LIST, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getListByIndexedId(String entityIndexedId, int maxReturn, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityIndexedId.name(), (Object)entityIndexedId);
            data.put(Parameter.maxReturn.name(), maxReturn);
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.GET_LIST_BY_INDEXED_ID, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getListCount(String where, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (StringUtil.IsOptionalParameterValid(where)) {
                JSONObject whereObj = new JSONObject(where);
                data.put(Parameter.where.name(), (Object)whereObj);
            }
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.GET_LIST_COUNT, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getPage(String jsonContext, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONObject context = new JSONObject(jsonContext);
            data.put(Parameter.context.name(), (Object)context);
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.GET_PAGE, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getPageOffset(String context, int pageOffset, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.context.name(), (Object)context);
            data.put(Parameter.pageOffset.name(), pageOffset);
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.GET_PAGE_BY_OFFSET, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void incrementGlobalEntityData(String entityId, String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            ServerCall sc = new ServerCall(ServiceName.globalEntity, ServiceOperation.INCREMENT_GLOBAL_ENTITY_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getRandomEntitiesMatching(String where, int maxReturn, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (StringUtil.IsOptionalParameterValid(where)) {
                JSONObject whereObj = new JSONObject(where);
                data.put(Parameter.where.name(), (Object)whereObj);
            }
            data.put(Parameter.maxReturn.name(), maxReturn);
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.GET_RANDOM_ENTITIES_MATCHING, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void updateEntityIndexedId(String entityId, int version, String entityIndexedId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.entityIndexedId.name(), (Object)entityIndexedId);
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.UPDATE_INDEXED_ID, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void updateEntityOwnerAndAcl(String entityId, int version, String ownerId, String jsonEntityAcl, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.ownerId.name(), (Object)ownerId);
            if (StringUtil.IsOptionalParameterValid(jsonEntityAcl)) {
                JSONObject jsonAcl = new JSONObject(jsonEntityAcl);
                data.put(Parameter.acl.name(), (Object)jsonAcl);
            }
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.UPDATE_ENTITY_OWNER_AND_ACL, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void makeSystemEntity(String entityId, int version, String jsonEntityAcl, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            if (StringUtil.IsOptionalParameterValid(jsonEntityAcl)) {
                JSONObject jsonAcl = new JSONObject(jsonEntityAcl);
                data.put(Parameter.acl.name(), (Object)jsonAcl);
            }
            ServerCall serverCall = new ServerCall(ServiceName.globalEntity, ServiceOperation.MAKE_SYSTEM_ENTITY, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static enum Parameter {
        entityId,
        entityType,
        entityIndexedId,
        data,
        acl,
        version,
        maxReturn,
        where,
        orderBy,
        timeToLive,
        context,
        pageOffset,
        ownerId;

    }
}

