/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LobbyService
implements IServerCallback {
    private BrainCloudClient _client;
    private boolean _loggingEnabled = false;
    private JSONObject _pingData = null;
    private JSONObject _pingRegions = null;
    private Thread _pingRegionsThread = null;
    private IServerCallback _pingCallback = null;
    private AtomicBoolean _isPingRunning = new AtomicBoolean(false);
    private Object _pingSync = new Object();
    private IServerCallback _getRegionsForLobbiesCallback = null;
    private ArrayList<ErrorCallbackEvent> _errorCallbackQueue = new ArrayList();
    private final int MAX_PING_CALLS = 4;
    private final int NUM_PING_CALLS_IN_PARALLEL = 2;

    public LobbyService(BrainCloudClient client) {
        this._client = client;
    }

    public void enableLogging(boolean isEnabled) {
        this._loggingEnabled = isEnabled;
    }

    public void createLobby(String lobbyType, int rating, ArrayList<String> otherUserCxIds, Boolean isReady, String extraJson, String teamCode, String settings, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyType.name(), (Object)lobbyType);
            data.put(Parameter.rating.name(), rating);
            if (otherUserCxIds != null) {
                data.put(Parameter.otherUserCxIds.name(), (Object)new JSONArray(otherUserCxIds));
            }
            data.put(Parameter.isReady.name(), (Object)isReady);
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                data.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            data.put(Parameter.teamCode.name(), (Object)teamCode);
            if (StringUtil.IsOptionalParameterValid(settings)) {
                data.put(Parameter.settings.name(), (Object)new JSONObject(settings));
            }
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.CREATE_LOBBY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void createLobbyWithPingData(String lobbyType, int rating, ArrayList<String> otherUserCxIds, Boolean isReady, String extraJson, String teamCode, String settings, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyType.name(), (Object)lobbyType);
            data.put(Parameter.rating.name(), rating);
            if (otherUserCxIds != null) {
                data.put(Parameter.otherUserCxIds.name(), (Object)new JSONArray(otherUserCxIds));
            }
            data.put(Parameter.isReady.name(), (Object)isReady);
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                data.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            data.put(Parameter.teamCode.name(), (Object)teamCode);
            if (StringUtil.IsOptionalParameterValid(settings)) {
                data.put(Parameter.settings.name(), (Object)new JSONObject(settings));
            }
            this.attachPingDataAndSend(data, ServiceOperation.CREATE_LOBBY_WITH_PING_DATA, callback);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void findLobby(String lobbyType, int rating, int maxSteps, String algo, String filterJson, ArrayList<String> otherUserCxIds, Boolean isReady, String extraJson, String teamCode, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyType.name(), (Object)lobbyType);
            data.put(Parameter.rating.name(), rating);
            data.put(Parameter.maxSteps.name(), maxSteps);
            if (StringUtil.IsOptionalParameterValid(algo)) {
                data.put(Parameter.algo.name(), (Object)new JSONObject(algo));
            }
            if (StringUtil.IsOptionalParameterValid(filterJson)) {
                data.put(Parameter.filterJson.name(), (Object)new JSONObject(filterJson));
            }
            if (otherUserCxIds != null) {
                data.put(Parameter.otherUserCxIds.name(), (Object)new JSONArray(otherUserCxIds));
            }
            data.put(Parameter.isReady.name(), (Object)isReady);
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                data.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            data.put(Parameter.teamCode.name(), (Object)teamCode);
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.FIND_LOBBY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void findLobbyWithPingData(String lobbyType, int rating, int maxSteps, String algo, String filterJson, ArrayList<String> otherUserCxIds, Boolean isReady, String extraJson, String teamCode, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyType.name(), (Object)lobbyType);
            data.put(Parameter.rating.name(), rating);
            data.put(Parameter.maxSteps.name(), maxSteps);
            if (StringUtil.IsOptionalParameterValid(algo)) {
                data.put(Parameter.algo.name(), (Object)new JSONObject(algo));
            }
            if (StringUtil.IsOptionalParameterValid(filterJson)) {
                data.put(Parameter.filterJson.name(), (Object)new JSONObject(filterJson));
            }
            if (otherUserCxIds != null) {
                data.put(Parameter.otherUserCxIds.name(), (Object)new JSONArray(otherUserCxIds));
            }
            data.put(Parameter.isReady.name(), (Object)isReady);
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                data.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            data.put(Parameter.teamCode.name(), (Object)teamCode);
            this.attachPingDataAndSend(data, ServiceOperation.FIND_LOBBY_WITH_PING_DATA, callback);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void findOrCreateLobby(String lobbyType, int rating, int maxSteps, String algo, String filterJson, ArrayList<String> otherUserCxIds, String settings, Boolean isReady, String extraJson, String teamCode, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyType.name(), (Object)lobbyType);
            data.put(Parameter.rating.name(), rating);
            data.put(Parameter.maxSteps.name(), maxSteps);
            if (StringUtil.IsOptionalParameterValid(algo)) {
                data.put(Parameter.algo.name(), (Object)new JSONObject(algo));
            }
            if (StringUtil.IsOptionalParameterValid(filterJson)) {
                data.put(Parameter.filterJson.name(), (Object)new JSONObject(filterJson));
            }
            if (otherUserCxIds != null) {
                data.put(Parameter.otherUserCxIds.name(), (Object)new JSONArray(otherUserCxIds));
            }
            if (StringUtil.IsOptionalParameterValid(settings)) {
                data.put(Parameter.settings.name(), (Object)new JSONObject(settings));
            }
            data.put(Parameter.isReady.name(), (Object)isReady);
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                data.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            data.put(Parameter.teamCode.name(), (Object)teamCode);
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.FIND_OR_CREATE_LOBBY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void findOrCreateLobbyWithPingData(String lobbyType, int rating, int maxSteps, String algo, String filterJson, ArrayList<String> otherUserCxIds, String settings, Boolean isReady, String extraJson, String teamCode, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyType.name(), (Object)lobbyType);
            data.put(Parameter.rating.name(), rating);
            data.put(Parameter.maxSteps.name(), maxSteps);
            if (StringUtil.IsOptionalParameterValid(algo)) {
                data.put(Parameter.algo.name(), (Object)new JSONObject(algo));
            }
            if (StringUtil.IsOptionalParameterValid(filterJson)) {
                data.put(Parameter.filterJson.name(), (Object)new JSONObject(filterJson));
            }
            if (otherUserCxIds != null) {
                data.put(Parameter.otherUserCxIds.name(), (Object)new JSONArray(otherUserCxIds));
            }
            if (StringUtil.IsOptionalParameterValid(settings)) {
                data.put(Parameter.settings.name(), (Object)new JSONObject(settings));
            }
            data.put(Parameter.isReady.name(), (Object)isReady);
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                data.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            data.put(Parameter.teamCode.name(), (Object)teamCode);
            this.attachPingDataAndSend(data, ServiceOperation.FIND_OR_CREATE_LOBBY_WITH_PING_DATA, callback);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getLobbyData(String lobbyId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyId.name(), (Object)lobbyId);
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.GET_LOBBY_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void leaveLobby(String lobbyId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyId.name(), (Object)lobbyId);
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.LEAVE_LOBBY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void joinLobby(String lobbyId, boolean isReady, String extraJson, String teamCode, ArrayList<String> otherUserCxIds, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyId.name(), (Object)lobbyId);
            data.put(Parameter.isReady.name(), isReady);
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                data.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            data.put(Parameter.teamCode.name(), (Object)teamCode);
            if (otherUserCxIds != null) {
                data.put(Parameter.otherUserCxIds.name(), (Object)new JSONArray(otherUserCxIds));
            }
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.JOIN_LOBBY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void joinLobbyWithPingData(String lobbyId, boolean isReady, String extraJson, String teamCode, ArrayList<String> otherUserCxIds, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyId.name(), (Object)lobbyId);
            data.put(Parameter.isReady.name(), isReady);
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                data.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            data.put(Parameter.teamCode.name(), (Object)teamCode);
            if (otherUserCxIds != null) {
                data.put(Parameter.otherUserCxIds.name(), (Object)new JSONArray(otherUserCxIds));
            }
            this.attachPingDataAndSend(data, ServiceOperation.JOIN_LOBBY_WITH_PING_DATA, callback);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void removeMember(String lobbyId, String cxId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyId.name(), (Object)lobbyId);
            data.put(Parameter.cxId.name(), (Object)cxId);
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.REMOVE_MEMBER, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void sendSignal(String lobbyId, String signalData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyId.name(), (Object)lobbyId);
            if (StringUtil.IsOptionalParameterValid(signalData)) {
                data.put(Parameter.signalData.name(), (Object)new JSONObject(signalData));
            }
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.SEND_SIGNAL, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void switchTeam(String lobbyId, String toTeamCode, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyId.name(), (Object)lobbyId);
            data.put(Parameter.toTeamCode.name(), (Object)toTeamCode);
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.SWITCH_TEAM, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void updateReady(String lobbyId, Boolean isReady, String extraJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyId.name(), (Object)lobbyId);
            data.put(Parameter.isReady.name(), (Object)isReady);
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                data.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.UPDATE_READY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void updateSettings(String lobbyId, String settings, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyId.name(), (Object)lobbyId);
            if (StringUtil.IsOptionalParameterValid(settings)) {
                data.put(Parameter.settings.name(), (Object)new JSONObject(settings));
            }
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.UPDATE_SETTINGS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getLobbyInstances(String lobbyType, String criteriaJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyType.name(), (Object)lobbyType);
            data.put(Parameter.criteriaJson.name(), (Object)new JSONObject(criteriaJson));
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.GET_LOBBY_INSTANCES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getLobbyInstancesWithPingData(String lobbyType, String criteriaJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyType.name(), (Object)lobbyType);
            data.put(Parameter.criteriaJson.name(), (Object)new JSONObject(criteriaJson));
            this.attachPingDataAndSend(data, ServiceOperation.GET_LOBBY_INSTANCES_WITH_PING_DATA, callback);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void cancelFindRequest(String lobbyType, String cxId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyType.name(), (Object)lobbyType);
            data.put(Parameter.cxId.name(), (Object)cxId);
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.CANCEL_FIND_REQUEST, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getRegionsForLobbies(String[] in_lobbyTypes, IServerCallback callback) {
        try {
            this._pingData = null;
            this._pingRegions = null;
            this._getRegionsForLobbiesCallback = callback;
            JSONObject data = new JSONObject();
            data.put(Parameter.lobbyTypes.name(), (Object)in_lobbyTypes);
            ServerCall sc = new ServerCall(ServiceName.lobby, ServiceOperation.GET_REGIONS_FOR_LOBBIES, data, this);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private void startPingThread() {
        this._pingData = new JSONObject();
        this._isPingRunning.set(true);
        this._pingRegionsThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HashMap<String, String> regionsToPing = new HashMap<String, String>();
                    for (int i = 0; i < LobbyService.this._pingRegions.names().length(); ++i) {
                        String regionName = LobbyService.this._pingRegions.names().getString(i);
                        JSONObject jsonRegion = LobbyService.this._pingRegions.getJSONObject(regionName);
                        String type = jsonRegion.getString("type");
                        String target = jsonRegion.getString("target");
                        if (type == null || !type.equals("PING")) continue;
                        regionsToPing.put(regionName, target);
                    }
                    ArrayList<ActivePing> activePings = new ArrayList<ActivePing>();
                    Object object = LobbyService.this._pingSync;
                    synchronized (object) {
                        while (LobbyService.this._isPingRunning.get()) {
                            while (!regionsToPing.isEmpty() && activePings.size() < 2) {
                                String regionName = (String)regionsToPing.keySet().toArray()[0];
                                String regionURL = (String)regionsToPing.get(regionName);
                                ActivePing activePing = new ActivePing(regionName, regionURL, LobbyService.this._pingSync);
                                activePings.add(activePing);
                                regionsToPing.remove(regionName);
                            }
                            for (int i = 0; i < activePings.size(); ++i) {
                                ActivePing activePing = (ActivePing)activePings.get(i);
                                if (!activePing.isFinished()) continue;
                                LobbyService.this._pingData.put(activePing.getRegion(), activePing.getPing());
                                activePings.remove(i);
                                --i;
                            }
                            if (regionsToPing.isEmpty() && activePings.isEmpty()) {
                                LobbyService.this._isPingRunning.set(false);
                                break;
                            }
                            if (activePings.isEmpty()) continue;
                            LobbyService.this._pingSync.wait();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LobbyService.this.queueErrorEvent(LobbyService.this._pingCallback, ServiceName.lobby, ServiceOperation.PING_REGIONS, 400, 40358, "Required message parameter 'pingData' is missing. Please ensure PingData exists by first calling GetRegionsForLobbies and PingRegions, and waiting for response before proceeding.");
                    return;
                }
            }
        });
        this._pingRegionsThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPingThread() {
        if (this._pingRegionsThread != null) {
            this._isPingRunning.set(false);
            Object object = this._pingSync;
            synchronized (object) {
                this._pingSync.notify();
            }
            try {
                this._pingRegionsThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._pingRegionsThread = null;
        }
    }

    public void pingRegions(IServerCallback callback) {
        if (this._pingRegions == null) {
            if (callback != null) {
                this.queueErrorEvent(callback, ServiceName.lobby, ServiceOperation.PING_REGIONS, 400, 40358, "Required message parameter 'pingData' is missing. Please ensure PingData exists by first calling GetRegionsForLobbies and PingRegions, and waiting for response before proceeding.");
            }
            return;
        }
        if (this._pingRegionsThread == null) {
            this._pingCallback = callback;
            this.startPingThread();
        } else if (callback != null) {
            this.queueErrorEvent(callback, ServiceName.lobby, ServiceOperation.PING_REGIONS, 400, 40358, "'pingRegions' is already running. Please wait for callback before calling this again.");
        }
    }

    private int pingHost(String targetURL) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(targetURL).openConnection();
            try {
                connection.setRequestMethod("GET");
            }
            catch (ProtocolException pe) {
                return 999;
            }
            long timeStart = System.currentTimeMillis();
            if (connection.getResponseCode() == 200) {
                long timeEnd = System.currentTimeMillis();
                int resultPing = (int)(timeEnd - timeStart);
                if (resultPing > 999) {
                    resultPing = 999;
                }
                return resultPing;
            }
            return 999;
        }
        catch (IOException io) {
            return 999;
        }
    }

    private void attachPingDataAndSend(JSONObject in_data, ServiceOperation in_operation, IServerCallback callback) {
        if (this._pingData != null && this._pingData.length() > 0) {
            try {
                in_data.put(Parameter.pingData.name(), (Object)this._pingData);
                ServerCall sc = new ServerCall(ServiceName.lobby, in_operation, in_data, callback);
                this._client.sendRequest(sc);
            }
            catch (JSONException je) {
                je.printStackTrace();
            }
        } else {
            this.queueErrorEvent(callback, ServiceName.lobby, in_operation, 400, 40358, "Required parameter 'pingData' is missing. Please ensure 'pingData' exists by first calling GetRegionsForLobbies, then wait for the response and then call PingRegions");
        }
    }

    @Override
    public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
        if (serviceName.toString().equals("lobby") && serviceOperation.toString().equals("GET_REGIONS_FOR_LOBBIES")) {
            try {
                this._pingRegions = jsonData.getJSONObject("data").getJSONObject("regionPingData");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (this._getRegionsForLobbiesCallback != null) {
                this._getRegionsForLobbiesCallback.serverCallback(serviceName, serviceOperation, jsonData);
            }
        }
    }

    @Override
    public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
        if (serviceName.toString().equals("lobby") && serviceOperation.toString().equals("GET_REGIONS_FOR_LOBBIES")) {
            this._getRegionsForLobbiesCallback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPingCallbacks() {
        if (!this._isPingRunning.get() && this._pingCallback != null) {
            if (this._loggingEnabled) {
                String dataStr = this._pingData.toString();
                System.out.println("#PING RESULTS " + dataStr);
            }
            this._pingCallback.serverCallback(ServiceName.lobby, ServiceOperation.PING_REGIONS, this._pingData);
            this._pingCallback = null;
            this.stopPingThread();
        }
        ArrayList<ErrorCallbackEvent> arrayList = this._errorCallbackQueue;
        synchronized (arrayList) {
            for (int i = 0; i < this._errorCallbackQueue.size(); ++i) {
                ErrorCallbackEvent evt = this._errorCallbackQueue.get(i);
                evt.callback.serverError(evt.serviceName, evt.serviceOperation, evt.statusCode, evt.reasonCode, evt.jsonError);
            }
            this._errorCallbackQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueErrorEvent(IServerCallback callback, ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
        ErrorCallbackEvent evt = new ErrorCallbackEvent();
        evt.callback = callback;
        evt.serviceName = serviceName;
        evt.serviceOperation = serviceOperation;
        evt.statusCode = statusCode;
        evt.reasonCode = reasonCode;
        evt.jsonError = jsonError;
        ArrayList<ErrorCallbackEvent> arrayList = this._errorCallbackQueue;
        synchronized (arrayList) {
            this._errorCallbackQueue.add(evt);
        }
    }

    public JSONObject getPingData() {
        return this._pingData;
    }

    private static enum Parameter {
        lobbyType,
        rating,
        maxSteps,
        algo,
        filterJson,
        otherUserCxIds,
        settings,
        isReady,
        extraJson,
        teamCode,
        lobbyId,
        cxId,
        signalData,
        toTeamCode,
        roomType,
        lobbyTypes,
        pingData,
        criteriaJson;

    }

    class ErrorCallbackEvent {
        public IServerCallback callback;
        public ServiceName serviceName;
        public ServiceOperation serviceOperation;
        public int statusCode;
        public int reasonCode;
        public String jsonError;

        ErrorCallbackEvent() {
        }
    }

    class ActivePing {
        private String _regionName;
        private String _regionURL;
        private Object _sync;
        private int _ping;
        private Thread _thread;

        public ActivePing(String regionName, String regionURL, Object sync) {
            this._regionName = regionName;
            this._regionURL = regionURL;
            this._sync = sync;
            this._ping = -1;
            this._thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ArrayList<Integer> pings = new ArrayList<Integer>();
                        String fullURL = "http://" + ActivePing.this._regionURL;
                        for (int i = 0; i < 4; ++i) {
                            pings.add(new Integer(LobbyService.this.pingHost(fullURL)));
                        }
                        pings.sort(null);
                        int pingResult = 0;
                        for (int i = 0; i < 3; ++i) {
                            pingResult += ((Integer)pings.get(i)).intValue();
                        }
                        ActivePing.this._ping = (pingResult /= 3);
                        Object object = ActivePing.this._sync;
                        synchronized (object) {
                            ActivePing.this._sync.notify();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
            });
            this._thread.start();
        }

        public String getRegion() {
            return this._regionName;
        }

        public int getPing() {
            return this._ping;
        }

        public boolean isFinished() {
            return this._ping != -1;
        }
    }
}

