/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class RedemptionCodeService {
    private BrainCloudClient _client;

    public RedemptionCodeService(BrainCloudClient client) {
        this._client = client;
    }

    public void redeemCode(String scanCode, String codeType, String jsonCustomRedemptionInfo, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.scanCode.name(), (Object)scanCode);
            data.put(Parameter.codeType.name(), (Object)codeType);
            if (StringUtil.IsOptionalParameterValid(jsonCustomRedemptionInfo)) {
                JSONObject infoObj = new JSONObject(jsonCustomRedemptionInfo);
                data.put(Parameter.customRedemptionInfo.name(), (Object)infoObj);
            }
            ServerCall sc = new ServerCall(ServiceName.redemptionCode, ServiceOperation.REDEEM_CODE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getRedeemedCodes(String codeType, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (StringUtil.IsOptionalParameterValid(codeType)) {
                data.put(Parameter.codeType.name(), (Object)codeType);
            }
            ServerCall sc = new ServerCall(ServiceName.redemptionCode, ServiceOperation.GET_REDEEMED_CODES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private static enum Parameter {
        scanCode,
        codeType,
        customRedemptionInfo;

    }
}

