/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.client;

import com.bitheads.braincloud.client.AuthenticationIds;
import com.bitheads.braincloud.client.AuthenticationType;
import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IBrainCloudWrapper;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.IdentityCallback;
import com.bitheads.braincloud.client.Platform;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.services.AppStoreService;
import com.bitheads.braincloud.services.AsyncMatchService;
import com.bitheads.braincloud.services.AuthenticationService;
import com.bitheads.braincloud.services.ChatService;
import com.bitheads.braincloud.services.CustomEntityService;
import com.bitheads.braincloud.services.DataStreamService;
import com.bitheads.braincloud.services.EntityService;
import com.bitheads.braincloud.services.EventService;
import com.bitheads.braincloud.services.FileService;
import com.bitheads.braincloud.services.FriendService;
import com.bitheads.braincloud.services.GamificationService;
import com.bitheads.braincloud.services.GlobalAppService;
import com.bitheads.braincloud.services.GlobalEntityService;
import com.bitheads.braincloud.services.GlobalFileService;
import com.bitheads.braincloud.services.GlobalStatisticsService;
import com.bitheads.braincloud.services.GroupFileService;
import com.bitheads.braincloud.services.GroupService;
import com.bitheads.braincloud.services.IdentityService;
import com.bitheads.braincloud.services.ItemCatalogService;
import com.bitheads.braincloud.services.LobbyService;
import com.bitheads.braincloud.services.MailService;
import com.bitheads.braincloud.services.MatchMakingService;
import com.bitheads.braincloud.services.MessagingService;
import com.bitheads.braincloud.services.OneWayMatchService;
import com.bitheads.braincloud.services.PlaybackStreamService;
import com.bitheads.braincloud.services.PlayerStateService;
import com.bitheads.braincloud.services.PlayerStatisticsEventService;
import com.bitheads.braincloud.services.PlayerStatisticsService;
import com.bitheads.braincloud.services.PresenceService;
import com.bitheads.braincloud.services.ProfanityService;
import com.bitheads.braincloud.services.PushNotificationService;
import com.bitheads.braincloud.services.RTTService;
import com.bitheads.braincloud.services.RedemptionCodeService;
import com.bitheads.braincloud.services.RelayService;
import com.bitheads.braincloud.services.S3HandlingService;
import com.bitheads.braincloud.services.ScriptService;
import com.bitheads.braincloud.services.SocialLeaderboardService;
import com.bitheads.braincloud.services.TimeService;
import com.bitheads.braincloud.services.TournamentService;
import com.bitheads.braincloud.services.UserItemsService;
import com.bitheads.braincloud.services.VirtualCurrencyService;
import java.util.Map;
import java.util.prefs.Preferences;
import org.json.JSONException;
import org.json.JSONObject;

public class BrainCloudWrapper
implements IServerCallback,
IBrainCloudWrapper {
    private static final String AUTHENTICATION_ANONYMOUS = "anonymous";
    private static final String _SHARED_PREFERENCES = "bcprefs";
    private static final String _DEFAULT_URL = "https://api.braincloudservers.com/dispatcherv2";
    private Preferences _prefs = Preferences.userNodeForPackage(BrainCloudWrapper.class);
    private boolean _alwaysAllowProfileSwitch = true;
    private IServerCallback _authenticateCallback = null;
    private BrainCloudClient _client = null;
    private String _wrapperName = "";
    private InitializeParams m_initializeParams = new InitializeParams();

    @Override
    public Platform getReleasePlatform() {
        return this._client.getReleasePlatform();
    }

    @Override
    public void setReleasePlatform(Platform releasePlatform) {
        this.getClient().setReleasePlatform(releasePlatform);
    }

    @Override
    public BrainCloudClient getClient() {
        return this._client;
    }

    public BrainCloudWrapper() {
        this._client = new BrainCloudClient();
    }

    public BrainCloudWrapper(String wrapperName) {
        this._wrapperName = wrapperName;
        this._client = new BrainCloudClient();
        this._prefs = Preferences.userRoot().node(this.getSaveName());
    }

    private void detectPlatform() {
        this.setReleasePlatform(Platform.detectGenericPlatform(System.getProperty("os.name").toLowerCase()));
    }

    @Override
    public void initialize(String appId, String secretKey, String appVersion) {
        this.m_initializeParams.appId = appId;
        this.m_initializeParams.secretKey = secretKey;
        this.m_initializeParams.appVersion = appVersion;
        this.m_initializeParams.serverUrl = _DEFAULT_URL;
        this.m_initializeParams.secretMap = null;
        if (this._client == null) {
            this._client = new BrainCloudClient();
        }
        this.detectPlatform();
        this.getClient().initialize(_DEFAULT_URL, appId, secretKey, appVersion);
    }

    @Override
    public void initialize(String appId, String secretKey, String appVersion, String serverUrl) {
        this.m_initializeParams.appId = appId;
        this.m_initializeParams.secretKey = secretKey;
        this.m_initializeParams.appVersion = appVersion;
        this.m_initializeParams.serverUrl = serverUrl;
        this.m_initializeParams.secretMap = null;
        if (this._client == null) {
            this._client = new BrainCloudClient();
        }
        this.detectPlatform();
        this.getClient().initialize(serverUrl, appId, secretKey, appVersion);
    }

    private void initializeWithApps(String url, String defaultAppId, Map<String, String> secretMap, String version, String companyName, String appName) {
        this.m_initializeParams.appId = defaultAppId;
        this.m_initializeParams.secretKey = "";
        this.m_initializeParams.appVersion = version;
        this.m_initializeParams.serverUrl = url;
        this.m_initializeParams.secretMap = secretMap;
        if (this._client == null) {
            this._client = new BrainCloudClient();
        }
        this.detectPlatform();
        this.getClient().initializeWithApps(url, defaultAppId, secretMap, version);
    }

    private void initializeWithApps(String url, String defaultAppId, Map<String, String> secretMap, String version) {
        this.m_initializeParams.appId = defaultAppId;
        this.m_initializeParams.secretKey = "";
        this.m_initializeParams.appVersion = version;
        this.m_initializeParams.serverUrl = url;
        this.m_initializeParams.secretMap = secretMap;
        if (this._client == null) {
            this._client = new BrainCloudClient();
        }
        this.detectPlatform();
        this.getClient().initializeWithApps(url, defaultAppId, secretMap, version);
    }

    protected void initializeIdentity(boolean isAnonymousAuth) {
        String profileId = this.getStoredProfileId();
        String anonymousId = this.getStoredAnonymousId();
        if (!anonymousId.isEmpty() && profileId.isEmpty() || anonymousId.isEmpty()) {
            anonymousId = this.getClient().getAuthenticationService().generateAnonymousId();
            profileId = "";
            this.setStoredAnonymousId(anonymousId);
            this.setStoredProfileId(profileId);
        }
        String profileIdToAuthenticateWith = profileId;
        if (!isAnonymousAuth && this._alwaysAllowProfileSwitch) {
            profileIdToAuthenticateWith = "";
        }
        this.setStoredAuthenticationType(isAnonymousAuth ? AUTHENTICATION_ANONYMOUS : "");
        this.getClient().initializeIdentity(profileIdToAuthenticateWith, anonymousId);
    }

    private String getSaveName() {
        String prefix = this._wrapperName.isEmpty() ? "" : "_" + this._wrapperName;
        return prefix + _SHARED_PREFERENCES;
    }

    @Override
    public String getStoredProfileId() {
        return this._prefs.get("profileId", "");
    }

    @Override
    public void setStoredProfileId(String profileId) {
        this._prefs.put("profileId", profileId);
    }

    @Override
    public void resetStoredProfileId() {
        this.setStoredProfileId("");
    }

    String getStoredAnonymousId() {
        return this._prefs.get("anonymousId", "");
    }

    @Override
    public void setStoredAnonymousId(String anonymousId) {
        this._prefs.put("anonymousId", anonymousId);
    }

    @Override
    public void resetStoredAnonymousId() {
        this.setStoredAnonymousId("");
    }

    @Override
    public void setAlwaysAllowProfileSwitch(boolean alwaysAllow) {
        this._alwaysAllowProfileSwitch = alwaysAllow;
    }

    @Override
    public boolean getAlwaysAllowProfileSwitch() {
        return this._alwaysAllowProfileSwitch;
    }

    protected String getStoredAuthenticationType() {
        return this._prefs.get("authenticationType", "");
    }

    protected void setStoredAuthenticationType(String authenticationType) {
        this._prefs.put("authenticationType", authenticationType);
    }

    protected void resetStoredAuthenticationType() {
        this.setStoredAuthenticationType("");
    }

    @Override
    public void authenticateAnonymous(IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(true);
        this.getClient().getAuthenticationService().authenticateAnonymous(true, this);
    }

    @Override
    public void authenticateHandoff(String handoffId, String securityToken, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.getClient().getAuthenticationService().authenticateHandoff(handoffId, securityToken, this);
    }

    @Override
    public void authenticateSettopHandoff(String handoffCode, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.getClient().getAuthenticationService().authenticateSettopHandoff(handoffCode, this);
    }

    @Override
    public void authenticateEmailPassword(String email, String password, boolean forceCreate, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateEmailPassword(email, password, forceCreate, this);
    }

    @Override
    public void authenticateExternal(String userId, String token, String externalAuthName, boolean forceCreate, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateExternal(userId, token, externalAuthName, forceCreate, this);
    }

    @Override
    public void authenticateFacebook(String fbUserId, String fbAuthToken, boolean forceCreate, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateFacebook(fbUserId, fbAuthToken, forceCreate, this);
    }

    @Override
    public void authenticateFacebookLimited(String fbLimitedUserId, String fbAuthToken, boolean forceCreate, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateFacebookLimited(fbLimitedUserId, fbAuthToken, forceCreate, this);
    }

    @Override
    public void authenticateGoogle(String googleUserId, String googleAuthToken, boolean forceCreate, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateGoogle(googleUserId, googleAuthToken, forceCreate, this);
    }

    @Override
    public void authenticateGoogleOpenId(String googleOpenId, String googleAuthToken, boolean forceCreate, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateGoogleOpenId(googleOpenId, googleAuthToken, forceCreate, this);
    }

    @Override
    public void authenticateApple(String appleUserId, String token, boolean forceCreate, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateApple(appleUserId, token, forceCreate, this);
    }

    @Override
    public void authenticateSteam(String steamUserId, String steamSessionTicket, boolean forceCreate, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateSteam(steamUserId, steamSessionTicket, forceCreate, this);
    }

    @Override
    public void authenticateUltra(String ultraUsername, String ultraIdToken, boolean forceCreate, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateUltra(ultraUsername, ultraIdToken, forceCreate, this);
    }

    @Override
    public void authenticateTwitter(String userId, String token, String secret, boolean forceCreate, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateTwitter(userId, token, secret, forceCreate, this);
    }

    @Override
    public void authenticateUniversal(String userId, String userPassword, boolean forceCreate, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateUniversal(userId, userPassword, forceCreate, this);
    }

    @Override
    public void authenticateAdvanced(AuthenticationType authenticationType, AuthenticationIds ids, boolean forceCreate, String extraJson, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateAdvanced(authenticationType, ids, forceCreate, extraJson, this);
    }

    @Override
    public void authenticateOculus(String oculusUserId, String oculusNonce, boolean forceCreate, IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(false);
        this.getClient().getAuthenticationService().authenticateOculus(oculusUserId, oculusNonce, forceCreate, this);
    }

    @Override
    public void reconnect(IServerCallback callback) {
        this._authenticateCallback = callback;
        this.initializeIdentity(true);
        this.getClient().getAuthenticationService().authenticateAnonymous(false, this);
    }

    @Override
    public void resetEmailPassword(String email, IServerCallback callback) {
        this.getClient().getAuthenticationService().resetEmailPassword(email, this);
    }

    @Override
    public void resetEmailPasswordAdvanced(String email, String serviceParams, IServerCallback callback) {
        this.getClient().getAuthenticationService().resetEmailPasswordAdvanced(email, serviceParams, this);
    }

    @Override
    public void resetEmailPasswordWithExpiry(String email, int tokenTtlInMinutes, IServerCallback callback) {
        this.getClient().getAuthenticationService().resetEmailPasswordWithExpiry(email, tokenTtlInMinutes, this);
    }

    @Override
    public void resetEmailPasswordAdvancedWithExpiry(String email, String serviceParams, Integer tokenTtlInMinutes, IServerCallback callback) {
        this.getClient().getAuthenticationService().resetEmailPasswordAdvancedWithExpiry(email, serviceParams, tokenTtlInMinutes, this);
    }

    @Override
    public void resetUniversalIdPassword(String universalId, IServerCallback callback) {
        this.getClient().getAuthenticationService().resetUniversalIdPassword(universalId, this);
    }

    @Override
    public void resetUniversalIdPasswordAdvanced(String universalId, String serviceParams, IServerCallback callback) {
        this.getClient().getAuthenticationService().resetUniversalIdPasswordAdvanced(universalId, serviceParams, this);
    }

    @Override
    public void resetUniversalIdPasswordWithExpiry(String universalId, int tokenTtlInMinutes, IServerCallback callback) {
        this.getClient().getAuthenticationService().resetUniversalIdPasswordWithExpiry(universalId, tokenTtlInMinutes, this);
    }

    @Override
    public void resetUniversalIdPasswordAdvancedWithExpiry(String universalId, String serviceParams, Integer tokenTtlInMinutes, IServerCallback callback) {
        this.getClient().getAuthenticationService().resetUniversalIdPasswordAdvancedWithExpiry(universalId, serviceParams, tokenTtlInMinutes, this);
    }

    @Override
    public void smartSwitchAuthenticateEmail(final String email, final String password, final boolean forceCreate, final IServerCallback callback) {
        this.getIdentitiesCallback(new IServerCallback(){

            @Override
            public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
                BrainCloudWrapper.this.resetStoredAnonymousId();
                BrainCloudWrapper.this.resetStoredProfileId();
                BrainCloudWrapper.this.getClient().getAuthenticationService().clearSavedProfileId();
                BrainCloudWrapper.this.authenticateEmailPassword(email, password, forceCreate, callback);
            }

            @Override
            public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
                callback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
            }
        });
    }

    @Override
    public void smartSwitchAuthenticateExternal(final String userId, final String token, final String externalAuthName, final boolean forceCreate, final IServerCallback callback) {
        this.getIdentitiesCallback(new IServerCallback(){

            @Override
            public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
                BrainCloudWrapper.this.resetStoredAnonymousId();
                BrainCloudWrapper.this.resetStoredProfileId();
                BrainCloudWrapper.this.getClient().getAuthenticationService().clearSavedProfileId();
                BrainCloudWrapper.this.authenticateExternal(userId, token, externalAuthName, forceCreate, callback);
            }

            @Override
            public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
                callback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
            }
        });
    }

    @Override
    public void smartSwitchAuthenticateFacebook(final String fbUserId, final String fbAuthToken, final boolean forceCreate, final IServerCallback callback) {
        this.getIdentitiesCallback(new IServerCallback(){

            @Override
            public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
                BrainCloudWrapper.this.resetStoredAnonymousId();
                BrainCloudWrapper.this.resetStoredProfileId();
                BrainCloudWrapper.this.getClient().getAuthenticationService().clearSavedProfileId();
                BrainCloudWrapper.this.authenticateFacebook(fbUserId, fbAuthToken, forceCreate, callback);
            }

            @Override
            public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
                callback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
            }
        });
    }

    @Override
    public void smartSwitchAuthenticateOculus(final String oculusUserId, final String oculusNonce, final boolean forceCreate, final IServerCallback callback) {
        this.getIdentitiesCallback(new IServerCallback(){

            @Override
            public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
                BrainCloudWrapper.this.resetStoredAnonymousId();
                BrainCloudWrapper.this.resetStoredProfileId();
                BrainCloudWrapper.this.getClient().getAuthenticationService().clearSavedProfileId();
                BrainCloudWrapper.this.authenticateOculus(oculusUserId, oculusNonce, forceCreate, callback);
            }

            @Override
            public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
                callback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
            }
        });
    }

    @Override
    public void smartSwitchAuthenticateGoogle(final String googleUserId, final String serverAuthCode, final boolean forceCreate, final IServerCallback callback) {
        this.getIdentitiesCallback(new IServerCallback(){

            @Override
            public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
                BrainCloudWrapper.this.resetStoredAnonymousId();
                BrainCloudWrapper.this.resetStoredProfileId();
                BrainCloudWrapper.this.getClient().getAuthenticationService().clearSavedProfileId();
                BrainCloudWrapper.this.authenticateGoogle(googleUserId, serverAuthCode, forceCreate, callback);
            }

            @Override
            public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
                callback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
            }
        });
    }

    @Override
    public void smartSwitchAuthenticateGoogleOpenId(final String googleUserAccountEmail, final String idToken, final boolean forceCreate, final IServerCallback callback) {
        this.getIdentitiesCallback(new IServerCallback(){

            @Override
            public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
                BrainCloudWrapper.this.resetStoredAnonymousId();
                BrainCloudWrapper.this.resetStoredProfileId();
                BrainCloudWrapper.this.getClient().getAuthenticationService().clearSavedProfileId();
                BrainCloudWrapper.this.authenticateGoogleOpenId(googleUserAccountEmail, idToken, forceCreate, callback);
            }

            @Override
            public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
                callback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
            }
        });
    }

    @Override
    public void smartSwitchAuthenticateApple(final String appleUserId, final String token, final boolean forceCreate, final IServerCallback callback) {
        this.getIdentitiesCallback(new IServerCallback(){

            @Override
            public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
                BrainCloudWrapper.this.resetStoredAnonymousId();
                BrainCloudWrapper.this.resetStoredProfileId();
                BrainCloudWrapper.this.getClient().getAuthenticationService().clearSavedProfileId();
                BrainCloudWrapper.this.authenticateApple(appleUserId, token, forceCreate, callback);
            }

            @Override
            public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
                callback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
            }
        });
    }

    @Override
    public void smartSwitchAuthenticateSteam(final String steamUserId, final String sessionTicket, final boolean forceCreate, final IServerCallback callback) {
        this.getIdentitiesCallback(new IServerCallback(){

            @Override
            public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
                BrainCloudWrapper.this.resetStoredAnonymousId();
                BrainCloudWrapper.this.resetStoredProfileId();
                BrainCloudWrapper.this.getClient().getAuthenticationService().clearSavedProfileId();
                BrainCloudWrapper.this.authenticateSteam(steamUserId, sessionTicket, forceCreate, callback);
            }

            @Override
            public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
                callback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
            }
        });
    }

    @Override
    public void smartSwitchAuthenticateTwitter(final String userId, final String token, final String secret, final boolean forceCreate, final IServerCallback callback) {
        this.getIdentitiesCallback(new IServerCallback(){

            @Override
            public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
                BrainCloudWrapper.this.resetStoredAnonymousId();
                BrainCloudWrapper.this.resetStoredProfileId();
                BrainCloudWrapper.this.getClient().getAuthenticationService().clearSavedProfileId();
                BrainCloudWrapper.this.authenticateTwitter(userId, token, secret, forceCreate, callback);
            }

            @Override
            public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
                callback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
            }
        });
    }

    @Override
    public void smartSwitchAuthenticateUniversal(final String userId, final String password, final boolean forceCreate, final IServerCallback callback) {
        this.getIdentitiesCallback(new IServerCallback(){

            @Override
            public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
                BrainCloudWrapper.this.resetStoredAnonymousId();
                BrainCloudWrapper.this.resetStoredProfileId();
                BrainCloudWrapper.this.getClient().getAuthenticationService().clearSavedProfileId();
                BrainCloudWrapper.this.authenticateUniversal(userId, password, forceCreate, callback);
            }

            @Override
            public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
                callback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
            }
        });
    }

    @Override
    public void smartSwitchAuthenticateUltra(final String ultraUserId, final String ultraIdToken, final boolean forceCreate, final IServerCallback callback) {
        this.getIdentitiesCallback(new IServerCallback(){

            @Override
            public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
                BrainCloudWrapper.this.resetStoredAnonymousId();
                BrainCloudWrapper.this.resetStoredProfileId();
                BrainCloudWrapper.this.getClient().getAuthenticationService().clearSavedProfileId();
                BrainCloudWrapper.this.authenticateUltra(ultraUserId, ultraIdToken, forceCreate, callback);
            }

            @Override
            public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
                callback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
            }
        });
    }

    @Override
    public void smartSwitchAuthenticateAdvanced(final AuthenticationType authenticationType, final AuthenticationIds ids, final boolean forceCreate, final String extraJson, final IServerCallback callback) {
        this.getIdentitiesCallback(new IServerCallback(){

            @Override
            public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
                BrainCloudWrapper.this.resetStoredAnonymousId();
                BrainCloudWrapper.this.resetStoredProfileId();
                BrainCloudWrapper.this.getClient().getAuthenticationService().clearSavedProfileId();
                BrainCloudWrapper.this.authenticateAdvanced(authenticationType, ids, forceCreate, extraJson, callback);
            }

            @Override
            public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
                callback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
            }
        });
    }

    @Override
    public void logout(boolean forgetUser, IServerCallback callback) {
        if (forgetUser) {
            this.resetStoredProfileId();
        }
        this.getClient().getPlayerStateService().logout(callback);
    }

    private void getIdentitiesCallback(IServerCallback success) {
        IdentityCallback identityCallback = new IdentityCallback(this, success);
        if (this.getClient().isAuthenticated()) {
            this.getClient().getIdentityService().getIdentities(identityCallback);
        } else {
            success.serverCallback(ServiceName.authenticationV2, ServiceOperation.AUTHENTICATE, null);
        }
    }

    @Override
    public void runCallbacks() {
        this.getClient().runCallbacks();
    }

    @Override
    public void serverCallback(ServiceName serviceName, ServiceOperation serviceOperation, JSONObject jsonData) {
        if (serviceName.equals((Object)ServiceName.authenticationV2) && serviceOperation.equals((Object)ServiceOperation.AUTHENTICATE)) {
            try {
                String profileId = jsonData.getJSONObject("data").getString("profileId");
                if (!profileId.isEmpty()) {
                    this.setStoredProfileId(profileId);
                }
            }
            catch (JSONException je) {
                je.printStackTrace();
            }
        }
        if (this._authenticateCallback != null) {
            this._authenticateCallback.serverCallback(serviceName, serviceOperation, jsonData);
        }
    }

    @Override
    public void serverError(ServiceName serviceName, ServiceOperation serviceOperation, int statusCode, int reasonCode, String jsonError) {
        if (statusCode == 202 && reasonCode == 40308) {
            String newAppId;
            JSONObject data = new JSONObject(jsonError);
            this.m_initializeParams.serverUrl = data.has("redirect_url") ? data.getString("redirect_url") : this.m_initializeParams.serverUrl;
            String string = newAppId = data.has("redirect_appid") ? data.getString("redirect_appid") : null;
            if (this.m_initializeParams.secretMap == null) {
                if (newAppId != null) {
                    this.m_initializeParams.appId = newAppId;
                }
                this.getClient().initialize(this.m_initializeParams.serverUrl, this.m_initializeParams.appId, this.m_initializeParams.secretKey, this.m_initializeParams.appVersion);
            } else {
                this.getClient().initializeWithApps(this.m_initializeParams.serverUrl, this.m_initializeParams.appId, this.m_initializeParams.secretMap, this.m_initializeParams.appVersion);
            }
            this.initializeIdentity(true);
            this.getClient().getAuthenticationService().retryPreviousAuthenticate(this);
            return;
        }
        if (this._authenticateCallback != null) {
            this._authenticateCallback.serverError(serviceName, serviceOperation, statusCode, reasonCode, jsonError);
        }
    }

    @Override
    public AppStoreService getAppStoreService() {
        return this._client.getAppStoreService();
    }

    @Override
    public AsyncMatchService getAsyncMatchService() {
        return this._client.getAsyncMatchService();
    }

    @Override
    public AuthenticationService getAuthenticationService() {
        return this._client.getAuthenticationService();
    }

    @Override
    public ChatService getChatService() {
        return this._client.getChatService();
    }

    @Override
    public LobbyService getLobbyService() {
        return this._client.getLobbyService();
    }

    @Override
    public DataStreamService getDataStreamService() {
        return this._client.getDataStreamService();
    }

    @Override
    public EntityService getEntityService() {
        return this._client.getEntityService();
    }

    @Override
    public EventService getEventService() {
        return this._client.getEventService();
    }

    @Override
    public FileService getFileService() {
        return this._client.getFileService();
    }

    @Override
    public FriendService getFriendService() {
        return this._client.getFriendService();
    }

    @Override
    public GamificationService getGamificationService() {
        return this._client.getGamificationService();
    }

    @Override
    public GlobalAppService getGlobalAppService() {
        return this._client.getGlobalAppService();
    }

    @Override
    public GlobalEntityService getGlobalEntityService() {
        return this._client.getGlobalEntityService();
    }

    @Override
    public GlobalStatisticsService getGlobalStatisticsService() {
        return this._client.getGlobalStatisticsService();
    }

    @Override
    public GroupService getGroupService() {
        return this._client.getGroupService();
    }

    @Override
    public GroupFileService getGroupFileService() {
        return this._client.getGroupFileService();
    }

    @Override
    public IdentityService getIdentityService() {
        return this._client.getIdentityService();
    }

    @Override
    public MailService getMailService() {
        return this._client.getMailService();
    }

    @Override
    public MessagingService getMessagingService() {
        return this._client.getMessagingService();
    }

    @Override
    public MatchMakingService getMatchMakingService() {
        return this._client.getMatchMakingService();
    }

    @Override
    public OneWayMatchService getOneWayMatchService() {
        return this._client.getOneWayMatchService();
    }

    @Override
    public PlaybackStreamService getPlaybackStreamService() {
        return this._client.getPlaybackStreamService();
    }

    @Override
    public PlayerStateService getPlayerStateService() {
        return this._client.getPlayerStateService();
    }

    @Override
    public PlayerStatisticsService getPlayerStatisticsService() {
        return this._client.getPlayerStatisticsService();
    }

    @Override
    public PlayerStatisticsEventService getPlayerStatisticsEventService() {
        return this._client.getPlayerStatisticsEventService();
    }

    @Override
    public PresenceService getPresenceService() {
        return this._client.getPresenceService();
    }

    @Override
    public VirtualCurrencyService getVirtualCurrencyService() {
        return this._client.getVirtualCurrencyService();
    }

    @Override
    public ProfanityService getProfanityService() {
        return this._client.getProfanityService();
    }

    @Override
    public PushNotificationService getPushNotificationService() {
        return this._client.getPushNotificationService();
    }

    @Override
    public RedemptionCodeService getRedemptionCodeService() {
        return this._client.getRedemptionCodeService();
    }

    @Override
    public RelayService getRelayService() {
        return this._client.getRelayService();
    }

    @Override
    public RTTService getRTTService() {
        return this._client.getRTTService();
    }

    @Override
    public S3HandlingService getS3HandlingService() {
        return this._client.getS3HandlingService();
    }

    @Override
    public ScriptService getScriptService() {
        return this._client.getScriptService();
    }

    @Override
    public SocialLeaderboardService getSocialLeaderboardService() {
        return this._client.getSocialLeaderboardService();
    }

    @Override
    public SocialLeaderboardService getLeaderboardService() {
        return this._client.getSocialLeaderboardService();
    }

    @Override
    public TimeService getTimeService() {
        return this._client.getTimeService();
    }

    @Override
    public TournamentService getTournamentService() {
        return this._client.getTournamentService();
    }

    @Override
    public GlobalFileService getGlobalFileService() {
        return this._client.getGlobalFileService();
    }

    @Override
    public CustomEntityService getCustomEntityService() {
        return this._client.getCustomEntityService();
    }

    @Override
    public ItemCatalogService getItemCatalogService() {
        return this._client.getItemCatalogService();
    }

    @Override
    public UserItemsService getUserItemsService() {
        return this._client.getUserItemsService();
    }

    private class InitializeParams {
        public String appId = "";
        public String secretKey = "";
        public String appVersion = "";
        public String serverUrl = "";
        public Map<String, String> secretMap = null;

        private InitializeParams() {
        }
    }
}

