/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

public class FileService {
    private BrainCloudClient _client;

    public FileService(BrainCloudClient client) {
        this._client = client;
    }

    public boolean uploadFile(String cloudPath, String cloudFilename, boolean shareable, boolean replaceIfExists, String localPath, IServerCallback callback) {
        File file = new File(localPath);
        if (!file.exists()) {
            return false;
        }
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.cloudPath.name(), (Object)cloudPath);
            data.put(Parameter.cloudFilename.name(), (Object)cloudFilename);
            data.put(Parameter.shareable.name(), shareable);
            data.put(Parameter.replaceIfExists.name(), replaceIfExists);
            data.put(Parameter.localPath.name(), (Object)localPath);
            data.put(Parameter.fileSize.name(), file.length());
            ServerCall sc = new ServerCall(ServiceName.file, ServiceOperation.PREPARE_USER_UPLOAD, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        return true;
    }

    public void listUserFiles(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.file, ServiceOperation.LIST_USER_FILES, null, callback);
        this._client.sendRequest(sc);
    }

    public void listUserFiles(String cloudPath, boolean recurse, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.cloudPath.name(), (Object)cloudPath);
            data.put(Parameter.recurse.name(), recurse);
            ServerCall sc = new ServerCall(ServiceName.file, ServiceOperation.LIST_USER_FILES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void deleteUserFile(String cloudPath, String cloudFilename, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.cloudPath.name(), (Object)cloudPath);
            data.put(Parameter.cloudFilename.name(), (Object)cloudFilename);
            ServerCall sc = new ServerCall(ServiceName.file, ServiceOperation.DELETE_USER_FILE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void deleteUserFiles(String cloudPath, boolean recurse, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.cloudPath.name(), (Object)cloudPath);
            data.put(Parameter.recurse.name(), recurse);
            ServerCall sc = new ServerCall(ServiceName.file, ServiceOperation.DELETE_USER_FILES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getCDNUrl(String cloudPath, String cloudFileName, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.cloudPath.name(), (Object)cloudPath);
            data.put(Parameter.cloudFilename.name(), (Object)cloudFileName);
            ServerCall sc = new ServerCall(ServiceName.file, ServiceOperation.GET_CDN_URL, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void cancelUpload(String uploadId) {
        this._client.getRestClient().cancelUpload(uploadId);
    }

    public double getUploadProgress(String uploadId) {
        return this._client.getRestClient().getUploadProgress(uploadId);
    }

    public long getUploadBytesTransferred(String uploadId) {
        return this._client.getRestClient().getUploadBytesTransferred(uploadId);
    }

    public long getUploadTotalBytesToTransfer(String uploadId) {
        return this._client.getRestClient().getUploadTotalBytesToTransfer(uploadId);
    }

    private static enum Parameter {
        cloudPath,
        cloudFilename,
        shareable,
        replaceIfExists,
        localPath,
        fileSize,
        recurse;

    }
}

