/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalFileService {
    private BrainCloudClient _client;

    public GlobalFileService(BrainCloudClient client) {
        this._client = client;
    }

    public void getFileInfo(String fileId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.fileId.name(), (Object)fileId);
            ServerCall sc = new ServerCall(ServiceName.globalFileV3, ServiceOperation.GET_FILE_INFO, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getFileInfoSimple(String folderPath, String filename, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.folderPath.name(), (Object)folderPath);
            data.put(Parameter.filename.name(), (Object)filename);
            ServerCall sc = new ServerCall(ServiceName.globalFileV3, ServiceOperation.GET_FILE_INFO_SIMPLE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGlobalCDNUrl(String fileId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.fileId.name(), (Object)fileId);
            ServerCall sc = new ServerCall(ServiceName.globalFileV3, ServiceOperation.GET_GLOBAL_CDN_URL, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGlobalFileList(String folderPath, boolean recurse, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.folderPath.name(), (Object)folderPath);
            data.put(Parameter.recurse.name(), recurse);
            ServerCall sc = new ServerCall(ServiceName.globalFileV3, ServiceOperation.GET_GLOBAL_FILE_LIST, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private static enum Parameter {
        fileId,
        folderPath,
        filename,
        recurse;

    }
}

