/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalStatisticsService {
    private BrainCloudClient _client;

    public GlobalStatisticsService(BrainCloudClient client) {
        this._client = client;
    }

    public void readAllGlobalStats(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.globalGameStatistics, ServiceOperation.READ, null, callback);
        this._client.sendRequest(sc);
    }

    public void readGlobalStatsSubset(String[] globalStats, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONArray jsonData = new JSONArray();
            for (String att : globalStats) {
                jsonData.put((Object)att);
            }
            data.put(Parameter.statistics.name(), (Object)jsonData);
            ServerCall sc = new ServerCall(ServiceName.globalGameStatistics, ServiceOperation.READ_SUBSET, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void readGlobalStatsForCategory(String category, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.category.name(), (Object)category);
            ServerCall sc = new ServerCall(ServiceName.globalGameStatistics, ServiceOperation.READ_FOR_CATEGORY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void incrementGlobalStats(String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONObject jsonDataObj = new JSONObject(jsonData);
            data.put(Parameter.statistics.name(), (Object)jsonDataObj);
            ServerCall sc = new ServerCall(ServiceName.globalGameStatistics, ServiceOperation.UPDATE_INCREMENT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void processStatistics(String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONObject jsonDataObj = new JSONObject(jsonData);
            data.put(Parameter.statistics.name(), (Object)jsonDataObj);
            ServerCall sc = new ServerCall(ServiceName.globalGameStatistics, ServiceOperation.PROCESS_STATISTICS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private static enum Parameter {
        statistics,
        category;

    }
}

