/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONException;
import org.json.JSONObject;

public class GroupFileService {
    private BrainCloudClient _client;

    public GroupFileService(BrainCloudClient client) {
        this._client = client;
    }

    public void checkFilenameExists(String groupId, String folderPath, String filename, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.folderPath.name(), (Object)folderPath);
            data.put(Parameter.filename.name(), (Object)filename);
            ServerCall sc = new ServerCall(ServiceName.groupFile, ServiceOperation.CHECK_FILENAME_EXISTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void checkFullpathFilenameExists(String groupId, String fullPathFilename, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.fullPathFilename.name(), (Object)fullPathFilename);
            ServerCall sc = new ServerCall(ServiceName.groupFile, ServiceOperation.CHECK_FULLPATH_FILENAME_EXISTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void copyFile(String groupId, String fileId, int version, String newTreeId, int treeVersion, String newFilename, boolean overwriteIfPresent, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.fileId.name(), (Object)fileId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.newTreeId.name(), (Object)newTreeId);
            data.put(Parameter.treeVersion.name(), treeVersion);
            data.put(Parameter.newFilename.name(), (Object)newFilename);
            data.put(Parameter.overwriteIfPresent.name(), overwriteIfPresent);
            ServerCall sc = new ServerCall(ServiceName.groupFile, ServiceOperation.COPY_FILE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void deleteFile(String groupId, String fileId, int version, String filename, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.fileId.name(), (Object)fileId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.filename.name(), (Object)filename);
            ServerCall sc = new ServerCall(ServiceName.groupFile, ServiceOperation.DELETE_FILE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getCDNUrl(String groupId, String fileId, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.fileId.name(), (Object)fileId);
            ServerCall sc = new ServerCall(ServiceName.groupFile, ServiceOperation.GET_CDN_URL, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getFileInfo(String groupId, String fileId, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.fileId.name(), (Object)fileId);
            ServerCall sc = new ServerCall(ServiceName.groupFile, ServiceOperation.GET_FILE_INFO, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getFileInfoSimple(String groupId, String folderPath, String filename, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.folderPath.name(), (Object)folderPath);
            data.put(Parameter.filename.name(), (Object)filename);
            ServerCall sc = new ServerCall(ServiceName.groupFile, ServiceOperation.GET_FILE_INFO_SIMPLE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getFileList(String groupId, String folderPath, boolean recurse, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.folderPath.name(), (Object)folderPath);
            data.put(Parameter.recurse.name(), recurse);
            ServerCall sc = new ServerCall(ServiceName.groupFile, ServiceOperation.GET_FILE_LIST, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void moveFile(String groupId, String fileId, int version, String newTreeId, int treeVersion, String newFilename, boolean overwriteIfPresent, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.fileId.name(), (Object)fileId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.newTreeId.name(), (Object)newTreeId);
            data.put(Parameter.treeVersion.name(), treeVersion);
            data.put(Parameter.newFilename.name(), (Object)newFilename);
            data.put(Parameter.overwriteIfPresent.name(), overwriteIfPresent);
            ServerCall sc = new ServerCall(ServiceName.groupFile, ServiceOperation.MOVE_FILE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void moveUserToGroupFile(String userCloudPath, String userCloudFilename, String groupId, String groupTreeId, String groupFileName, JSONObject groupFileAcl, boolean overwriteIfPresent, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.userCloudPath.name(), (Object)userCloudPath);
            data.put(Parameter.userCloudFilename.name(), (Object)userCloudFilename);
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.groupTreeId.name(), (Object)groupTreeId);
            data.put(Parameter.groupFilename.name(), (Object)groupFileName);
            data.put(Parameter.groupFileAcl.name(), (Object)groupFileAcl);
            data.put(Parameter.overwriteIfPresent.name(), overwriteIfPresent);
            ServerCall sc = new ServerCall(ServiceName.groupFile, ServiceOperation.MOVE_USER_TO_GROUP_FILE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateFileInfo(String groupId, String fileId, int version, String newFilename, JSONObject newACL, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.fileId.name(), (Object)fileId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.newFilename.name(), (Object)newFilename);
            data.put(Parameter.newAcl.name(), (Object)newACL);
            ServerCall sc = new ServerCall(ServiceName.groupFile, ServiceOperation.UPDATE_FILE_INFO, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static enum Parameter {
        groupId,
        folderPath,
        filename,
        fullPathFilename,
        fileId,
        version,
        newTreeId,
        treeVersion,
        newFilename,
        overwriteIfPresent,
        recurse,
        userCloudPath,
        userCloudFilename,
        groupTreeId,
        groupFilename,
        groupFileAcl,
        newAcl;

    }
}

