/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.AuthenticationIds;
import com.bitheads.braincloud.client.AuthenticationType;
import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class IdentityService {
    private BrainCloudClient _client;

    public IdentityService(BrainCloudClient client) {
        this._client = client;
    }

    public void attachFacebookIdentity(String facebookId, String authenticationToken, IServerCallback callback) {
        this.attachIdentity(facebookId, authenticationToken, AuthenticationType.Facebook, callback);
    }

    public void mergeFacebookIdentity(String facebookId, String authenticationToken, IServerCallback callback) {
        this.mergeIdentity(facebookId, authenticationToken, AuthenticationType.Facebook, callback);
    }

    public void detachFacebookIdentity(String facebookId, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(facebookId, AuthenticationType.Facebook, continueAnon, callback);
    }

    public void attachAdvancedIdentity(AuthenticationType authenticationType, AuthenticationIds ids, String extraJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.externalId.name(), (Object)ids.externalId);
            data.put(Parameter.authenticationType.name(), (Object)authenticationType.toString());
            data.put(Parameter.authenticationToken.name(), (Object)ids.authenticationToken);
            if (StringUtil.IsOptionalParameterValid(ids.authenticationSubType)) {
                data.put(Parameter.externalAuthName.name(), (Object)ids.authenticationSubType);
            }
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                data.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.ATTACH, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void mergeAdvancedIdentity(AuthenticationType authenticationType, AuthenticationIds ids, String extraJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.externalId.name(), (Object)ids.externalId);
            data.put(Parameter.authenticationType.name(), (Object)authenticationType.toString());
            data.put(Parameter.authenticationToken.name(), (Object)ids.authenticationToken);
            if (StringUtil.IsOptionalParameterValid(ids.authenticationSubType)) {
                data.put(Parameter.externalAuthName.name(), (Object)ids.authenticationSubType);
            }
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                data.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.MERGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void detachAdvancedIdentity(AuthenticationType authenticationType, String externalId, boolean continueAnon, String extraJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.externalId.name(), (Object)externalId);
            data.put(Parameter.authenticationType.name(), (Object)authenticationType.toString());
            data.put(Parameter.confirmAnonymous.name(), continueAnon);
            if (StringUtil.IsOptionalParameterValid(extraJson)) {
                data.put(Parameter.extraJson.name(), (Object)new JSONObject(extraJson));
            }
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.DETACH, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void attachFacebookLimitedIdentity(String facebookLimitedId, String authenticationToken, IServerCallback callback) {
        this.attachIdentity(facebookLimitedId, authenticationToken, AuthenticationType.FacebookLimited, callback);
    }

    public void mergeFacebookLimitedIdentity(String facebookLimitedId, String authenticationToken, IServerCallback callback) {
        this.mergeIdentity(facebookLimitedId, authenticationToken, AuthenticationType.FacebookLimited, callback);
    }

    public void detachFacebookLimitedIdentity(String facebookLimitedId, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(facebookLimitedId, AuthenticationType.FacebookLimited, continueAnon, callback);
    }

    public void attachOculusIdentity(String oculusId, String oculusNonce, IServerCallback callback) {
        this.attachIdentity(oculusId, oculusNonce, AuthenticationType.Oculus, callback);
    }

    public void mergeOculusIdentity(String oculusId, String oculusNonce, IServerCallback callback) {
        this.mergeIdentity(oculusId, oculusNonce, AuthenticationType.Oculus, callback);
    }

    public void detachOculusIdentity(String oculusId, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(oculusId, AuthenticationType.Oculus, continueAnon, callback);
    }

    public void attachGameCenterIdentity(String gameCenterId, IServerCallback callback) {
        this.attachIdentity(gameCenterId, "", AuthenticationType.GameCenter, callback);
    }

    public void mergeGameCenterIdentity(String gameCenterId, IServerCallback callback) {
        this.mergeIdentity(gameCenterId, "", AuthenticationType.GameCenter, callback);
    }

    public void detachGameCenterIdentity(String gameCenterId, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(gameCenterId, AuthenticationType.GameCenter, continueAnon, callback);
    }

    public void attachGoogleIdentity(String googleId, String authenticationToken, IServerCallback callback) {
        this.attachIdentity(googleId, authenticationToken, AuthenticationType.Google, callback);
    }

    public void mergeGoogleIdentity(String googleId, String authenticationToken, IServerCallback callback) {
        this.mergeIdentity(googleId, authenticationToken, AuthenticationType.Google, callback);
    }

    public void detachGoogleIdentity(String googleId, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(googleId, AuthenticationType.Google, continueAnon, callback);
    }

    public void attachGoogleOpenIdIdentity(String googleOpenId, String authenticationToken, IServerCallback callback) {
        this.attachIdentity(googleOpenId, authenticationToken, AuthenticationType.GoogleOpenId, callback);
    }

    public void mergeGoogleOpenIdIdentity(String googleOpenId, String authenticationToken, IServerCallback callback) {
        this.mergeIdentity(googleOpenId, authenticationToken, AuthenticationType.GoogleOpenId, callback);
    }

    public void detachGoogleOpenIdIdentity(String googleOpenId, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(googleOpenId, AuthenticationType.GoogleOpenId, continueAnon, callback);
    }

    public void attachAppleIdentity(String appleId, String authenticationToken, IServerCallback callback) {
        this.attachIdentity(appleId, authenticationToken, AuthenticationType.Apple, callback);
    }

    public void mergeAppleIdentity(String appleId, String authenticationToken, IServerCallback callback) {
        this.mergeIdentity(appleId, authenticationToken, AuthenticationType.Apple, callback);
    }

    public void detachAppleIdentity(String appleId, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(appleId, AuthenticationType.Apple, continueAnon, callback);
    }

    public void attachEmailIdentity(String email, String password, IServerCallback callback) {
        this.attachIdentity(email, password, AuthenticationType.Email, callback);
    }

    public void mergeEmailIdentity(String email, String password, IServerCallback callback) {
        this.mergeIdentity(email, password, AuthenticationType.Email, callback);
    }

    public void detachEmailIdentity(String email, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(email, AuthenticationType.Email, continueAnon, callback);
    }

    public void attachUniversalIdentity(String userId, String password, IServerCallback callback) {
        this.attachIdentity(userId, password, AuthenticationType.Universal, callback);
    }

    public void mergeUniversalIdentity(String userId, String password, IServerCallback callback) {
        this.mergeIdentity(userId, password, AuthenticationType.Universal, callback);
    }

    public void detachUniversalIdentity(String userId, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(userId, AuthenticationType.Universal, continueAnon, callback);
    }

    public void attachSteamIdentity(String steamId, String sessionTicket, IServerCallback callback) {
        this.attachIdentity(steamId, sessionTicket, AuthenticationType.Steam, callback);
    }

    public void mergeSteamIdentity(String steamId, String sessionTicket, IServerCallback callback) {
        this.mergeIdentity(steamId, sessionTicket, AuthenticationType.Steam, callback);
    }

    public void detachSteamIdentity(String steamId, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(steamId, AuthenticationType.Steam, continueAnon, callback);
    }

    public void attachUltraIdentity(String ultraUsername, String ultraIdToken, IServerCallback callback) {
        this.attachIdentity(ultraUsername, ultraIdToken, AuthenticationType.Ultra, callback);
    }

    public void mergeUltraIdentity(String ultraUsername, String ultraIdToken, IServerCallback callback) {
        this.mergeIdentity(ultraUsername, ultraIdToken, AuthenticationType.Ultra, callback);
    }

    public void detachUltraIdentity(String ultraUsername, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(ultraUsername, AuthenticationType.Ultra, continueAnon, callback);
    }

    public void attachTwitterIdentity(String twitterId, String authenticationToken, String secret, IServerCallback callback) {
        String tokenSecretCombo = authenticationToken + ":" + secret;
        this.attachIdentity(twitterId, tokenSecretCombo, AuthenticationType.Twitter, callback);
    }

    public void mergeTwitterIdentity(String twitterId, String authenticationToken, String secret, IServerCallback callback) {
        String tokenSecretCombo = authenticationToken + ":" + secret;
        this.mergeIdentity(twitterId, tokenSecretCombo, AuthenticationType.Twitter, callback);
    }

    public void detachTwitterIdentity(String twitterId, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(twitterId, AuthenticationType.Twitter, continueAnon, callback);
    }

    public void attachParseIdentity(String parseId, String authenticationToken, IServerCallback callback) {
        this.attachIdentity(parseId, authenticationToken, AuthenticationType.Parse, callback);
    }

    public void mergeParseIdentity(String parseId, String authenticationToken, IServerCallback callback) {
        this.mergeIdentity(parseId, authenticationToken, AuthenticationType.Parse, callback);
    }

    public void detachParseIdentity(String parseId, boolean continueAnon, IServerCallback callback) {
        this.detachIdentity(parseId, AuthenticationType.Parse, continueAnon, callback);
    }

    public void switchToChildProfile(String childProfileId, String childAppId, boolean forceCreate, IServerCallback callback) {
        this.switchToChildProfile(childProfileId, childAppId, forceCreate, false, callback);
    }

    public void switchToSingletonChildProfile(String childAppId, boolean forceCreate, IServerCallback callback) {
        this.switchToChildProfile(null, childAppId, forceCreate, true, callback);
    }

    public void attachNonLoginUniversalId(String externalId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.externalId.name(), (Object)externalId);
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.ATTACH_NONLOGIN_UNIVERSAL, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void updateUniversalIdLogin(String externalId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.externalId.name(), (Object)externalId);
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.UPDATE_UNIVERSAL_LOGIN, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void switchToParentProfile(String parentLevelName, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.levelName.name(), (Object)parentLevelName);
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.SWITCH_TO_PARENT_PROFILE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getChildProfiles(boolean includeSummaryData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includePlayerSummaryData.name(), includeSummaryData);
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.GET_CHILD_PROFILES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getIdentities(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.GET_IDENTITIES, null, callback);
        this._client.sendRequest(sc);
    }

    public void getExpiredIdentities(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.GET_EXPIRED_IDENTITIES, null, callback);
        this._client.sendRequest(sc);
    }

    public void refreshIdentity(String externalId, String authenticationToken, AuthenticationType authenticationType, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.externalId.name(), (Object)externalId);
            data.put(Parameter.authenticationType.name(), (Object)authenticationType.toString());
            data.put(Parameter.authenticationToken.name(), (Object)authenticationToken);
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.REFRESH_IDENTITY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void changeEmailIdentity(String oldEmailAddress, String password, String newEmailAddress, boolean updateContactEmail, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.oldEmailAddress.name(), (Object)oldEmailAddress);
            data.put(Parameter.authenticationToken.name(), (Object)password);
            data.put(Parameter.newEmailAddress.name(), (Object)newEmailAddress);
            data.put(Parameter.updateContactEmail.name(), updateContactEmail);
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.CHANGE_EMAIL_IDENTITY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void attachParentWithIdentity(String externalId, String authenticationToken, AuthenticationType authenticationType, String externalAuthName, boolean forceCreate, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.externalId.name(), (Object)externalId);
            data.put(Parameter.authenticationToken.name(), (Object)authenticationToken);
            data.put(Parameter.authenticationType.name(), (Object)authenticationType.toString());
            data.put(Parameter.forceCreate.name(), forceCreate);
            if (StringUtil.IsOptionalParameterValid(externalAuthName)) {
                data.put(Parameter.externalAuthName.name(), (Object)externalAuthName);
            }
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.ATTACH_PARENT_WITH_IDENTITY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void detachParent(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.DETACH_PARENT, null, callback);
        this._client.sendRequest(sc);
    }

    public void attachPeerProfile(String peer, String externalId, String authenticationToken, AuthenticationType authenticationType, String externalAuthName, boolean forceCreate, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.externalId.name(), (Object)externalId);
            data.put(Parameter.authenticationToken.name(), (Object)authenticationToken);
            data.put(Parameter.authenticationType.name(), (Object)authenticationType.toString());
            data.put(Parameter.peer.name(), (Object)peer);
            data.put(Parameter.forceCreate.name(), forceCreate);
            if (StringUtil.IsOptionalParameterValid(externalAuthName)) {
                data.put(Parameter.externalAuthName.name(), (Object)externalAuthName);
            }
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.ATTACH_PEER_PROFILE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void detachPeer(String peer, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.peer.name(), (Object)peer);
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.DETACH_PEER, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void attachBlockchainIdentity(String blockchainConfig, String publicKey, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.blockchainConfig.name(), (Object)blockchainConfig);
            data.put(Parameter.publicKey.name(), (Object)publicKey);
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.ATTACH_BLOCKCHAIN_IDENTITY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void detachBlockchainIdentity(String blockchainConfig, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.blockchainConfig.name(), (Object)blockchainConfig);
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.DETACH_BLOCKCHAIN_IDENTITY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getPeerProfiles(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.GET_PEER_PROFILES, null, callback);
        this._client.sendRequest(sc);
    }

    private void switchToChildProfile(String childProfileId, String childAppId, boolean forceCreate, boolean forceSingleton, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (StringUtil.IsOptionalParameterValid(childProfileId)) {
                data.put(Parameter.profileId.name(), (Object)childProfileId);
            }
            data.put(Parameter.gameId.name(), (Object)childAppId);
            data.put(Parameter.forceCreate.name(), forceCreate);
            data.put(Parameter.forceSingleton.name(), forceSingleton);
            data.put(Parameter.releasePlatform.name(), (Object)this._client.getReleasePlatform());
            data.put(Parameter.countryCode.name(), (Object)this._client.getCountryCode());
            data.put(Parameter.languageCode.name(), (Object)this._client.getLanguageCode());
            data.put(Parameter.timeZoneOffset.name(), this._client.getTimeZoneOffset());
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.SWITCH_TO_CHILD_PROFILE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private void attachIdentity(String externalId, String authenticationToken, AuthenticationType authenticationType, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.externalId.name(), (Object)externalId);
            data.put(Parameter.authenticationType.name(), (Object)authenticationType.toString());
            data.put(Parameter.authenticationToken.name(), (Object)authenticationToken);
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.ATTACH, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void mergeIdentity(String externalId, String authenticationToken, AuthenticationType authenticationType, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.externalId.name(), (Object)externalId);
            data.put(Parameter.authenticationType.name(), (Object)authenticationType.toString());
            data.put(Parameter.authenticationToken.name(), (Object)authenticationToken);
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.MERGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void detachIdentity(String externalId, AuthenticationType authenticationType, boolean continueAnon, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.externalId.name(), (Object)externalId);
            data.put(Parameter.authenticationType.name(), (Object)authenticationType.toString());
            data.put(Parameter.confirmAnonymous.name(), continueAnon);
            ServerCall sc = new ServerCall(ServiceName.identity, ServiceOperation.DETACH, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static enum Parameter {
        externalId,
        authenticationType,
        confirmAnonymous,
        authenticationToken,
        profileId,
        appId,
        gameId,
        forceSingleton,
        includePlayerSummaryData,
        levelName,
        forceCreate,
        releasePlatform,
        countryCode,
        languageCode,
        timeZoneOffset,
        externalAuthName,
        extraJson,
        peer,
        oldEmailAddress,
        newEmailAddress,
        updateContactEmail,
        blockchainConfig,
        publicKey;

    }
}

