/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONException;
import org.json.JSONObject;

public class MailService {
    private BrainCloudClient _client;

    public MailService(BrainCloudClient client) {
        this._client = client;
    }

    public void sendBasicEmail(String profileId, String subject, String body, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileId.name(), (Object)profileId);
            data.put(Parameter.subject.name(), (Object)subject);
            data.put(Parameter.body.name(), (Object)body);
            ServerCall sc = new ServerCall(ServiceName.mail, ServiceOperation.SEND_BASIC_EMAIL, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void sendAdvancedEmail(String profileId, String jsonServiceParams, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileId.name(), (Object)profileId);
            JSONObject jsonData = new JSONObject(jsonServiceParams);
            data.put(Parameter.serviceParams.name(), (Object)jsonData);
            ServerCall sc = new ServerCall(ServiceName.mail, ServiceOperation.SEND_ADVANCED_EMAIL, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void sendAdvancedEmailByAddress(String emailAddress, String jsonServiceParams, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.emailAddress.name(), (Object)emailAddress);
            JSONObject jsonData = new JSONObject(jsonServiceParams);
            data.put(Parameter.serviceParams.name(), (Object)jsonData);
            ServerCall sc = new ServerCall(ServiceName.mail, ServiceOperation.SEND_ADVANCED_EMAIL_BY_ADDRESS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public static enum Parameter {
        profileId,
        emailAddress,
        subject,
        body,
        serviceParams;

    }
}

