/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PlayerStateService {
    private BrainCloudClient _client;

    public PlayerStateService(BrainCloudClient client) {
        this._client = client;
    }

    public void deleteUser(IServerCallback callback) {
        JSONObject message = new JSONObject();
        ServerCall serverCall = new ServerCall(ServiceName.playerState, ServiceOperation.FULL_PLAYER_RESET, message, callback);
        this._client.sendRequest(serverCall);
    }

    public void getAttributes(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.playerState, ServiceOperation.GET_ATTRIBUTES, null, callback);
        this._client.sendRequest(sc);
    }

    public void logout(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.playerState, ServiceOperation.LOGOUT, null, callback);
        this._client.sendRequest(sc);
    }

    public void readUserState(IServerCallback callback) {
        JSONObject message = new JSONObject();
        ServerCall serverCall = new ServerCall(ServiceName.playerState, ServiceOperation.READ, message, callback);
        this._client.sendRequest(serverCall);
    }

    public void removeAttributes(String[] attributeNames, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONArray jsonAtts = new JSONArray();
            for (String att : attributeNames) {
                jsonAtts.put((Object)att);
            }
            data.put(Parameter.attributes.name(), (Object)jsonAtts);
            ServerCall serverCall = new ServerCall(ServiceName.playerState, ServiceOperation.REMOVE_ATTRIBUTES, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void resetUser(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.playerState, ServiceOperation.GAME_DATA_RESET, null, callback);
        this._client.sendRequest(sc);
    }

    public void updateAttributes(String jsonAttributes, boolean wipeExisting, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONObject jsonData = new JSONObject(jsonAttributes);
            data.put(Parameter.attributes.name(), (Object)jsonData);
            data.put(Parameter.wipeExisting.name(), wipeExisting);
            ServerCall serverCall = new ServerCall(ServiceName.playerState, ServiceOperation.UPDATE_ATTRIBUTES, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateTimeZoneOffset(int timeZoneOffset, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.timeZoneOffset.name(), timeZoneOffset);
            ServerCall serverCall = new ServerCall(ServiceName.playerState, ServiceOperation.UPDATE_TIMEZONE_OFFSET, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateLanguageCode(String languageCode, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.languageCode.name(), (Object)languageCode);
            ServerCall serverCall = new ServerCall(ServiceName.playerState, ServiceOperation.UPDATE_LANGUAGE_CODE, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateName(String name, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.playerName.name(), (Object)name);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.playerState, ServiceOperation.UPDATE_NAME, data, callback);
        this._client.sendRequest(sc);
    }

    public void updateUserName(String name, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.playerName.name(), (Object)name);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.playerState, ServiceOperation.UPDATE_NAME, data, callback);
        this._client.sendRequest(sc);
    }

    public void updateSummaryFriendData(String jsonFriendSummaryData, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            JSONObject summaryFriendData = new JSONObject(jsonFriendSummaryData);
            data.put(Parameter.summaryFriendData.name(), (Object)summaryFriendData);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.playerState, ServiceOperation.UPDATE_SUMMARY, data, callback);
        this._client.sendRequest(sc);
    }

    public void updateUserPictureUrl(String pictureUrl, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.playerPictureUrl.name(), (Object)pictureUrl);
            ServerCall serverCall = new ServerCall(ServiceName.playerState, ServiceOperation.UPDATE_PICTURE_URL, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateContactEmail(String contactEmail, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.contactEmail.name(), (Object)contactEmail);
            ServerCall serverCall = new ServerCall(ServiceName.playerState, ServiceOperation.UPDATE_CONTACT_EMAIL, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void clearUserStatus(String statusName, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.statusName.name(), (Object)statusName);
            ServerCall serverCall = new ServerCall(ServiceName.playerState, ServiceOperation.CLEAR_USER_STATUS, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void extendUserStatus(String statusName, int additionalSecs, String details, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.statusName.name(), (Object)statusName);
            data.put(Parameter.additionalSecs.name(), additionalSecs);
            JSONObject detailData = new JSONObject(details);
            data.put(Parameter.details.name(), (Object)detailData);
            ServerCall serverCall = new ServerCall(ServiceName.playerState, ServiceOperation.EXTEND_USER_STATUS, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getUserStatus(String statusName, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.statusName.name(), (Object)statusName);
            ServerCall serverCall = new ServerCall(ServiceName.playerState, ServiceOperation.GET_USER_STATUS, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setUserStatus(String statusName, int durationSecs, String details, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.statusName.name(), (Object)statusName);
            data.put(Parameter.durationSecs.name(), durationSecs);
            JSONObject detailData = new JSONObject(details);
            data.put(Parameter.details.name(), (Object)detailData);
            ServerCall serverCall = new ServerCall(ServiceName.playerState, ServiceOperation.GET_USER_STATUS, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static enum Parameter {
        attributes,
        wipeExisting,
        playerName,
        languageCode,
        timeZoneOffset,
        summaryFriendData,
        playerPictureUrl,
        contactEmail,
        statusName,
        additionalSecs,
        details,
        durationSecs;

    }
}

