/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PresenceService {
    private BrainCloudClient _client;

    public PresenceService(BrainCloudClient client) {
        this._client = client;
    }

    public void forcePush(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.presence, ServiceOperation.FORCE_PUSH, null, callback);
        this._client.sendRequest(sc);
    }

    public void getPresenceOfFriends(String platform, boolean includeOffline, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.platform.name(), (Object)platform);
            data.put(Parameter.includeOffline.name(), includeOffline);
            ServerCall sc = new ServerCall(ServiceName.presence, ServiceOperation.GET_PRESENCE_OF_FRIENDS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getPresenceOfGroup(String groupId, boolean includeOffline, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.includeOffline.name(), includeOffline);
            ServerCall sc = new ServerCall(ServiceName.presence, ServiceOperation.GET_PRESENCE_OF_GROUP, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getPresenceOfUsers(ArrayList<String> profileIds, boolean includeOffline, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileIds.name(), (Object)new JSONArray(profileIds));
            data.put(Parameter.includeOffline.name(), includeOffline);
            ServerCall sc = new ServerCall(ServiceName.presence, ServiceOperation.GET_PRESENCE_OF_USERS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void registerListenersForFriends(String platform, boolean bidirectional, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.platform.name(), (Object)platform);
            data.put(Parameter.bidirectional.name(), bidirectional);
            ServerCall sc = new ServerCall(ServiceName.presence, ServiceOperation.REGISTER_LISTENERS_FOR_FRIENDS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void registerListenersForGroup(String groupId, boolean bidirectional, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.bidirectional.name(), bidirectional);
            ServerCall sc = new ServerCall(ServiceName.presence, ServiceOperation.REGISTER_LISTENERS_FOR_GROUP, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void registerListenersForProfiles(ArrayList<String> profileIds, boolean bidirectional, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileIds.name(), (Object)new JSONArray(profileIds));
            data.put(Parameter.bidirectional.name(), bidirectional);
            ServerCall sc = new ServerCall(ServiceName.presence, ServiceOperation.REGISTER_LISTENERS_FOR_PROFILES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void setVisibility(boolean visible, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.visible.name(), visible);
            ServerCall sc = new ServerCall(ServiceName.presence, ServiceOperation.SET_VISIBILITY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void stopListening(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.presence, ServiceOperation.STOP_LISTENING, null, callback);
        this._client.sendRequest(sc);
    }

    public void updateActivity(String activity, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONObject jsonDataObj = new JSONObject(activity);
            data.put(Parameter.activity.name(), (Object)jsonDataObj);
            ServerCall sc = new ServerCall(ServiceName.presence, ServiceOperation.UPDATE_ACTIVITY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private static enum Parameter {
        platform,
        includeOffline,
        groupId,
        profileIds,
        bidirectional,
        visible,
        activity;

    }
}

