/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IRelayCallback;
import com.bitheads.braincloud.client.IRelayConnectCallback;
import com.bitheads.braincloud.client.IRelaySystemCallback;
import com.bitheads.braincloud.client.RelayConnectionType;
import org.json.JSONObject;

public class RelayService {
    private BrainCloudClient _client;
    public static final long TO_ALL_PLAYERS = 0xFFFFFFFFFFL;
    public static final int CHANNEL_HIGH_PRIORITY_1 = 0;
    public static final int CHANNEL_HIGH_PRIORITY_2 = 1;
    public static final int CHANNEL_NORMAL_PRIORITY = 2;
    public static final int CHANNEL_LOW_PRIORITY = 3;
    public static final int INVALID_NET_ID = 40;

    public RelayService(BrainCloudClient client) {
        this._client = client;
    }

    public void connect(RelayConnectionType connectionType, JSONObject options, IRelayConnectCallback callback) {
        this._client.getRelayComms().connect(connectionType, options, callback);
    }

    public void disconnect() {
        this._client.getRelayComms().disconnect();
    }

    public void endMatch(JSONObject json) {
        this._client.getRelayComms().endMatch(json);
    }

    public boolean isConnected() {
        return this._client.getRelayComms().isConnected();
    }

    public int getPing() {
        return this._client.getRelayComms().getPing();
    }

    public void setPingInterval(int intervalMS) {
        this._client.getRelayComms().setPingInterval(intervalMS);
    }

    public String getOwnerProfileId() {
        return this._client.getRelayComms().getOwnerProfileId();
    }

    public String getProfileIdForNetId(int netId) {
        return this._client.getRelayComms().getProfileIdForNetId(netId);
    }

    public int getNetIdForProfileId(String profileId) {
        return this._client.getRelayComms().getNetIdForProfileId(profileId);
    }

    public String getOwnerCxId() {
        return this._client.getRelayComms().getOwnerCxId();
    }

    public String getCxIdForNetId(int netId) {
        return this._client.getRelayComms().getCxIdForNetId(netId);
    }

    public int getNetIdForCxId(String cxId) {
        return this._client.getRelayComms().getNetIdForCxId(cxId);
    }

    public void registerRelayCallback(IRelayCallback callback) {
        this._client.getRelayComms().registerRelayCallback(callback);
    }

    public void deregisterRelayCallback() {
        this._client.getRelayComms().deregisterRelayCallback();
    }

    public void registerSystemCallback(IRelaySystemCallback callback) {
        this._client.getRelayComms().registerSystemCallback(callback);
    }

    public void deregisterSystemCallback() {
        this._client.getRelayComms().deregisterSystemCallback();
    }

    public void send(byte[] data, long toNetId, boolean reliable, boolean ordered, int channel) {
        if (toNetId == 0xFFFFFFFFFFL) {
            this.sendToAll(data, reliable, ordered, channel);
        } else {
            long playerMask = 1L << (int)toNetId;
            this._client.getRelayComms().sendRelay(data, playerMask, reliable, ordered, channel);
        }
    }

    public void sendToPlayers(byte[] data, long playerMask, boolean reliable, boolean ordered, int channel) {
        this._client.getRelayComms().sendRelay(data, playerMask, reliable, ordered, channel);
    }

    public void sendToAll(byte[] data, boolean reliable, boolean ordered, int channel) {
        String myProfileId = this._client.getAuthenticationService().getProfileId();
        int myNetId = this._client.getRelayComms().getNetIdForProfileId(myProfileId);
        long myBit = 1L << (int)((long)myNetId);
        long myInvertedBits = myBit ^ 0xFFFFFFFFFFFFFFFFL;
        long playerMask = 0xFFFFFFFFFFL & myInvertedBits;
        this._client.getRelayComms().sendRelay(data, playerMask, reliable, ordered, channel);
    }
}

