/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.SocialLeaderboardService;
import com.bitheads.braincloud.services.StringUtil;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class TournamentService {
    private BrainCloudClient _client;

    public TournamentService(BrainCloudClient client) {
        this._client = client;
    }

    public void claimTournamentReward(String leaderboardId, int versionId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.versionId.name(), versionId);
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.CLAIM_TOURNAMENT_REWARD, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getDivisionInfo(String divSetId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.divSetId.name(), (Object)divSetId);
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.GET_DIVISION_INFO, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getMyDivisions(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.GET_MY_DIVISIONS, null, callback);
        this._client.sendRequest(sc);
    }

    public void getTournamentStatus(String leaderboardId, int versionId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.versionId.name(), versionId);
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.GET_TOURNAMENT_STATUS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void joinDivision(String divSetId, String tournamentCode, long initialScore, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.divSetId.name(), (Object)divSetId);
            data.put(Parameter.tournamentCode.name(), (Object)tournamentCode);
            data.put(Parameter.initialScore.name(), initialScore);
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.JOIN_DIVISION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void joinTournament(String leaderboardId, String tournamentCode, long initialScore, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.tournamentCode.name(), (Object)tournamentCode);
            data.put(Parameter.initialScore.name(), initialScore);
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.JOIN_TOURNAMENT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void leaveDivisionInstance(String leaderboardId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.LEAVE_DIVISION_INSTANCE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void leaveTournament(String leaderboardId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.LEAVE_TOURNAMENT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postTournamentScore(String leaderboardId, long score, String jsonData, Date roundStartedTime, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.score.name(), score);
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                JSONObject jsonObj = new JSONObject(jsonData);
                data.put(Parameter.data.name(), (Object)jsonObj);
            }
            data.put(Parameter.roundStartedEpoch.name(), roundStartedTime.getTime());
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.POST_TOURNAMENT_SCORE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postTournamentScoreUTC(String leaderboardId, long score, String jsonData, long roundStartedTimeUTC, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.score.name(), score);
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                JSONObject jsonObj = new JSONObject(jsonData);
                data.put(Parameter.data.name(), (Object)jsonObj);
            }
            data.put(Parameter.roundStartedEpoch.name(), roundStartedTimeUTC);
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.POST_TOURNAMENT_SCORE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postTournamentScoreWithResults(String leaderboardId, long score, String jsonData, Date roundStartedTime, SocialLeaderboardService.SortOrder sort, int beforeCount, int afterCount, long initialScore, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.score.name(), score);
            data.put(Parameter.sort.name(), (Object)sort.name());
            data.put(Parameter.beforeCount.name(), beforeCount);
            data.put(Parameter.afterCount.name(), afterCount);
            data.put(Parameter.initialScore.name(), initialScore);
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                JSONObject jsonObj = new JSONObject(jsonData);
                data.put(Parameter.data.name(), (Object)jsonObj);
            }
            data.put(Parameter.roundStartedEpoch.name(), roundStartedTime.getTime());
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.POST_TOURNAMENT_SCORE_WITH_RESULTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postTournamentScoreWithResultsUTC(String leaderboardId, long score, String jsonData, long roundStartedTimeUTC, SocialLeaderboardService.SortOrder sort, int beforeCount, int afterCount, long initialScore, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.score.name(), score);
            data.put(Parameter.sort.name(), (Object)sort.name());
            data.put(Parameter.beforeCount.name(), beforeCount);
            data.put(Parameter.afterCount.name(), afterCount);
            data.put(Parameter.initialScore.name(), initialScore);
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                JSONObject jsonObj = new JSONObject(jsonData);
                data.put(Parameter.data.name(), (Object)jsonObj);
            }
            data.put(Parameter.roundStartedEpoch.name(), roundStartedTimeUTC);
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.POST_TOURNAMENT_SCORE_WITH_RESULTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void viewCurrentReward(String leaderboardId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.VIEW_CURRENT_REWARD, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void viewReward(String leaderboardId, int versionId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.versionId.name(), versionId);
            ServerCall sc = new ServerCall(ServiceName.tournament, ServiceOperation.VIEW_REWARD, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public static enum Parameter {
        leaderboardId,
        divSetId,
        versionId,
        tournamentCode,
        initialScore,
        data,
        roundStartedEpoch,
        score,
        sort,
        beforeCount,
        afterCount;

    }
}

