/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import com.bitso.exchange.BookOrder;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoUserTransactions {
    public ArrayList<BookOrder> list = new ArrayList();

    public BitsoUserTransactions(JSONArray a) {
        for (int i = 0; i < a.length(); ++i) {
            JSONObject o = a.getJSONObject(i);
            BigDecimal price = new BigDecimal(o.getString("rate"));
            BigDecimal major = new BigDecimal(o.getString("btc"));
            BigDecimal minor = new BigDecimal(o.getString("mxn"));
            BookOrder.TYPE type = BookOrder.TYPE.SELL;
            if (major.compareTo(BigDecimal.ZERO) > 0) {
                type = BookOrder.TYPE.BUY;
            }
            BookOrder order = new BookOrder(price, major, type);
            order.id = o.getString("order_id");
            order.dateTime = o.getString("datetime");
            order.status = BookOrder.STATUS.COMPLETE;
            order.minor = minor;
            this.list.add(order);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (BookOrder o : this.list) {
            sb.append(o);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SORT_ORDER {
        ASCENDING,
        DESCENDING;


        public String getOrder() {
            switch (this) {
                case ASCENDING: {
                    return "asc";
                }
                case DESCENDING: {
                    return "desc";
                }
            }
            return null;
        }
    }
}

