/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import java.math.BigDecimal;
import org.json.JSONObject;

public class BitsoBalance {
    public BigDecimal btcBalance;
    public BigDecimal btcAvailable;
    public BigDecimal btcReserved;
    public BigDecimal mxnBalance;
    public BigDecimal mxnAvailable;
    public BigDecimal mxnReserved;
    @Deprecated
    public BigDecimal fee;
    public BigDecimal feePercent;
    public BigDecimal feeDecimal;

    public BitsoBalance(JSONObject obj) {
        this.btcBalance = new BigDecimal(obj.getString("btc_balance"));
        this.btcAvailable = new BigDecimal(obj.getString("btc_available"));
        this.btcReserved = new BigDecimal(obj.getString("btc_reserved"));
        this.mxnBalance = new BigDecimal(obj.getString("mxn_balance"));
        this.mxnAvailable = new BigDecimal(obj.getString("mxn_available"));
        this.mxnReserved = new BigDecimal(obj.getString("mxn_reserved"));
        this.feePercent = new BigDecimal(obj.getString("fee"));
        this.feeDecimal = this.feePercent.divide(new BigDecimal("100"), 8, 0);
        this.fee = this.feePercent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("====BTC====\nAvailable: ");
        sb.append(this.btcAvailable.toPlainString());
        sb.append("\n Reserved: ");
        sb.append(this.btcReserved.toPlainString());
        sb.append("\n  Balance: ");
        sb.append(this.btcBalance.toPlainString());
        sb.append("\n====MXN====\nAvailable: ");
        sb.append(this.mxnAvailable.toPlainString());
        sb.append("\n Reserved: ");
        sb.append(this.mxnReserved.toPlainString());
        sb.append("\n  Balance: ");
        sb.append(this.mxnBalance.toPlainString());
        sb.append("\n===OTHER===\nFee: ");
        sb.append(this.fee.toPlainString());
        sb.append("\nFee (Decimal): ");
        sb.append(this.feeDecimal.toPlainString());
        sb.append("\nFee (Percent): ");
        sb.append(this.feePercent.toPlainString());
        return sb.toString();
    }
}

