/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import com.bitso.helpers.Helpers;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoTransactions {
    public ArrayList<Transaction> list;

    public BitsoTransactions(JSONArray a) {
        this.list = new ArrayList(a.length());
        for (int i = 0; i < a.length(); ++i) {
            JSONObject o = a.getJSONObject(i);
            Transaction t = new Transaction();
            t.date = Long.parseLong(o.getString("date"));
            t.tid = o.getLong("tid");
            t.price = new BigDecimal(o.getString("price"));
            t.amount = new BigDecimal(o.getString("amount"));
            t.side = Transaction.SIDE.valueOf(o.getString("side").toUpperCase());
            this.list.add(t);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Bitso Recent Transactions\n");
        for (Transaction t : this.list) {
            sb.append(t);
        }
        return sb.toString();
    }

    public static class Transaction {
        long date;
        long tid;
        BigDecimal price;
        BigDecimal amount;
        SIDE side;

        public String toString() {
            return Helpers.fieldPrinter(this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SIDE {
            SELL,
            BUY;

        }
    }
}

