/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import com.bitso.exchange.BookOrder;
import com.bitso.helpers.Helpers;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoUserTransactions {
    @Deprecated
    public ArrayList<BookOrder> list = new ArrayList();
    public ArrayList<BookOrder> trades = new ArrayList();
    public ArrayList<Movement> movements = new ArrayList();

    public BitsoUserTransactions(JSONArray a) {
        for (int i = 0; i < a.length(); ++i) {
            JSONObject o = a.getJSONObject(i);
            String dateTime = o.getString("datetime");
            int transactionType = o.getInt("type");
            if (transactionType == 0 || transactionType == 1) {
                Movement m = new Movement();
                if (transactionType == 0) {
                    m.type = Movement.TYPE.DEPOSIT;
                }
                if (transactionType == 1) {
                    m.type = Movement.TYPE.WITHDRAWAL;
                }
                m.dateTime = dateTime;
                if (o.has("mxn")) {
                    m.mxn = new BigDecimal(o.getString("mxn"));
                } else if (o.has("btc")) {
                    m.btc = new BigDecimal(o.getString("btc"));
                }
                m.method = o.getString("method");
                this.movements.add(m);
                continue;
            }
            if (transactionType != 2) continue;
            BigDecimal price = new BigDecimal(o.getString("rate"));
            BigDecimal major = new BigDecimal(o.getString("btc"));
            BigDecimal minor = new BigDecimal(o.getString("mxn"));
            BookOrder.TYPE type = BookOrder.TYPE.SELL;
            if (major.compareTo(BigDecimal.ZERO) > 0) {
                type = BookOrder.TYPE.BUY;
            }
            BookOrder order = new BookOrder(price, major, type);
            order.id = o.getString("order_id");
            order.dateTime = dateTime;
            order.status = BookOrder.STATUS.COMPLETE;
            order.minor = minor;
            this.trades.add(order);
            this.list.add(order);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Movements\n");
        for (Movement m : this.movements) {
            sb.append(m);
        }
        sb.append("\n\nTrades\n");
        for (BookOrder o : this.trades) {
            sb.append(o);
        }
        return sb.toString();
    }

    public static class Movement {
        public String dateTime;
        public TYPE type;
        public BigDecimal mxn;
        public BigDecimal btc;
        public String method;

        public String toString() {
            return Helpers.fieldPrinter(this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TYPE {
            DEPOSIT,
            WITHDRAWAL;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SORT_ORDER {
        ASCENDING,
        DESCENDING;


        public String getOrder() {
            switch (this) {
                case ASCENDING: {
                    return "asc";
                }
                case DESCENDING: {
                    return "desc";
                }
            }
            return null;
        }
    }
}

