/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import com.bitso.helpers.Helpers;
import java.math.BigDecimal;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoTransfer {
    public String walletAddress;
    public BigDecimal currencyAmount;
    public BigDecimal btcPending;
    public String confirmationCode;
    public String paymentOutletId;
    public String qrImgUri;
    public long createdAt;
    public BigDecimal currencyFees;
    public BigDecimal btcReceived;
    public BigDecimal btcAmount;
    public String currency;
    public String id;
    public String userUri;
    public HashMap<String, Object> fields;
    public BigDecimal currencySettled;
    public long expiresEpoch;
    public STATUS status;

    public BitsoTransfer(JSONObject json) {
        JSONObject o = json.getJSONObject("order");
        this.walletAddress = o.getString("wallet_address");
        this.currencyAmount = new BigDecimal(o.getString("currency_amount"));
        this.btcPending = new BigDecimal(o.getString("btc_pending"));
        this.confirmationCode = o.getString("confirmation_code");
        this.paymentOutletId = o.getString("payment_outlet_id");
        this.qrImgUri = o.getString("qr_img_uri");
        this.createdAt = Long.valueOf(o.getString("created_at"));
        this.currencyFees = new BigDecimal(o.getString("currency_fees"));
        this.btcReceived = new BigDecimal(o.getString("btc_received"));
        this.btcAmount = new BigDecimal(o.getString("btc_amount"));
        this.currency = o.getString("currency");
        this.id = o.getString("id");
        this.userUri = o.getString("user_uri");
        if (o.has("fields")) {
            JSONArray f;
            Object fields = o.get("fields");
            if (fields.getClass() == JSONObject.class) {
                JSONObject f2 = o.getJSONObject("fields");
                this.fields = new HashMap();
                for (String key : f2.keySet()) {
                    this.fields.put(key, f2.get(key));
                }
            } else if (fields.getClass() == JSONArray.class && (f = o.getJSONArray("fields")).length() > 0) {
                System.err.println("Unknown fields format " + json.toString());
            }
        }
        this.currencySettled = new BigDecimal(o.getString("currency_settled"));
        this.expiresEpoch = Long.valueOf(o.getString("expires_epoch"));
        if (o.has("status")) {
            this.status = STATUS.valueOf(o.getString("status"));
        }
    }

    public String toString() {
        return Helpers.fieldPrinter(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATUS {
        pending,
        confirming,
        completed,
        expired;

    }
}

