/*
 * Decompiled with CFR 0.152.
 */
package com.bitso.http;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;

public class BlockingHttpClient {
    private static final String USER_AGENT = "Mozilla/5.0";
    private boolean log = false;
    private long throttleMs = -1L;
    private long lastCallTime = 0L;

    public BlockingHttpClient() {
        new BlockingHttpClient(false);
    }

    public BlockingHttpClient(boolean log) {
        new BlockingHttpClient(log, -1L);
    }

    public BlockingHttpClient(boolean log, long throttleMs) {
        this.log = log;
        this.throttleMs = throttleMs;
    }

    private void log(Object msg) {
        if (this.log) {
            System.out.println(msg);
        }
    }

    private void throttle() throws InterruptedException {
        if (this.throttleMs <= 0L) {
            return;
        }
        long time = System.currentTimeMillis();
        long diff = time - this.lastCallTime;
        if (diff < this.throttleMs) {
            this.log("Throttling request for " + (this.throttleMs - diff));
            Thread.sleep(this.throttleMs - diff);
        }
        this.lastCallTime = System.currentTimeMillis();
    }

    public String get(String url, HashMap<String, String> headers) throws Exception {
        String inputLine;
        this.throttle();
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                con.setRequestProperty(e.getKey(), e.getValue());
            }
            this.log("\nHeaders are \n" + headers.toString());
        }
        con.setRequestProperty("User-Agent", USER_AGENT);
        int responseCode = con.getResponseCode();
        this.log("\nSending 'GET' request to URL : " + url);
        this.log("Response Code : " + responseCode);
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    public String sendGet(String url, HashMap<String, String> headers) throws Exception {
        String inputLine;
        this.throttle();
        HttpGet getRequest = new HttpGet(url);
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                getRequest.addHeader(e.getKey(), e.getValue());
            }
            this.log("\nHeaders are \n" + headers.toString());
        }
        this.log("\nSending 'GET' request to URL : " + url);
        CloseableHttpResponse response = HttpClients.createDefault().execute((HttpUriRequest)getRequest);
        this.log("Response Code : " + response.getStatusLine().getStatusCode());
        BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuffer responseBody = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            responseBody.append(inputLine);
        }
        in.close();
        this.log(response);
        this.log(responseBody);
        return responseBody.toString();
    }

    public String get(String url) throws Exception {
        return this.get(url, null);
    }

    public String sendPost(String url, String body, HashMap<String, String> headers) throws Exception {
        return this.sendPost(url, (AbstractHttpEntity)new StringEntity(body), headers);
    }

    public String sendPost(String url, String body, HashMap<String, String> headers, Charset charset) throws Exception {
        return this.sendPost(url, (AbstractHttpEntity)new StringEntity(body, charset), headers);
    }

    public String sendPost(String url, byte[] body, HashMap<String, String> headers) throws Exception {
        return this.sendPost(url, (AbstractHttpEntity)new ByteArrayEntity(body), headers);
    }

    private String sendPost(String url, AbstractHttpEntity body, HashMap<String, String> headers) throws Exception {
        String inputLine;
        this.throttle();
        HttpPost postRequest = new HttpPost(url);
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                postRequest.addHeader(e.getKey(), e.getValue());
            }
            this.log("\nHeaders are \n" + headers.toString());
        }
        postRequest.setEntity((HttpEntity)body);
        this.log("\nSending 'POST' request to URL : " + url);
        this.log("Post parameters : " + body.getContent());
        CloseableHttpResponse response = HttpClients.createDefault().execute((HttpUriRequest)postRequest);
        this.log("Response Code : " + response.getStatusLine().getStatusCode());
        BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuffer responseBody = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            responseBody.append(inputLine);
        }
        in.close();
        this.log(response);
        this.log(responseBody);
        return responseBody.toString();
    }

    public String sendDelete(String url, HashMap<String, String> headers) throws Exception {
        String inputLine;
        this.throttle();
        HttpDelete deleteRequest = new HttpDelete(url);
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                deleteRequest.addHeader(e.getKey(), e.getValue());
            }
            this.log("\nHeaders are \n" + headers.toString());
        }
        this.log("\nSending 'DELETE' request to URL : " + url);
        CloseableHttpResponse response = HttpClients.createDefault().execute((HttpUriRequest)deleteRequest);
        this.log("Response Code : " + response.getStatusLine().getStatusCode());
        BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuffer responseBody = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            responseBody.append(inputLine);
        }
        in.close();
        this.log(response);
        this.log(responseBody);
        return responseBody.toString();
    }
}

