/*
 * Decompiled with CFR 0.152.
 */
package com.bitso.websockets;

import com.bitso.helpers.Helpers;
import com.bitso.websockets.BitsoStreamUpdate;
import com.bitso.websockets.BitsoWebSocketPublicOrder;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoStreamDiffOrders
extends BitsoStreamUpdate {
    private BitsoWebSocketPublicOrder[] mPayload;
    private int mSequenceNumber;

    public BitsoStreamDiffOrders(JSONObject jsonObject) {
        super(jsonObject);
        this.mSequenceNumber = Helpers.getInt(jsonObject, "sequence");
        this.processPayload(jsonObject.getJSONArray("payload"));
    }

    public BitsoWebSocketPublicOrder[] getPayload() {
        return this.mPayload;
    }

    public int getSequenceNumber() {
        return this.mSequenceNumber;
    }

    private void processPayload(JSONArray jsonArray) {
        int totalElements = jsonArray.length();
        this.mPayload = new BitsoWebSocketPublicOrder[totalElements];
        for (int i = 0; i < totalElements; ++i) {
            this.mPayload[i] = new BitsoWebSocketPublicOrder(jsonArray.getJSONObject(i));
        }
    }

    public boolean attributesNotNull() {
        return this.bitsoChannel != null && this.bitsoBook != null && this.payloadNotNull();
    }

    protected boolean payloadNotNull() {
        for (BitsoWebSocketPublicOrder diffPayload : this.mPayload) {
            if (diffPayload.getOrderDate() != null && diffPayload.getRate() != null && diffPayload.getSide() != null && diffPayload.getAmount() != null && diffPayload.getValue() != null && diffPayload.getOrderId() != null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "New Order: \n" + Arrays.toString(this.mPayload);
    }
}

