/*
 * Decompiled with CFR 0.152.
 */
package com.bitso.websockets;

import com.bitso.helpers.Helpers;
import com.bitso.websockets.BitsoStreamUpdate;
import java.math.BigDecimal;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoStreamTrades
extends BitsoStreamUpdate {
    private TradePayload[] payload;

    public BitsoStreamTrades(JSONObject jsonObject) {
        super(jsonObject);
        this.processPayload(jsonObject.getJSONArray("payload"));
    }

    public TradePayload[] getPayload() {
        return this.payload;
    }

    private void processPayload(JSONArray jsonArray) {
        int totalElements = jsonArray.length();
        this.payload = new TradePayload[totalElements];
        for (int i = 0; i < totalElements; ++i) {
            this.payload[i] = new TradePayload(jsonArray.getJSONObject(i));
        }
    }

    public boolean attributesNotNull() {
        return this.bitsoChannel != null && this.bitsoBook != null && this.payloadNotNull();
    }

    private boolean payloadNotNull() {
        for (TradePayload tradePayload : this.payload) {
            if (tradePayload.mTradeId != -1 && tradePayload.mAmount != null && tradePayload.mRate != null && tradePayload.mValue != null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "New Trade: \n" + Arrays.toString(this.payload);
    }

    public class TradePayload {
        private int mTradeId;
        private BigDecimal mAmount;
        private BigDecimal mRate;
        private BigDecimal mValue;

        public TradePayload(JSONObject o) {
            this.mTradeId = Helpers.getInt(o, "i");
            this.mAmount = new BigDecimal(String.valueOf(o.getDouble("a")));
            this.mRate = new BigDecimal(String.valueOf(o.getDouble("r")));
            this.mValue = new BigDecimal(String.valueOf(o.getDouble("v")));
        }

        public int getTradeId() {
            return this.mTradeId;
        }

        public BigDecimal getAmount() {
            return this.mAmount;
        }

        public BigDecimal getRate() {
            return this.mRate;
        }

        public BigDecimal getValue() {
            return this.mValue;
        }

        public String toString() {
            return "Amount:" + this.mAmount + ", Rate:" + this.mRate + ", Value=" + this.mValue;
        }
    }
}

